/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LicenseHandler<B>
extends GovernanceDefinitionHandler<B> {
    public LicenseHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int countLicenses(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, elementGUID, "Referenceable", "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLicenses(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getLicenses(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLicenses(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", null, "LicenseType", 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList results = new ArrayList();
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityParameterName = "entityProxyTwo.getGUID";
                EntityDetail entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxyTwo.getGUID", "LicenseType", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                results.add(this.converter.getNewBean(this.beanClass, entity, relationship, methodName));
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        return null;
    }

    public String licenseElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementTypeName, String licenseTypeGUID, String licenseTypeGUIDParameterName, String licenseTypeGUIDTypeName, String licenseGUID, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementTypeName, licenseTypeGUID, licenseTypeGUIDParameterName, licenseTypeGUIDTypeName, forLineage, forDuplicateProcessing, this.supportedZones, "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", this.getLicenseProperties(licenseGUID, start, end, conditions, licensedBy, licensedByTypeName, licensedByPropertyName, custodian, custodianTypeName, custodianPropertyName, licensee, licenseeTypeName, licenseePropertyName, notes, effectiveFrom, effectiveTo, methodName), effectiveTime, methodName);
    }

    public void updateLicense(String userId, String externalSourceGUID, String externalSourceName, String licenseGUID, String licenseGUIDParameterName, String licenseId, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, licenseGUID, licenseGUIDParameterName, "License", isMergeUpdate, this.getLicenseProperties(licenseId, start, end, conditions, licensedBy, licensedByTypeName, licensedByPropertyName, custodian, custodianTypeName, custodianPropertyName, licensee, licenseeTypeName, licenseePropertyName, notes, effectiveFrom, effectiveTo, methodName), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    private InstanceProperties getLicenseProperties(String licenseId, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, Date effectiveFrom, Date effectiveTo, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "licenseGUID", licenseId, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "start", start, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "end", end, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "conditions", conditions, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licensedBy", licensedBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licensedByTypeName", licensedByTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licensedByPropertyName", licensedByPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodian", custodian, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodianTypeName", custodianTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodianPropertyName", custodianPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licensee", licensee, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licenseeTypeName", licenseeTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "licenseePropertyName", licenseePropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "notes", notes, methodName);
        return this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
    }

    public void unlicenseElement(String userId, String externalSourceGUID, String externalSourceName, String licenseGUID, String licenseGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelationship(userId, externalSourceGUID, externalSourceName, licenseGUID, licenseGUIDParameterName, "License", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

