/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private String displayName = null;
    private String description = null;

    LocationBuilder(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
    }

    LocationBuilder(String qualifiedName, String identifier, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
    }

    LocationBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "identifier", this.identifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        return properties;
    }

    InstanceProperties getFixedLocationProperties(String coordinates, String mapProjection, String postalAddress, String timeZone, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "coordinates", coordinates, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "mapProjection", mapProjection, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "postalAddress", postalAddress, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "timezone", timeZone, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSecureLocationProperties(String description, String level, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "level", level, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCyberLocationProperties(String networkAddress, String methodName) {
        return this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "networkAddress", networkAddress, methodName);
    }
}

