/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.ClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataClassAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataProfileAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataProfileLogAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourceMeasurementAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentRelationshipAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentValueAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentClassificationAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentRelationshipAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentValueAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.RelationshipAdviceAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SemanticAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class ODFConverter<B>
extends OCFConverter<B> {
    public ODFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected Annotation getAnnotationBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "ClassificationAnnotation")) {
                return this.getNewClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataClassAnnotation")) {
                return this.getNewDataClassAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataProfileAnnotation")) {
                return this.getNewDataProfileAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataProfileLogAnnotation")) {
                return this.getNewDataProfileLogAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataSourcePhysicalStatusAnnotation")) {
                return this.getNewDataSourcePhysicalStatusAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DataSourceMeasurementAnnotation")) {
                return this.getNewDataSourceMeasurementAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentValueAnnotation")) {
                return this.getNewDivergentValueAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentClassificationAnnotation")) {
                return this.getNewDivergentClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentRelationshipAnnotation")) {
                return this.getNewDivergentRelationshipAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentAnnotation")) {
                return this.getNewDivergentAttachmentValueAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentClassificationAnnotation")) {
                return this.getNewDivergentAttachmentClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "DivergentAttachmentRelationshipAnnotation")) {
                return this.getNewDivergentAttachmentRelationshipAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "QualityAnnotation")) {
                return this.getNewQualityAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "RelationshipAdviceAnnotation")) {
                return this.getNewRelationshipAdviceAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "RequestForActionAnnotation")) {
                return this.getNewRequestForActionAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SchemaAnalysisAnnotation")) {
                return this.getNewSchemaAnalysisAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SemanticAnnotation")) {
                return this.getNewSemanticAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "SuspectDuplicateAnnotation")) {
                return this.getNewSuspectDuplicateAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Annotation")) {
                return this.getNewAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType("Annotation", beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Annotation getNewClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ClassificationAnnotation annotation = new ClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateClassifications(this.removeCandidateClassifications(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataClassAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataClassAnnotation annotation = new DataClassAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateDataClassGUIDs(this.removeCandidateDataClassGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataProfileAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataProfileAnnotation annotation = new DataProfileAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setLength(this.removeLength(remainingProperties));
            annotation.setInferredDataType(this.removeInferredDataType(remainingProperties));
            annotation.setInferredFormat(this.removeInferredFormat(remainingProperties));
            annotation.setInferredLength(this.removeInferredLength(remainingProperties));
            annotation.setInferredPrecision(this.removeInferredPrecision(remainingProperties));
            annotation.setInferredScale(this.removeInferredScale(remainingProperties));
            annotation.setProfileProperties(this.removeProfileProperties(remainingProperties));
            annotation.setProfileFlags(this.removeProfileFlags(remainingProperties));
            annotation.setProfileCounts(this.removeProfileCounts(remainingProperties));
            annotation.setValueList(this.removeValueList(remainingProperties));
            annotation.setValueCount(this.removeValueCount(remainingProperties));
            annotation.setValueRangeFrom(this.removeValueRangeFrom(remainingProperties));
            annotation.setValueRangeTo(this.removeValueRangeTo(remainingProperties));
            annotation.setAverageValue(this.removeAverageValue(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataProfileLogAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataProfileLogAnnotation annotation = new DataProfileLogAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            ArrayList<String> dataProfileLogNames = new ArrayList<String>();
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy endTwo;
                    if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DataProfileLogFile") || (endTwo = relationship.getEntityTwoProxy()) == null) continue;
                    String name = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", endTwo.getUniqueProperties(), methodName);
                    if (name == null) {
                        name = endTwo.getGUID();
                    }
                    dataProfileLogNames.add(name);
                }
            }
            annotation.setDataProfileLogFileNames(dataProfileLogNames);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourceMeasurementAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataSourceMeasurementAnnotation annotation = new DataSourceMeasurementAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDataSourceProperties(this.removeDataSourceProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourcePhysicalStatusAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataSourcePhysicalStatusAnnotation annotation = new DataSourcePhysicalStatusAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDataSourceProperties(this.removeDataSourceProperties(remainingProperties));
            annotation.setCreateTime(this.removeSourceCreateTime(remainingProperties));
            annotation.setModifiedTime(this.removeSourceUpdateTime(remainingProperties));
            annotation.setSize(this.removeSize(remainingProperties));
            annotation.setEncoding(this.removeEncoding(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentValueAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentValueAnnotation annotation = new DivergentValueAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentPropertyNames(this.removeDivergentPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentClassificationAnnotation annotation = new DivergentClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentClassificationName(this.removeDivergentClassificationName(remainingProperties));
            annotation.setDivergentClassificationPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentRelationshipAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentRelationshipAnnotation annotation = new DivergentRelationshipAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentRelationshipGUID(this.removeDivergentRelationshipGUID(remainingProperties));
            annotation.setDivergentRelationshipPropertyNames(this.removeDivergentRelationshipPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentValueAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentValueAnnotation annotation = new DivergentAttachmentValueAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentPropertyNames(this.removeDivergentPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentClassificationAnnotation annotation = new DivergentAttachmentClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentClassificationName(this.removeDivergentClassificationName(remainingProperties));
            annotation.setDivergentClassificationPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDivergentAttachmentRelationshipAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DivergentAttachmentRelationshipAnnotation annotation = new DivergentAttachmentRelationshipAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setAttachmentGUID(this.removeAttachmentGUID(remainingProperties));
            annotation.setDuplicateAttachmentGUID(this.removeDuplicateAttachmentGUID(remainingProperties));
            annotation.setDuplicateAnchorGUID(this.removeDuplicateAnchorGUID(remainingProperties));
            annotation.setDivergentRelationshipGUID(this.removeDivergentRelationshipGUID(remainingProperties));
            annotation.setDivergentRelationshipPropertyNames(this.removeDivergentClassificationPropertyNames(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewQualityAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            QualityAnnotation annotation = new QualityAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setQualityDimension(this.removeQualityDimension(remainingProperties));
            annotation.setQualityScore(this.removeQualityScore(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRelationshipAdviceAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RelationshipAdviceAnnotation annotation = new RelationshipAdviceAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setRelatedEntityGUID(this.removeRelatedEntityGUID(remainingProperties));
            annotation.setRelationshipTypeName(this.removeRelationshipTypeName(remainingProperties));
            annotation.setRelationshipProperties(this.removeRelationshipProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRequestForActionAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RequestForActionAnnotation annotation = new RequestForActionAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDiscoveryActivity(this.removeDiscoveryActivity(remainingProperties));
            annotation.setActionRequested(this.removeActionRequested(remainingProperties));
            annotation.setActionProperties(this.removeActionProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSchemaAnalysisAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SchemaAnalysisAnnotation annotation = new SchemaAnalysisAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setSchemaName(this.removeSchemaName(remainingProperties));
            annotation.setSchemaTypeName(this.removeSchemaType(remainingProperties));
            int dataFieldCount = 0;
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveredDataField")) continue;
                    ++dataFieldCount;
                }
            }
            annotation.setDiscoveredDataFields(dataFieldCount);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSemanticAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SemanticAnnotation annotation = new SemanticAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setInformalTerm(this.removeInformalTerm(remainingProperties));
            annotation.setCandidateGlossaryTermGUIDs(this.removeCandidateGlossaryTermGUIDs(remainingProperties));
            annotation.setInformalTopic(this.removeInformalTopic(remainingProperties));
            annotation.setCandidateGlossaryCategoryGUIDs(this.removeCandidateGlossaryCategoryGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSuspectDuplicateAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SuspectDuplicateAnnotation annotation = new SuspectDuplicateAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setDuplicateAnchorGUIDs(this.removeDuplicateAnchorGUIDs(remainingProperties));
            annotation.setMatchingPropertyNames(this.removeMatchingPropertyNames(remainingProperties));
            annotation.setMatchingClassificationNames(this.removeMatchingClassificationNames(remainingProperties));
            annotation.setMatchingAttachmentGUIDs(this.removeMatchingAttachmentGUIDs(remainingProperties));
            annotation.setMatchingRelationshipGUIDs(this.removeMatchingRelationshipGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Annotation annotation = new Annotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private InstanceProperties fillInCommonAnnotationProperties(Class<B> beanClass, Annotation annotation, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        annotation.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
        InstanceProperties instanceProperties = null;
        if (primaryEntity.getProperties() != null) {
            instanceProperties = new InstanceProperties(primaryEntity.getProperties());
        }
        annotation.setAnnotationType(this.removeAnnotationType(instanceProperties));
        annotation.setSummary(this.removeSummary(instanceProperties));
        annotation.setConfidenceLevel(this.removeConfidenceLevel(instanceProperties));
        annotation.setExpression(this.removeExpression(instanceProperties));
        annotation.setExplanation(this.removeExplanation(instanceProperties));
        annotation.setAnalysisStep(this.removeAnalysisStep(instanceProperties));
        annotation.setJsonProperties(this.removeJsonProperties(instanceProperties));
        annotation.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        if (supplementaryEntities != null) {
            for (EntityDetail entity : supplementaryEntities) {
                String actualTypeName;
                if (entity == null || entity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName = entity.getType().getTypeDefName(), "AnnotationReview")) continue;
                InstanceProperties properties = new InstanceProperties(entity.getProperties());
                annotation.setReviewDate(this.removeReviewDate(properties));
                annotation.setSteward(this.removeSteward(properties));
                annotation.setReviewComment(this.removeComment(properties));
            }
        }
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AnnotationReviewLink")) continue;
                annotation.setAnnotationStatus(this.getAnnotationStatusFromProperties(instanceProperties));
            }
        }
        return instanceProperties;
    }

    private AnnotationStatus getAnnotationStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        AnnotationStatus requestStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("annotationStatus")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = AnnotationStatus.NEW_ANNOTATION;
                    break;
                }
                case 1: {
                    requestStatus = AnnotationStatus.REVIEWED_ANNOTATION;
                    break;
                }
                case 2: {
                    requestStatus = AnnotationStatus.APPROVED_ANNOTATION;
                    break;
                }
                case 3: {
                    requestStatus = AnnotationStatus.ACTIONED_ANNOTATION;
                    break;
                }
                case 4: {
                    requestStatus = AnnotationStatus.INVALID_ANNOTATION;
                    break;
                }
                case 5: {
                    requestStatus = AnnotationStatus.IGNORE_ANNOTATION;
                    break;
                }
                case 98: {
                    requestStatus = AnnotationStatus.OTHER_STATUS;
                    break;
                }
                default: {
                    requestStatus = AnnotationStatus.UNKNOWN_STATUS;
                }
            }
        }
        return requestStatus;
    }
}

