/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProjectHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public ProjectHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createProject(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectStatus, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean setCampaignClassification, boolean setTaskClassification, String projectTypeClassification, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "Project";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Project", this.serviceName, methodName, this.repositoryHelper);
        ProjectBuilder builder = new ProjectBuilder(qualifiedName, identifier, name, description, startDate, plannedEndDate, projectStatus, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (setCampaignClassification) {
            builder.setCampaignClassification(userId, methodName);
        } else if (setTaskClassification) {
            builder.setTaskClassification(userId, methodName);
        }
        if (projectTypeClassification != null) {
            builder.setProjectTypeClassification(userId, projectTypeClassification, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public String createProjectFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String identifier, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        ProjectBuilder builder = new ProjectBuilder(qualifiedName, identifier, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", qualifiedName, qualifiedNameParameterName, builder, this.supportedZones, methodName);
    }

    public void updateProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectStatus, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(projectGUID, projectGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "Project";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Project", this.serviceName, methodName, this.repositoryHelper);
        ProjectBuilder builder = new ProjectBuilder(qualifiedName, identifier, name, description, startDate, plannedEndDate, projectStatus, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addActorToProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String actorProfileGUID, String actorProfileGUIDParameterName, String teamRole, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "teamRole", teamRole, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", actorProfileGUID, actorProfileGUIDParameterName, "ActorProfile", forLineage, forDuplicateProcessing, this.supportedZones, "746875af-2e41-4d1f-864b-35265df1d5dc", "ProjectTeam", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeActorFromProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String actorProfileGUID, String actorProfileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", actorProfileGUID, actorProfileGUIDParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", forLineage, forDuplicateProcessing, "746875af-2e41-4d1f-864b-35265df1d5dc", "ProjectTeam", effectiveTime, methodName);
    }

    public void addSubProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String subprojectGUID, String subprojectGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", subprojectGUID, subprojectGUIDParameterName, "Project", forLineage, forDuplicateProcessing, this.supportedZones, "8f1134f6-b9fe-4971-bc57-6e1b8b302b55", "ProjectHierarchy", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeSubProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String subprojectProfileGUID, String subprojectGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", subprojectProfileGUID, subprojectGUIDParameterName, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", forLineage, forDuplicateProcessing, "8f1134f6-b9fe-4971-bc57-6e1b8b302b55", "ProjectHierarchy", effectiveTime, methodName);
    }

    public void addProjectDependency(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String dependsOnProjectGUID, String dependsOnProjectGUIDParameterName, String dependencySummary, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "dependencySummary", dependencySummary, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", dependsOnProjectGUID, dependsOnProjectGUIDParameterName, "Project", forLineage, forDuplicateProcessing, this.supportedZones, "5b6a56f1-68e2-4e10-85f0-fda47a4263fd", "ProjectDependency", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeProjectDependency(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String dependsOnProjectGUID, String dependsOnProjectGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", dependsOnProjectGUID, dependsOnProjectGUIDParameterName, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", forLineage, forDuplicateProcessing, "5b6a56f1-68e2-4e10-85f0-fda47a4263fd", "ProjectDependency", effectiveTime, methodName);
    }

    public void addProjectManager(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String personRoleGUID, String personRoleGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", personRoleGUID, personRoleGUIDParameterName, "PersonRole", forLineage, forDuplicateProcessing, this.supportedZones, "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeProjectManager(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String personRoleGUID, String personRoleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "Project", personRoleGUID, personRoleGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", forLineage, forDuplicateProcessing, "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", effectiveTime, methodName);
    }

    public void removeProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findProjects(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getProjectsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(qualifiedNameParameterName);
        specificMatchPropertyNames.add("identifier");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getProjects(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getActorProjects(String userId, String profileGUID, String profileGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, profileGUID, profileGUIDParameterName, "ActorProfile", "746875af-2e41-4d1f-864b-35265df1d5dc", "ProjectTeam", "Project", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getRoleProjects(String userId, String personRoleGUID, String personRoleGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, personRoleGUID, personRoleGUIDParameterName, "PersonRole", "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", "Project", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getDependentProjects(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, "PersonRole", "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", "Project", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getDependsOnProjects(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, "PersonRole", "ac63ac45-a4d0-4fba-b583-92859de77dd8", "ProjectManagement", "Project", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSuperProjects(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, "Project", "8f1134f6-b9fe-4971-bc57-6e1b8b302b55", "ProjectHierarchy", "Project", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSubProjects(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, "Project", "8f1134f6-b9fe-4971-bc57-6e1b8b302b55", "ProjectHierarchy", "Project", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public B getProjectByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Project", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

