/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelatedAssetHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public RelatedAssetHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int getRelatedAssetCount(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String relationshipTypeGUID, String relationshipTypeName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<B> relatedAssets = this.getRelatedAssets(userId, elementGUID, elementGUIDParameterName, elementTypeName, relationshipTypeGUID, relationshipTypeName, "Asset", serviceSupportedZones, 0, 0, this.invalidParameterHandler.getMaxPagingSize(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relatedAssets == null) {
            return 0;
        }
        return relatedAssets.size();
    }

    public List<B> getRelatedAssets(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String relationshipTypeGUID, String relationshipTypeName, String relatedAssetsTypeName, List<String> serviceSupportedZones, int startingEnd, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, elementGUID, elementGUIDParameterName, elementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, elementGUIDParameterName, elementTypeName, relationshipTypeGUID, relationshipTypeName, null, "Asset", 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        String entityGUIDParameterName = "entityProxy.getGUID()";
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy otherEnd;
                if (relationship == null || startingEnd != 0 && (startingEnd != 1 || !startingEntity.getGUID().equals(relationship.getEntityOneProxy().getGUID())) && (startingEnd != 2 || !startingEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) || (otherEnd = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), elementTypeName, relationship, 0, methodName)) == null || otherEnd.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, otherEnd.getType().getTypeDefName(), relatedAssetsTypeName)) continue;
                try {
                    Object bean;
                    EntityDetail entity = this.getEntityFromRepository(userId, otherEnd.getGUID(), "entityProxy.getGUID()", otherEnd.getType().getTypeDefName(), null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, relationship, methodName)) == null) continue;
                    results.add(bean);
                }
                catch (UserNotAuthorizedException userNotAuthorizedException) {}
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

