/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler<B>
extends SchemaElementHandler<B> {
    private final OpenMetadataAPIGenericConverter<B> schemaTypeConverter;

    public SchemaTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeConverter = converter;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), schemaTypeBuilder, effectiveTime, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", schemaTypeBuilder.getTypeName(), schemaTypeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return schemaTypeGUID;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addPrimitiveSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "PrimitiveSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PrimitiveSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addLiteralSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String fixedValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "LiteralSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "LiteralSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setFixedValue(fixedValue);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addEnumSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, String validValuesSetGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "EnumSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EnumSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        builder.setValidValuesSetGUID(validValuesSetGUID);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addStructSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "StructSchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "StructSchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addSchemaTypeChoice(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaTypeChoice";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaTypeChoice", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addMapSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String fromGUIDParameterName = "mapFromSchemaTypeGUID";
        String toGUIDParameterName = "mapToSchemaTypeGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(mapFromSchemaTypeGUID, "mapFromSchemaTypeGUID", methodName);
        this.invalidParameterHandler.validateGUID(mapToSchemaTypeGUID, "mapToSchemaTypeGUID", methodName);
        String typeName = "SchemaTypeChoice";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaTypeChoice", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setMapGUIDs(mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createSchemaTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", qualifiedName, "qualifiedName", builder, this.supportedZones, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = builder.getInstanceProperties(methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, this.getSchemaTypeTypeGUID(builder), this.getSchemaTypeTypeName(builder), forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String elementGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", builder, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private String getSchemaTypeTypeGUID(SchemaTypeBuilder builder) {
        if (builder.getTypeGUID() != null) {
            return builder.getTypeGUID();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaTypeBuilder builder) {
        if (builder.getTypeName() != null) {
            return builder.getTypeName();
        }
        return "SchemaType";
    }

    public void removeSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForAsset(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, assetGUID, assetGUIDParameterName, "Asset", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForPort(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, portGUID, portGUIDParameterName, "Port", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForParent(String userId, String parentGUID, String parentGUIDParameterName, String parentTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, parentGUID, parentGUIDParameterName, parentTypeName, relationshipTypeGUID, relationshipTypeName, "SchemaType", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupSchemaTypeParent(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", "SchemaType", forLineage, forDuplicateProcessing, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        } else {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", "SchemaType", forLineage, forDuplicateProcessing, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
    }

    public void clearSchemaTypeParent(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", forLineage, forDuplicateProcessing, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", effectiveTime, methodName);
        } else {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", forLineage, forDuplicateProcessing, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", effectiveTime, methodName);
        }
    }

    public List<B> getNestedSchemaTypesForParent(String userId, String parentGUID, String parentGUIDParameterName, String parentTypeName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaTypeEntities;
        EntityDetail parentEntity = this.getEntityFromRepository(userId, parentGUID, parentGUIDParameterName, parentTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (parentEntity != null && (schemaTypeEntities = this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), "APISchemaType") ? this.getAttachedEntities(userId, parentEntity, parentGUIDParameterName, parentTypeName, "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", "SchemaType", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName) : this.getAttachedEntities(userId, parentEntity, parentGUIDParameterName, parentTypeName, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "SchemaType", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName)) != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail schemaTypeEntity : schemaTypeEntities) {
                B schemaTypeBean = this.getSchemaTypeFromEntity(userId, schemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(schemaTypeBean);
            }
            return results;
        }
        return null;
    }

    public B getSchemaType(String userId, String schemaTypeGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getEntityFromRepository(userId, schemaTypeGUID, guidParameterName, "SchemaType", null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findSchemaTypes(String userId, String suppliedTypeName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        List<EntityDetail> entities = this.findEntities(userId, searchString, "searchString", typeGUID, typeName, null, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSchemaTypeByName(String userId, String suppliedTypeName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        String typeName = "SchemaType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", this.serviceName, methodName, this.repositoryHelper);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForElement(String userId, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentElementGUID";
        String schemaTypeGUIDParameterName = "schemaTypeEnd.getGUID";
        List<Relationship> relationships = this.getAttachmentLinks(userId, parentElementGUID, "parentElementGUID", parentElementTypeName, null, null, null, null, 0, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AssetSchemaType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AssetSchemaType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "SchemaAttributeType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "LinkedExternalSchemaType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "MapFromElementType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "MapToElementType")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DerivedSchemaTypeQueryTarget")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "PortSchema")) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "SolutionPortSchema")) continue;
                return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private List<B> getSchemaTypesFromEntities(String userId, List<EntityDetail> schemaTypeEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (schemaTypeEntities != null) {
            for (EntityDetail entity : schemaTypeEntities) {
                if (entity == null) continue;
                results.add(this.getSchemaTypeFromEntity(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            return this.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaTypeEntity, schemaTypeEntity.getType().getTypeDefName(), schemaTypeEntity.getProperties(), schemaTypeEntity.getClassifications(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public B getSchemaTypeFromInstance(String userId, InstanceHeader schemaRootHeader, String schemaRootTypeName, InstanceProperties instanceProperties, List<Classification> entityClassifications, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaTypeOptionsEntities;
        EntityDetail externalSchemaTypeEntity;
        String schemaGUIDParameterName = "schemaRootGUID";
        int attributeCount = 0;
        String validValuesSetGUID = null;
        String externalSchemaTypeGUID = null;
        Object externalSchemaType = null;
        String mapToSchemaTypeGUID = null;
        Object mapToSchemaType = null;
        String mapFromSchemaTypeGUID = null;
        Object mapFromSchemaType = null;
        ArrayList<String> schemaTypeOptionGUIDs = null;
        ArrayList<B> schemaTypeOptions = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ExternalSchemaType") && (externalSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "9a5d78c2-1716-4783-bfc6-c300a9e2d092", "LinkedExternalSchemaType", "SchemaType", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
            externalSchemaTypeGUID = externalSchemaTypeEntity.getGUID();
            externalSchemaType = this.getSchemaTypeFromEntity(userId, externalSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ComplexSchemaType")) {
            attributeCount = this.countSchemaAttributes(userId, schemaRootHeader.getGUID(), "schemaRootGUID", effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "EnumSchemaType")) {
            EntityDetail validValuesSetEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValuesSet", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (validValuesSetEntity != null) {
                validValuesSetGUID = validValuesSetEntity.getGUID();
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "MapSchemaType")) {
            EntityDetail mapToSchemaTypeEntity;
            EntityDetail mapFromSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", "SchemaType", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (mapFromSchemaTypeEntity != null) {
                mapFromSchemaTypeGUID = mapFromSchemaTypeEntity.getGUID();
                mapFromSchemaType = this.getSchemaTypeFromEntity(userId, mapFromSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if ((mapToSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", "SchemaType", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
                mapToSchemaTypeGUID = mapToSchemaTypeEntity.getGUID();
                mapToSchemaType = this.getSchemaTypeFromEntity(userId, mapToSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "SchemaTypeChoice") && (schemaTypeOptionsEntities = this.getAttachedEntities(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "SchemaType", null, null, 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) != null && !schemaTypeOptionsEntities.isEmpty()) {
            schemaTypeOptionGUIDs = new ArrayList<String>();
            schemaTypeOptions = new ArrayList<B>();
            for (EntityDetail schemaTypeOptionEntity : schemaTypeOptionsEntities) {
                if (schemaTypeOptionEntity == null) continue;
                schemaTypeOptionGUIDs.add(schemaTypeOptionEntity.getGUID());
                schemaTypeOptions.add(this.getSchemaTypeFromEntity(userId, schemaTypeOptionEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
        List<Relationship> queryTargets = this.getAttachmentLinks(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaElement", "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", null, "SchemaElement", 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        return this.schemaTypeConverter.getNewSchemaTypeBean(this.beanClass, schemaRootHeader, schemaRootTypeName, instanceProperties, entityClassifications, attributeCount, validValuesSetGUID, externalSchemaTypeGUID, externalSchemaType, mapFromSchemaTypeGUID, mapFromSchemaType, mapToSchemaTypeGUID, mapToSchemaType, schemaTypeOptionGUIDs, schemaTypeOptions, queryTargets, methodName);
    }
}

