/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APIOperationHandler<B>
extends ReferenceableHandler<B> {
    public APIOperationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiGUID, apiGUIDParameterName, methodName);
        String typeName = "APIOperation";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "APIOperation", this.serviceName, methodName, this.repositoryHelper);
        String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
        String apiSchemaTypeGUID = this.getAPISchemaTypeGUID(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, apiGUID, apiGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String apiOperationGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (apiOperationGUID != null) {
            String apiOperationGUIDParameterName = "apiOperationGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiSchemaTypeGUID, "apiSchemaTypeGUID", "APISchemaType", apiOperationGUID, "apiOperationGUID", "APIOperation", forLineage, forDuplicateProcessing, this.supportedZones, "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", null, effectiveTime, methodName);
        }
        return apiOperationGUID;
    }

    public String createAPIOperationFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
        String apiSchemaTypeGUID = this.getAPISchemaTypeGUID(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String apiOperationGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "f1c0af19-2729-4fac-996e-a7badff3c21c", "APIOperation", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        String apiOperationGUIDParameterName = "apiOperationGUID";
        this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiSchemaTypeGUID, "apiSchemaTypeGUID", "APISchemaType", apiOperationGUID, "apiOperationGUID", "APIOperation", forLineage, forDuplicateProcessing, this.supportedZones, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", null, effectiveTime, methodName);
        return apiOperationGUID;
    }

    public void updateAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiOperationGUID, apiOperationGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "APIOperation";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "APIOperation", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, "f1c0af19-2729-4fac-996e-a7badff3c21c", "APIOperation", OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findAPIOperations(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "f1c0af19-2729-4fac-996e-a7badff3c21c", "APIOperation", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "f1c0af19-2729-4fac-996e-a7badff3c21c", "APIOperation", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsForAPI(String userId, String apiGUID, String apiGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAPIOperationsForAPI(userId, apiGUID, apiGUIDParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsForAPI(String userId, String apiGUID, String apiGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail apiSchemaTypeEntity = this.getAttachedEntity(userId, apiGUID, apiGUIDParameterName, "DeployedAPI", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "APISchemaType", 2, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity != null) {
            String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
            return this.getAttachedElements(userId, null, null, apiSchemaTypeEntity.getGUID(), "apiSchemaTypeGUID", "APISchemaType", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "APIOperation", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    public List<B> getAPIOperationsForAPISchemaType(String userId, String apiSchemaTypeGUID, String apiSchemaTypeGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail apiSchemaTypeEntity = this.getEntityFromRepository(userId, apiSchemaTypeGUID, apiSchemaTypeGUIDParameterName, "APISchemaType", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity != null) {
            return this.getAttachedElements(userId, null, null, apiSchemaTypeEntity.getGUID(), apiSchemaTypeGUIDParameterName, "APISchemaType", "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", "APIOperation", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    private String getAPISchemaTypeGUID(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String topicQualifiedName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiSchemaTypeGUID;
        EntityDetail apiSchemaTypeEntity = this.getAttachedEntity(userId, apiGUID, apiGUIDParameterName, "DeployedAPI", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "APISchemaType", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity == null) {
            SchemaTypeBuilder builder = new SchemaTypeBuilder(topicQualifiedName + "_EventList", "b46cddb3-9864-4c5d-8a49-266b3fc95cb8", "APISchemaType", this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, apiGUID, apiGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
            apiSchemaTypeGUID = this.repositoryHandler.createEntity(userId, "b46cddb3-9864-4c5d-8a49-266b3fc95cb8", "APISchemaType", externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), builder.getEntityClassifications(), builder.getInstanceStatus(), methodName);
            if (apiSchemaTypeGUID != null) {
                String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, "DeployedAPI", apiSchemaTypeGUID, "apiSchemaTypeGUID", "APISchemaType", forLineage, forDuplicateProcessing, this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            } else {
                this.errorHandler.logNullInstance("APISchemaType", methodName);
            }
        } else {
            apiSchemaTypeGUID = apiSchemaTypeEntity.getGUID();
        }
        return apiSchemaTypeGUID;
    }

    public B getAPIOperationByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "APIOperation", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

