/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationReviewBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ClassificationAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataClassAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RelationshipAdviceAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SemanticAnnotation;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationHandler<B>
extends ReferenceableHandler<B> {
    public AnnotationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTypesOfAnnotation() {
        return this.repositoryHelper.getSubTypesOf(this.serviceName, OpenMetadataType.ANNOTATION.typeName);
    }

    public Map<String, String> getTypesOfAnnotationDescriptions() {
        List annotationTypeList = this.repositoryHelper.getSubTypesOf(this.serviceName, OpenMetadataType.ANNOTATION.typeName);
        HashMap<String, String> annotationDescriptions = new HashMap<String, String>();
        if (annotationTypeList != null) {
            for (String annotationTypeName : annotationTypeList) {
                TypeDef annotationTypeDef;
                if (annotationTypeName == null || (annotationTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, annotationTypeName)) == null) continue;
                annotationDescriptions.put(annotationTypeName, annotationTypeDef.getDescription());
            }
        }
        if (annotationDescriptions.isEmpty()) {
            return null;
        }
        return annotationDescriptions;
    }

    private AnnotationBuilder getAnnotationBuilder(String typeGUID, String typeName, Annotation annotation, String methodName) throws InvalidParameterException {
        String parameterName = "annotation";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        AnnotationBuilder builder = new AnnotationBuilder(annotation.getAnnotationType(), annotation.getSummary(), annotation.getConfidenceLevel(), annotation.getExpression(), annotation.getExplanation(), annotation.getAnalysisStep(), annotation.getJsonProperties(), annotation.getAdditionalProperties(), typeGUID, typeName, annotation.getExtendedProperties(), null, this.repositoryHelper, this.serviceName, this.serverName);
        if (annotation instanceof ClassificationAnnotation) {
            ClassificationAnnotation classificationAnnotation = (ClassificationAnnotation)annotation;
            builder.setClassificationSubtypeProperties(classificationAnnotation.getCandidateClassifications());
        } else if (annotation instanceof DataClassAnnotation) {
            DataClassAnnotation dataClassAnnotation = (DataClassAnnotation)annotation;
            builder.setDataClassSubtypeProperties(dataClassAnnotation.getCandidateDataClassGUIDs(), dataClassAnnotation.getMatchingValues(), dataClassAnnotation.getNonMatchingValues());
        } else if (annotation instanceof ResourceProfileAnnotation) {
            ResourceProfileAnnotation resourceProfileAnnotation = (ResourceProfileAnnotation)annotation;
            builder.setResourceProfileSubtypeProperties(resourceProfileAnnotation.getProfilePropertyNames(), resourceProfileAnnotation.getLength(), resourceProfileAnnotation.getInferredDataType(), resourceProfileAnnotation.getInferredFormat(), resourceProfileAnnotation.getInferredLength(), resourceProfileAnnotation.getInferredPrecision(), resourceProfileAnnotation.getInferredScale(), resourceProfileAnnotation.getProfileStartDate(), resourceProfileAnnotation.getProfileEndDate(), resourceProfileAnnotation.getProfileProperties(), resourceProfileAnnotation.getProfileFlags(), resourceProfileAnnotation.getProfileDates(), resourceProfileAnnotation.getProfileCounts(), resourceProfileAnnotation.getProfileDoubles(), resourceProfileAnnotation.getValueList(), resourceProfileAnnotation.getValueCount(), resourceProfileAnnotation.getValueRangeFrom(), resourceProfileAnnotation.getValueRangeTo(), resourceProfileAnnotation.getAverageValue());
        } else if (annotation instanceof ResourcePhysicalStatusAnnotation) {
            ResourcePhysicalStatusAnnotation resourcePhysicalStatusAnnotation = (ResourcePhysicalStatusAnnotation)annotation;
            builder.setResourcePhysicalStatusSubtypeProperties(resourcePhysicalStatusAnnotation.getResourceProperties(), resourcePhysicalStatusAnnotation.getCreateTime(), resourcePhysicalStatusAnnotation.getModifiedTime(), resourcePhysicalStatusAnnotation.getSize(), resourcePhysicalStatusAnnotation.getEncoding());
        } else if (annotation instanceof ResourceMeasureAnnotation) {
            ResourceMeasureAnnotation resourceMeasureAnnotation = (ResourceMeasureAnnotation)annotation;
            builder.setResourceMeasurementSubtypeProperties(resourceMeasureAnnotation.getResourceProperties());
        } else if (annotation instanceof QualityAnnotation) {
            QualityAnnotation qualityAnnotation = (QualityAnnotation)annotation;
            builder.setQualitySubtypeProperties(qualityAnnotation.getQualityDimension(), qualityAnnotation.getQualityScore());
        } else if (annotation instanceof RelationshipAdviceAnnotation) {
            RelationshipAdviceAnnotation relationshipAdviceAnnotation = (RelationshipAdviceAnnotation)annotation;
            builder.setRelationshipAdviceSubtypeProperties(relationshipAdviceAnnotation.getRelatedEntityGUID(), relationshipAdviceAnnotation.getRelationshipTypeName(), relationshipAdviceAnnotation.getRelationshipProperties());
        } else if (annotation instanceof RequestForActionAnnotation) {
            RequestForActionAnnotation requestForActionAnnotation = (RequestForActionAnnotation)annotation;
            builder.setRequestForActionSubtypeProperties(requestForActionAnnotation.getSurveyActivity(), requestForActionAnnotation.getActionRequested(), requestForActionAnnotation.getActionProperties());
        } else if (annotation instanceof SchemaAnalysisAnnotation) {
            SchemaAnalysisAnnotation schemaAnalysisAnnotation = (SchemaAnalysisAnnotation)annotation;
            builder.setSchemaAnalysisSubTypeProperties(schemaAnalysisAnnotation.getSchemaName(), schemaAnalysisAnnotation.getSchemaName());
        } else if (annotation instanceof SemanticAnnotation) {
            SemanticAnnotation semanticAnnotation = (SemanticAnnotation)annotation;
            builder.setSemanticSubTypeProperties(semanticAnnotation.getInformalTerm(), semanticAnnotation.getInformalTopic(), semanticAnnotation.getCandidateGlossaryTermGUIDs(), semanticAnnotation.getCandidateGlossaryCategoryGUIDs());
        }
        return builder;
    }

    private String getAnnotationTypeGUID(String typeName, String methodName) throws InvalidParameterException {
        return this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ANNOTATION.typeName, this.serviceName, methodName, this.repositoryHelper);
    }

    private String getAnnotationTypeName(Annotation annotation) {
        if (annotation != null && annotation.getOpenMetadataTypeName() != null) {
            return annotation.getOpenMetadataTypeName();
        }
        return OpenMetadataType.ANNOTATION.typeName;
    }

    private String addNewAnnotation(String userId, String assetGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String typeName = this.getAnnotationTypeName(annotation);
        String typeGUID = this.getAnnotationTypeGUID(typeName, methodName);
        AnnotationBuilder builder = this.getAnnotationBuilder(typeGUID, typeName, annotation, methodName);
        this.addAnchorGUIDToBuilder(userId, assetGUID, "assetGUID", false, false, new Date(), this.supportedZones, builder, methodName);
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, builder, new Date(), methodName);
    }

    public String addAnnotationToSurveyReport(String userId, String surveyReportGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID;
        String annotationParameterName = "annotation";
        String discoveryReportGUIDParameterName = "surveyReportGUID";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        Date effectiveTime = new Date();
        String assetGUID = null;
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, surveyReportGUID, "surveyReportGUID", OpenMetadataType.SURVEY_REPORT.typeName, true, false, false, false, this.supportedZones, effectiveTime, methodName);
        if (anchorEntity != null) {
            assetGUID = anchorEntity.getGUID();
        }
        if ((annotationGUID = this.addNewAnnotation(userId, assetGUID, annotation, methodName)) != null) {
            this.linkElementToElement(userId, null, null, annotationGUID, "annotation", OpenMetadataType.ANNOTATION.typeName, surveyReportGUID, "surveyReportGUID", OpenMetadataType.SURVEY_REPORT.typeName, false, false, this.supportedZones, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, effectiveTime, methodName);
        }
        return annotationGUID;
    }

    public String addAnnotationToAnnotation(String userId, String parentAnnotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID;
        String parentAnnotationGUIDParameterName = "parentAnnotationGUID";
        String annotationParameterName = "annotation";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        Date effectiveTime = new Date();
        String assetGUID = null;
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, parentAnnotationGUID, "parentAnnotationGUID", OpenMetadataType.ANNOTATION.typeName, true, false, false, false, this.supportedZones, effectiveTime, methodName);
        if (anchorEntity != null) {
            assetGUID = anchorEntity.getGUID();
        }
        if ((annotationGUID = this.addNewAnnotation(userId, assetGUID, annotation, methodName)) != null) {
            this.linkElementToElement(userId, null, null, parentAnnotationGUID, "parentAnnotationGUID", OpenMetadataType.ANNOTATION.typeName, annotationGUID, "annotation", OpenMetadataType.ANNOTATION.typeName, false, false, this.supportedZones, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName, null, null, null, effectiveTime, methodName);
        }
        return annotationGUID;
    }

    public void updateAnnotation(String userId, String annotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String typeName = this.getAnnotationTypeName(annotation);
        String typeGUID = this.getAnnotationTypeGUID(typeName, methodName);
        AnnotationBuilder builder = this.getAnnotationBuilder(typeGUID, typeName, annotation, methodName);
        this.updateBeanInRepository(userId, null, null, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeGUID, OpenMetadataType.ANNOTATION.typeName, false, false, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), false, new Date(), methodName);
    }

    public void addAnnotationReview(String userId, String annotationGUID, String annotationGUIDParameterName, int annotationStatus, Date reviewDate, String steward, String comment, String annotationReviewTypeGUID, String annotationReviewTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationReviewGUID;
        String annotationReviewGUIDParameterName = "annotationReviewGUID";
        String typeGUID = OpenMetadataType.ANNOTATION_REVIEW.typeGUID;
        String typeName = OpenMetadataType.ANNOTATION_REVIEW.typeName;
        if (annotationReviewTypeGUID != null) {
            typeGUID = annotationReviewTypeGUID;
        }
        if (annotationReviewTypeName != null) {
            typeName = annotationReviewTypeName;
        }
        Date effectiveTime = new Date();
        AnnotationReviewBuilder builder = new AnnotationReviewBuilder(annotationStatus, reviewDate, steward, comment, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, annotationGUID, annotationGUIDParameterName, OpenMetadataType.ANNOTATION.typeName, true, false, false, false, this.supportedZones, effectiveTime, methodName);
        if (anchorEntity != null && anchorEntity.getGUID() != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
        }
        if ((annotationReviewGUID = this.createBeanInRepository(userId, null, null, typeGUID, typeName, builder, effectiveTime, methodName)) != null) {
            this.linkElementToElement(userId, null, null, annotationGUID, annotationGUIDParameterName, OpenMetadataType.ANNOTATION.typeName, annotationReviewGUID, "annotationReviewGUID", OpenMetadataType.ANNOTATION_REVIEW.typeName, false, false, this.supportedZones, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName, builder.getReviewLinkInstanceProperties(methodName), null, null, effectiveTime, methodName);
        }
    }

    public void deleteAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.deleteBeanInRepository(userId, null, null, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeGUID, OpenMetadataType.ANNOTATION.typeName, null, null, false, false, new Date(), methodName);
    }

    public B getAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeName, false, false, new Date(), methodName);
        return this.converter.getNewBean(this.beanClass, entity, methodName);
    }

    private B getAnnotationBean(String userId, EntityDetail annotationEntity, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotation.getGUID";
        if (annotationEntity != null) {
            ArrayList<EntityDetail> supplementaryEntities = null;
            Date effectiveTime = new Date();
            EntityDetail annotationReviewEntity = this.getAttachedEntity(userId, annotationEntity.getGUID(), "annotation.getGUID", OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName, OpenMetadataType.ANNOTATION_REVIEW.typeName, 2, false, false, this.supportedZones, effectiveTime, methodName);
            if (annotationReviewEntity != null) {
                supplementaryEntities = new ArrayList<EntityDetail>();
                supplementaryEntities.add(annotationReviewEntity);
            }
            List<Relationship> annotationRelationships = this.getAllAttachmentLinks(userId, annotationEntity.getGUID(), null, OpenMetadataType.ANNOTATION.typeName, false, false, effectiveTime, methodName);
            return this.converter.getNewComplexBean(this.beanClass, annotationEntity, supplementaryEntities, annotationRelationships, methodName);
        }
        return null;
    }

    private List<B> getLinkedAnnotations(String userId, String rootGUID, String rootGUIDParameterName, String rootGUIDTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> annotationEntities = this.getAttachedEntities(userId, rootGUID, rootGUIDParameterName, rootGUIDTypeName, relationshipTypeGUID, relationshipTypeName, OpenMetadataType.ANNOTATION.typeName, null, null, 0, false, false, (List<String>)this.supportedZones, startingFrom, pageSize, new Date(), methodName);
        if (annotationEntities != null && !annotationEntities.isEmpty()) {
            ArrayList<B> returnBeans = new ArrayList<B>();
            for (EntityDetail annotationEntity : annotationEntities) {
                B annotationBean;
                if (annotationEntity == null || (annotationBean = this.getAnnotationBean(userId, annotationEntity, methodName)) == null) continue;
                returnBeans.add(annotationBean);
            }
            return returnBeans;
        }
        return null;
    }

    private List<B> getLinkedAnnotations(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, int requestedAnnotationStatus, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        Date effectiveTime = new Date();
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingElementGUID, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, 2, false, false, startingFrom, queryPageSize, effectiveTime, methodName);
        ArrayList<B> results = new ArrayList<B>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            B annotationBean;
            EntityProxy entityProxy;
            int annotationStatusOrdinal;
            Relationship relationship = iterator.getNext();
            if (relationship == null || relationship.getProperties() == null || requestedAnnotationStatus != (annotationStatusOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ANNOTATION_STATUS.name, relationship.getProperties(), methodName)) || (entityProxy = this.repositoryHandler.getOtherEnd(startingElementGUID, startingElementTypeName, relationship, 2, methodName)) == null) continue;
            String entityProxyGUIDParameterName = "entityProxy.getGUID";
            EntityDetail annotationEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "entityProxy.getGUID", OpenMetadataType.ANNOTATION.typeName, false, false, effectiveTime, methodName);
            if (annotationEntity == null || annotationEntity.getGUID() == null || (annotationBean = this.getAnnotation(userId, entityProxy.getGUID(), methodName)) == null) continue;
            results.add(annotationBean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getSurveyReportAnnotations(String userId, String surveyReportGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "surveyReportGUID";
        return this.getLinkedAnnotations(userId, surveyReportGUID, "surveyReportGUID", OpenMetadataType.SURVEY_REPORT.typeName, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startingFrom, pageSize, methodName);
    }

    public List<B> getSurveyReportAnnotations(String userId, String surveyReportGUID, int annotationStatus, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "surveyReportGUID";
        return this.getLinkedAnnotations(userId, surveyReportGUID, "surveyReportGUID", OpenMetadataType.SURVEY_REPORT.typeName, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, annotationStatus, startingFrom, pageSize, methodName);
    }

    public List<B> getExtendedAnnotations(String userId, String annotationGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        return this.getLinkedAnnotations(userId, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName, startingFrom, pageSize, methodName);
    }

    public List<B> getExtendedAnnotations(String userId, String annotationGUID, int annotationStatus, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        return this.getLinkedAnnotations(userId, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName, annotationStatus, startingFrom, pageSize, methodName);
    }
}

