/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ContactDetailsBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String name;
    private final String contactType;
    private final int contactMethodType;
    private final String contactMethodService;
    private final String contactMethodValue;

    public ContactDetailsBuilder(String name, String contactType, int contactMethodType, String contactMethodService, String contactMethodValue, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.CONTACT_DETAILS.typeGUID, OpenMetadataType.CONTACT_DETAILS.typeName, repositoryHelper, serviceName, serverName);
        this.name = name;
        this.contactType = contactType;
        this.contactMethodType = contactMethodType;
        this.contactMethodService = contactMethodService;
        this.contactMethodValue = contactMethodValue;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, ContactMethodType.getOpenTypeGUID(), ContactMethodType.getOpenTypeName(), this.contactMethodType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), OpenMetadataProperty.CONTACT_METHOD_TYPE.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONTACT_TYPE.name, this.contactType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONTACT_METHOD_SERVICE.name, this.contactMethodService, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONTACT_METHOD_VALUE.name, this.contactMethodValue, methodName);
        return properties;
    }
}

