/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContributionRecordBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContributionRecordHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    private static final String contributionRecordGUIDParameterName = "contributionRecordGUID";
    private final int karmaPointPlateau;

    public ContributionRecordHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, int karmaPointPlateau, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.karmaPointPlateau = karmaPointPlateau;
    }

    public B getContributionRecord(String userId, String profileGUID, String profileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElement(userId, profileGUID, profileGUIDParameterName, "Person", "4a316abe-eeee-4d11-ad5a-4bfb4079b80b", "PersonalContribution", "ContributionRecord", 0, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    EntityDetail getContributionRecordEntity(String userId, String profileGUID, String profileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntity(userId, profileGUID, profileGUIDParameterName, "Person", "4a316abe-eeee-4d11-ad5a-4bfb4079b80b", "PersonalContribution", "ContributionRecord", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void saveContributionRecord(String userId, String profileGUID, String profileGUIDParameterName, String qualifiedName, long karmaPoints, boolean isPublic, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail contributionRecordEntity = this.getContributionRecordEntity(userId, profileGUID, profileGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String typeName = "ContributionRecord";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ContributionRecord", this.serviceName, methodName, this.repositoryHelper);
        if (contributionRecordEntity == null) {
            ContributionRecordBuilder builder = new ContributionRecordBuilder(qualifiedName + "_ContributionRecord", karmaPoints, isPublic, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, profileGUID, profileGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
            String contributionRecordGUID = this.createBeanInRepository(userId, null, null, "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", builder, effectiveTime, methodName);
            if (contributionRecordGUID != null && profileGUID != null) {
                this.uncheckedLinkElementToElement(userId, null, null, profileGUID, profileGUIDParameterName, "Person", contributionRecordGUID, contributionRecordGUIDParameterName, "ContributionRecord", forLineage, forDuplicateProcessing, this.supportedZones, "4a316abe-eeee-4d11-ad5a-4bfb4079b80b", "PersonalContribution", null, effectiveTime, methodName);
            }
        } else {
            ContributionRecordBuilder builder = new ContributionRecordBuilder(null, karmaPoints, isPublic, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            this.updateBeanInRepository(userId, null, null, contributionRecordEntity.getGUID(), contributionRecordGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
        }
    }

    public void removeContributionRecord(String userId, String profileGUID, String profileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail contributionRecordEntity = this.getContributionRecordEntity(userId, profileGUID, profileGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (contributionRecordEntity != null) {
            this.deleteBeanInRepository(userId, null, null, contributionRecordEntity.getGUID(), contributionRecordGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public int getKarmaPointPlateau(int karmaPointTotal) {
        return karmaPointTotal / this.karmaPointPlateau;
    }
}

