/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

class DataFieldBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String dataFieldName;
    private final String dataFieldType;
    private final String dataFieldDescription;
    private final List<String> dataFieldAliases;
    private final int dataFieldSortOrder;
    private final String defaultValue;
    private final Map<String, String> additionalProperties;

    public DataFieldBuilder(String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, null, null, repositoryHelper, serviceName, serverName);
        this.dataFieldName = dataFieldName;
        this.dataFieldType = dataFieldType;
        this.dataFieldDescription = dataFieldDescription;
        this.dataFieldAliases = dataFieldAliases;
        this.dataFieldSortOrder = dataFieldSortOrder;
        this.defaultValue = defaultValue;
        this.additionalProperties = additionalProperties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldName", this.dataFieldName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldType", this.dataFieldType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldDescription", this.dataFieldDescription, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "dataFieldAliases", this.dataFieldAliases, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DATA_FIELD_SORT_ORDER.name, DataItemSortOrder.getOpenTypeGUID(), DataItemSortOrder.getOpenTypeName(), this.dataFieldSortOrder, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), OpenMetadataProperty.DATA_FIELD_SORT_ORDER.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValue", this.defaultValue, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, this.additionalProperties, methodName);
        return properties;
    }
}

