/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FilesAndFoldersHandler<FILESYSTEM, FOLDER, FILE> {
    private final String serviceName;
    private final String serverName;
    private final String localServerUserId;
    private final OMRSRepositoryHelper repositoryHelper;
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SoftwareCapabilityHandler<FILESYSTEM> fileSystemHandler;
    private final AssetHandler<FOLDER> folderHandler;
    private final AssetHandler<FILE> fileHandler;
    private final ConnectionHandler<OpenMetadataAPIDummyBean> connectionHandler;
    private final SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> schemaAttributeHandler;
    private static final String folderDivider = "/";
    private static final String fileSystemDivider = "://";
    private static final String fileExtensionDivider = "\\.";
    private static final String defaultAvroFileType = "avro";
    private static final String defaultCSVFileType = "csv";

    public FilesAndFoldersHandler(OpenMetadataAPIGenericConverter<FILESYSTEM> fileSystemConverter, Class<FILESYSTEM> fileSystemBeanClass, OpenMetadataAPIGenericConverter<FOLDER> folderConverter, Class<FOLDER> folderBeanClass, OpenMetadataAPIGenericConverter<FILE> fileConverter, Class<FILE> fileBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.localServerUserId = localServerUserId;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.fileSystemHandler = new SoftwareCapabilityHandler<FILESYSTEM>(fileSystemConverter, fileSystemBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.folderHandler = new AssetHandler<FOLDER>(folderConverter, folderBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.fileHandler = new AssetHandler<FILE>(fileConverter, fileBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummyConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(dummyConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummySchemaAttributeConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.schemaAttributeHandler = new SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean>(dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String getFileSystemName(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileSystemDivider)).length > 1) {
            result = tokens[0] + fileSystemDivider;
        }
        return result;
    }

    private List<String> getFolderNames(String pathName) {
        String[] tokens;
        ArrayList<String> result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(folderDivider)).length > 1) {
            int startingToken = 0;
            if (tokens[startingToken].isEmpty()) {
                startingToken = 1;
            } else if (this.getFileSystemName(pathName) != null) {
                startingToken = 2;
            }
            int endingToken = tokens.length;
            if (this.getFileName(pathName) != null) {
                --endingToken;
            }
            if (startingToken != endingToken) {
                result = new ArrayList<String>(Arrays.asList(tokens).subList(startingToken, endingToken));
            }
        }
        return result;
    }

    private String getFileName(String pathName) {
        String result = null;
        if (pathName != null && !pathName.isEmpty()) {
            String[] tokens = pathName.split(folderDivider);
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileExtension(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileExtensionDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileType(String pathName) {
        String[] tokens;
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileExtensionDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.createFileSystem(userId, externalSourceGUID, externalSourceName, uniqueName, displayName, description, type, version, patchLevel, source, format, encryption, additionalProperties, vendorProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private String createFolder(String userId, String externalSourceGUID, String externalSourceName, String pathName, String name, String versionIdentifier, String description, String typeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderAssetGUIDParameterName = "folderAssetGUID";
        String folderAssetTypeName = OpenMetadataType.FILE_FOLDER.typeName;
        if (typeName != null) {
            folderAssetTypeName = typeName;
        }
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        return this.folderHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "folderAssetGUID", this.createQualifiedName(folderAssetTypeName, null, pathName, versionIdentifier), name, versionIdentifier, description, null, folderAssetTypeName, extendedProperties, InstanceStatus.ACTIVE, true, null, null, pathName, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, this.folderHandler.getSupportedZones(), effectiveTime, methodName);
    }

    private String createFileAsset(String userId, String externalSourceGUID, String externalSourceName, String fileType, String fileName, String fileExtension, String pathName, String displayName, String versionIdentifier, String description, String typeName, Map<String, Object> initialExtendedProperties, Map<String, Object> configurationProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetGUIDParameterName = "fileAssetGUID";
        HashMap<Object, Object> extendedProperties = new HashMap<String, String>();
        if (initialExtendedProperties != null) {
            extendedProperties = new HashMap<String, Object>(initialExtendedProperties);
        }
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, fileExtension);
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, fileType);
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, fileName);
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        String fileAssetTypeName = OpenMetadataType.DATA_FILE.typeName;
        if (typeName != null) {
            fileAssetTypeName = typeName;
        }
        return this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "fileAssetGUID", this.createQualifiedName(fileAssetTypeName, null, pathName, versionIdentifier), displayName, versionIdentifier, description, null, fileAssetTypeName, extendedProperties, InstanceStatus.ACTIVE, true, configurationProperties, null, pathName, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, this.fileHandler.getSupportedZones(), effectiveTime, methodName);
    }

    private String createQualifiedName(String typeName, String qualifiedName, String pathName, String versionIdentifier) {
        if (qualifiedName != null) {
            return qualifiedName;
        }
        if (versionIdentifier == null) {
            return typeName + ":" + pathName;
        }
        return typeName + ":" + pathName + ":" + versionIdentifier;
    }

    private String createFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, String folderName, String versionIdentifier, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectToParameterName = "connectToGUID";
        String folderParameterName = "folderGUID";
        String folderGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, folderName, versionIdentifier, null, OpenMetadataType.FILE_FOLDER.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (connectToGUID != null) {
            if (this.repositoryHandler.isEntityATypeOf(userId, connectToGUID, "connectToGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, effectiveTime, methodName)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, folderGUID, "folderGUID", OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            } else {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", OpenMetadataType.FILE_FOLDER.typeName, folderGUID, "folderGUID", OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
        }
        return folderGUID;
    }

    private List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String fileSystemName, List<String> folderNames, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "->createFolderStructureInCatalog";
        ArrayList<String> folderGUIDs = new ArrayList<String>();
        if (folderNames != null && !folderNames.isEmpty()) {
            String pathName = null;
            Object folderName = null;
            String nextConnectToGUID = connectToGUID;
            for (String folderFragment : folderNames) {
                pathName = pathName == null ? (fileSystemName != null ? fileSystemName + folderFragment : folderDivider + folderFragment) : pathName + folderDivider + folderFragment;
                folderName = folderName != null ? (String)folderName + folderDivider + folderFragment : folderFragment;
                String currentFolderGUID = this.getFolderGUIDByPathName(userId, pathName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (currentFolderGUID == null) {
                    String folderGUID = this.createFolderInCatalog(userId, externalSourceGUID, externalSourceName, nextConnectToGUID, pathName, (String)folderName, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName + "->createFolderStructureInCatalog");
                    folderGUIDs.add(folderGUID);
                    nextConnectToGUID = folderGUID;
                    continue;
                }
                folderGUIDs.add(currentFolderGUID);
                nextConnectToGUID = currentFolderGUID;
            }
        }
        if (folderGUIDs.isEmpty()) {
            return null;
        }
        return folderGUIDs;
    }

    public List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, externalSourceGUID, externalSourceName, connectToGUID, this.getFileSystemName(pathName), this.getFolderNames(pathName + "/dummyFileName.ext"), effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void attachFolderToFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void detachFolderFromFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void attachDataFileAssetToFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.fileHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, fileGUID, fileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, forLineage, forDuplicateProcessing, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void detachDataFileAssetFromFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", effectiveTime, methodName);
    }

    public void moveDataFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolder, String newParentFolderGUIDParameterName, String fileGUID, String fileGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUIDParameterName = "endpointGUID";
        String newFolderPathName = this.folderHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, OpenMetadataProperty.QUALIFIED_NAME.name, effectiveTime, methodName);
        String existingFilePathName = this.fileHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.QUALIFIED_NAME.name, effectiveTime, methodName);
        String fileName = this.getFileName(existingFilePathName);
        String fullPathName = newFolderPathName + folderDivider + fileName;
        InstanceProperties properties = null;
        if (effectiveFrom != null || effectiveTo != null) {
            properties = new InstanceProperties();
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        this.fileHandler.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, false, newParentFolder, newParentFolderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", properties, effectiveTime, methodName);
        this.fileHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.QUALIFIED_NAME.name, fullPathName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        ArrayList<String> relationshipPath = new ArrayList<String>();
        relationshipPath.add("e777d660-8dbe-453e-8b83-903771f054c0");
        relationshipPath.add("887a7132-d6bc-4b92-a483-e80b60c86fb2");
        List<Object> endpointGUIDs = new ArrayList();
        while (endpointGUIDs != null) {
            endpointGUIDs = this.fileHandler.getRelatedEntityGUIDs(userId, fileGUID, fileGUIDParameterName, OpenMetadataType.DATA_FILE.typeGUID, relationshipPath, "Endpoint", 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            if (endpointGUIDs.isEmpty()) {
                endpointGUIDs = null;
                continue;
            }
            for (String string : endpointGUIDs) {
                if (string == null) continue;
                this.fileSystemHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, string, "endpointGUID", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", "networkAddress", fullPathName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void moveDataFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolderGUID, String newParentFolderGUIDParameterName, String movingFolderGUID, String movingFolderGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(newParentFolderGUID, newParentFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(movingFolderGUID, movingFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public List<String> addFileAssetPath(String userId, String externalSourceGUID, String externalSourceName, String fileAssetGUID, String fileAssetParameterName, String fileAssetTypeName, String pathName, String pathNameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> assetGUIDList = new ArrayList<String>();
        String fileSystemGUID = null;
        String fileSystemName = this.getFileSystemName(pathName);
        if (fileSystemName != null && (fileSystemGUID = this.fileSystemHandler.getBeanGUIDByQualifiedName(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, fileSystemName, pathNameParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) {
            fileSystemGUID = this.fileSystemHandler.createFileSystem(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemName, fileSystemName, null, null, null, null, null, null, null, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        List<String> folderNames = this.getFolderNames(pathName);
        List<String> folderGUIDs = null;
        String fileParentGUID = folderNames == null ? fileSystemGUID : ((folderGUIDs = this.createFolderStructureInCatalog(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, folderNames, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null && !folderGUIDs.isEmpty() ? folderGUIDs.get(folderGUIDs.size() - 1) : fileSystemGUID);
        if (fileAssetGUID != null && fileParentGUID != null) {
            if (fileParentGUID.equals(fileSystemGUID)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, fileAssetGUID, fileAssetParameterName, OpenMetadataType.DATA_FILE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, effectiveTime, methodName);
            } else {
                String relationshipTypeGUID = "4cb88900-1446-4eb6-acea-29cd9da45e63";
                String relationshipTypeName = "NestedFile";
                if (this.repositoryHelper.isTypeOf(this.serviceName, fileAssetTypeName, OpenMetadataType.FILE_FOLDER.typeName)) {
                    relationshipTypeGUID = "48ac9028-45dd-495d-b3e1-622685b54a01";
                    relationshipTypeName = "FolderHierarchy";
                }
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, OpenMetadataType.FILE_FOLDER.typeName, fileAssetGUID, fileAssetParameterName, fileAssetTypeName, forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, (InstanceProperties)null, null, null, effectiveTime, methodName);
            }
        }
        if (fileSystemGUID != null) {
            assetGUIDList.add(fileSystemGUID);
        }
        if (folderGUIDs != null) {
            assetGUIDList.addAll(folderGUIDs);
        }
        if (fileAssetGUID != null) {
            assetGUIDList.add(fileAssetGUID);
        }
        if (assetGUIDList.isEmpty()) {
            return null;
        }
        return assetGUIDList;
    }

    public List<String> addDataFileAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String name, String versionIdentifier, String description, String pathName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileType = this.getFileType(pathName);
        String fileName = this.getFileName(pathName);
        String fileExtension = this.getFileExtension(pathName);
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fileName, fileExtension, pathName, name, versionIdentifier, description, OpenMetadataType.DATA_FILE.typeName, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", OpenMetadataType.DATA_FILE.typeName, pathName, "pathName", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private Map<String, Object> getExtendedProperties(String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String fileType, String fileExtension, String deployedImplementationType, Map<String, Object> extendedProperties) {
        Map<String, Object> assetExtendedProperties = extendedProperties;
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (pathName != null) {
            assetExtendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        }
        if (createTime != null) {
            assetExtendedProperties.put(OpenMetadataProperty.STORE_CREATE_TIME.name, createTime);
        }
        if (modifiedTime != null) {
            assetExtendedProperties.put(OpenMetadataProperty.STORE_UPDATE_TIME.name, modifiedTime);
        }
        if (encodingType != null) {
            assetExtendedProperties.put(OpenMetadataProperty.ENCODING.name, encodingType);
        }
        if (encodingLanguage != null) {
            assetExtendedProperties.put(OpenMetadataProperty.ENCODING_LANGUAGE.name, encodingLanguage);
        }
        if (encodingDescription != null) {
            assetExtendedProperties.put(OpenMetadataProperty.ENCODING_DESCRIPTION.name, encodingDescription);
        }
        if (encodingProperties != null) {
            assetExtendedProperties.put(OpenMetadataProperty.ENCODING_PROPERTIES.name, encodingProperties);
        }
        if (fileType != null) {
            assetExtendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, fileType);
        }
        if (fileExtension != null) {
            assetExtendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, fileExtension);
        }
        if (deployedImplementationType != null) {
            assetExtendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType);
        }
        if (assetExtendedProperties.isEmpty()) {
            return null;
        }
        return assetExtendedProperties;
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String pathName, String name, String versionIdentifier, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, Map<String, String> additionalProperties, String connectorProviderClassName, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String folderAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(pathName, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, null, null, DeployedImplementationType.DATA_FOLDER.getDeployedImplementationType(), extendedProperties);
        String folderAssetTypeName = OpenMetadataType.DATA_FOLDER.typeName;
        if (typeName != null) {
            folderAssetTypeName = typeName;
        }
        String folderAssetGUID = this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "folderAssetGUID", this.createQualifiedName(folderAssetTypeName, qualifiedName, pathName, versionIdentifier), name, versionIdentifier, description, additionalProperties, folderAssetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, true, null, connectorProviderClassName, pathName, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, this.fileHandler.getSupportedZones(), effectiveTime, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", folderAssetTypeName, pathName, "pathName", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String pathName, String name, String versionIdentifier, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String folderAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String folderAssetGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, name, versionIdentifier, description, OpenMetadataType.DATA_FOLDER.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", OpenMetadataType.DATA_FOLDER.typeName, pathName, "pathName", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> addFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String versionIdentifier, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String suppliedFileType, String deployedImplementationType, Map<String, String> additionalProperties, String connectorProviderClassName, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetGUID;
        String pathParameterName = "pathName";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        String fullPath = pathName;
        if (fullPath == null) {
            fullPath = qualifiedName;
            pathParameterName = "qualifiedName";
        }
        this.invalidParameterHandler.validateName(fullPath, pathParameterName, methodName);
        String fileType = suppliedFileType;
        if (fileType == null) {
            fileType = this.getFileType(fullPath);
        }
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, fileType, this.getFileExtension(fullPath), deployedImplementationType, extendedProperties);
        String fileAssetTypeName = typeName;
        if (fileAssetTypeName == null) {
            fileAssetTypeName = defaultCSVFileType.equals(fileType) ? OpenMetadataType.CSV_FILE.typeName : (defaultAvroFileType.equals(fileType) ? OpenMetadataType.AVRO_FILE.typeName : OpenMetadataType.DATA_FILE.typeName);
        }
        if ((fileAssetGUID = this.fileHandler.createAssetWithConnection(userId, externalSourceGUID, externalSourceName, "fileAssetGUID", this.createQualifiedName(fileAssetTypeName, qualifiedName, pathName, versionIdentifier), name, versionIdentifier, description, additionalProperties, fileAssetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, true, null, connectorProviderClassName, fullPath, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, this.fileHandler.getSupportedZones(), effectiveTime, methodName)) != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fileAssetTypeName, fullPath, pathParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<String> addFileToCatalogFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String fullPath, String name, String versionIdentifier, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String pathNameParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileAssetGUID = this.fileHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, this.createQualifiedName(OpenMetadataType.DATA_FILE.typeName, qualifiedName, fullPath, versionIdentifier), "fullPath", name, versionIdentifier, description, fullPath, fullPath, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (fileAssetGUID != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", OpenMetadataType.DATA_FILE.typeName, fullPath, "fullPath", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<String> addFolderToCatalogFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String pathName, String name, String versionIdentifier, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String pathNameParameterName = "pathName";
        String fileAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String folderAssetGUID = this.fileHandler.addAssetFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, this.createQualifiedName(OpenMetadataType.FILE_FOLDER.typeName, qualifiedName, pathName, versionIdentifier), "pathName", name, versionIdentifier, description, pathName, pathName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (folderAssetGUID != null) {
            return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", OpenMetadataType.FILE_FOLDER.typeName, pathName, "pathName", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<String> addAvroFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String name, String versionIdentifier, String description, String fullPath, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        String fileName = this.getFileName(fullPath);
        String fileExtension = this.getFileExtension(fullPath);
        if (fileType == null) {
            fileType = defaultAvroFileType;
        }
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fileName, fileExtension, fullPath, name, versionIdentifier, description, OpenMetadataType.AVRO_FILE.typeName, null, null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", OpenMetadataType.AVRO_FILE.typeName, fullPath, "fullPath", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> addCSVFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String name, String versionIdentifier, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetGUIDParameterName = "fileAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        String fileName = this.getFileName(fullPath);
        String fileExtension = this.getFileExtension(fullPath);
        if (fileType == null) {
            fileType = defaultCSVFileType;
        }
        if (delimiterCharacter == null) {
            delimiterCharacter = Character.valueOf(',');
        }
        if (quoteCharacter == null) {
            quoteCharacter = Character.valueOf('\"');
        }
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put("delimiterCharacter", delimiterCharacter.toString());
        extendedProperties.put("quoteCharacter", quoteCharacter.toString());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, fileType);
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        configurationProperties.put("delimiterCharacter", delimiterCharacter);
        configurationProperties.put("quoteCharacter", quoteCharacter);
        if (columnHeaders != null) {
            configurationProperties.put("columnNames", columnHeaders);
        }
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fileName, fileExtension, fullPath, name, versionIdentifier, description, OpenMetadataType.CSV_FILE.typeName, extendedProperties, configurationProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (columnHeaders != null && !columnHeaders.isEmpty()) {
            String schemaTypeGUID = this.schemaAttributeHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", OpenMetadataType.CSV_FILE.typeName, "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            int columnCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                String columnQualifiedName = fullPath + "::" + columnName + "::" + columnCount;
                String columnDisplayName = columnName + "::" + columnCount;
                SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(columnQualifiedName, columnDisplayName, null, columnCount, 1, 1, false, null, true, false, 0, 0, 0, 0, false, null, null, null, "af6265e7-5f58-4a9c-9ae7-8d4284be62bd", "TabularFileColumn", null, this.repositoryHelper, this.serviceName, this.serverName);
                ++columnCount;
                this.schemaAttributeHandler.addAnchorGUIDToBuilder(userId, fileAssetGUID, "fileAssetGUID", false, false, effectiveTime, this.schemaAttributeHandler.getSupportedZones(), schemaAttributeBuilder, methodName);
                SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(columnQualifiedName + ":columnType", "f0f75fba-9136-4082-8352-0ad74f3c36ed", "PrimitiveSchemaType", this.repositoryHelper, this.serviceName, this.serverName);
                schemaTypeBuilder.setDataType("String");
                schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
                schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
                this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "TabularSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", columnQualifiedName, "qualifiedName", schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", OpenMetadataType.CSV_FILE.typeName, fullPath, "fullPath", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, boolean isMergeUpdate, String fullPath, String displayName, String versionIdentifier, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String suppliedFileType, String deployedImplementationType, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFileGUIDParameterName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        String qualifiedName = null;
        String fileType = suppliedFileType;
        String fileExtension = null;
        if (fullPath != null && fileType == null) {
            fileType = this.getFileType(fullPath);
            fileExtension = this.getFileExtension(fullPath);
        }
        if (!isMergeUpdate) {
            qualifiedName = this.createQualifiedName(OpenMetadataType.DATA_FILE.typeName, null, fullPath, versionIdentifier);
        }
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, fileType, fileExtension, deployedImplementationType, extendedProperties);
        if (fullPath != null) {
            if (assetExtendedProperties == null) {
                assetExtendedProperties = new HashMap<String, Object>();
            }
            assetExtendedProperties.put(OpenMetadataProperty.FILE_NAME.name, this.getFileName(fullPath));
        }
        this.fileHandler.updateAsset(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFileGUID", qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, assetExtendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, boolean isMergeUpdate, String fullPath, String displayName, String versionIdentifier, String description, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFileGUIDParameterName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        String qualifiedName = null;
        if (!isMergeUpdate) {
            qualifiedName = this.createQualifiedName(OpenMetadataType.DATA_FOLDER.typeName, null, fullPath, versionIdentifier);
        }
        Map<String, Object> assetExtendedProperties = this.getExtendedProperties(fullPath, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, encodingProperties, null, null, DeployedImplementationType.FILE_FOLDER.getDeployedImplementationType(), extendedProperties);
        this.fileHandler.updateAsset(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFileGUID", qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.DATA_FOLDER.typeGUID, OpenMetadataType.DATA_FOLDER.typeName, assetExtendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void archiveFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, String dataFileGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, dataFileGUIDParameterName, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.fileHandler.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFileGUID, dataFileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String connectionGUID = this.fileHandler.getAttachedElementGUID(userId, dataFileGUID, dataFileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", 0, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (connectionGUID != null) {
            String connectionGUIDParameterName = "connectionGUID";
            this.connectionHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void archiveFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFolderGUID, String dataFolderGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, dataFolderGUIDParameterName, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.fileHandler.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFolderGUID, dataFolderGUIDParameterName, OpenMetadataType.DATA_FOLDER.typeName, builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String connectionGUID = this.fileHandler.getAttachedElementGUID(userId, dataFolderGUID, dataFolderGUIDParameterName, OpenMetadataType.DATA_FOLDER.typeName, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", 0, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (connectionGUID != null) {
            String connectionGUIDParameterName = "connectionGUID";
            this.connectionHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void deleteFileFromCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFileGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFileGUIDParameterName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        this.fileHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFileGUID, "dataFileGUID", OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void deleteFolderFromCatalog(String userId, String externalSourceGUID, String externalSourceName, String dataFolderGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFolderGUIDParameterName = "dataFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", methodName);
        this.fileHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFolderGUID, "dataFolderGUID", OpenMetadataType.DATA_FOLDER.typeGUID, OpenMetadataType.DATA_FOLDER.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public FILESYSTEM getFileSystemByGUID(String userId, String softwareServerCapabilityGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanFromRepository(userId, softwareServerCapabilityGUID, guidParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public FILESYSTEM getFileSystemByUniqueName(String userId, String uniqueName, String parameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanByQualifiedName(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, uniqueName, parameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> getFileSystems(String userId, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.getSoftwareCapabilityGUIDsByClassification(userId, "FileSystem", startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public FOLDER getFolderByGUID(String userId, String folderGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "folderGUID";
        return (FOLDER)this.folderHandler.getBeanFromRepository(userId, folderGUID, "folderGUID", OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private String getFolderGUIDByPathName(String userId, String pathName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathNameParameterName = "pathName";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        List<EntityDetail> entities = this.fileHandler.getEntitiesByValue(userId, pathName, "pathName", OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, 0, 0, effectiveTime, methodName);
        if (entities != null) {
            for (EntityDetail entityDetail : entities) {
                if (entityDetail == null) continue;
                return entityDetail.getGUID();
            }
        }
        return null;
    }

    public FOLDER getFolderByPathName(String userId, String pathName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathNameParameterName = "pathName";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        List folders = this.folderHandler.getBeansByValue(userId, pathName, "pathName", OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, 0, 0, effectiveTime, methodName);
        if (folders != null) {
            for (Object folder : folders) {
                if (folder == null) continue;
                return (FOLDER)folder;
            }
        }
        return null;
    }

    public List<FOLDER> findFoldersByPathName(String userId, String pathName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathNameParameterName = "pathName";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        return this.folderHandler.getBeansByValue(userId, pathName, "pathName", OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<FOLDER> findFoldersByName(String userId, String name, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "name";
        return this.folderHandler.findAssetsByName(userId, OpenMetadataType.FILE_FOLDER.typeGUID, OpenMetadataType.FILE_FOLDER.typeName, name, "name", startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> getTopLevelFolders(String userId, String fileSystemGUID, String fileSystemParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.folderHandler.getAttachedElementGUIDs(userId, fileSystemGUID, fileSystemParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getNestedFolders(String userId, String parentFolderGUID, String parentFolderParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.folderHandler.getAttachedElementGUIDs(userId, parentFolderGUID, parentFolderParameterName, OpenMetadataType.FILE_FOLDER.typeName, "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", OpenMetadataType.FILE_FOLDER.typeName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getFolderFileGUIDs(String userId, String folderGUID, String folderGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.getAttachedElementGUIDs(userId, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", OpenMetadataType.DATA_FILE.typeName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<FILE> getFolderFiles(String userId, String folderGUID, String folderGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.getAttachedElements(userId, folderGUID, folderGUIDParameterName, OpenMetadataType.FILE_FOLDER.typeName, "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", OpenMetadataType.DATA_FILE.typeName, null, null, 2, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
    }

    public FILE getDataFileByGUID(String userId, String dataFileGUID, String dataFileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILE)this.fileHandler.getBeanFromRepository(userId, dataFileGUID, dataFileGUIDParameterName, OpenMetadataType.DATA_FILE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public FILE getDataFileByPathName(String userId, String pathName, String pathNameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        List files = this.fileHandler.getBeansByValue(userId, pathName, pathNameParameterName, OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, 0, 0, effectiveTime, methodName);
        if (files != null) {
            for (Object file : files) {
                if (file == null) continue;
                return (FILE)file;
            }
        }
        return null;
    }

    public List<FILE> findDataFilesByPathName(String userId, String pathName, String pathNameParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        return this.fileHandler.getBeansByValue(userId, pathName, pathNameParameterName, OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, specificMatchPropertyNames, false, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<FILE> findDataFilesByName(String userId, String name, String nameParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        return this.fileHandler.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.DATA_FILE.typeGUID, OpenMetadataType.DATA_FILE.typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, OpenMetadataProperty.QUALIFIED_NAME.name, startingFrom, pageSize, effectiveTime, methodName);
    }
}

