/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossary(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Glossary";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Glossary", this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, null, methodName);
    }

    public String createGlossaryFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, "Glossary", "Glossary", methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, deepCopy, false, null, methodName);
    }

    public void updateGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "Glossary";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Glossary", this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addEditingGlossaryClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "173614ba-c582-4ecc-8fcc-cde5fb664548", "EditingGlossary", builder.getEditingGlossaryProperties(description, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeEditingGlossaryClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "173614ba-c582-4ecc-8fcc-cde5fb664548", "EditingGlossary", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addStagingGlossaryClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "361fa044-e703-404c-bb83-9402f9221f54", "StagingGlossary", builder.getStagingGlossaryProperties(description, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeStagingGlossaryClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "361fa044-e703-404c-bb83-9402f9221f54", "StagingGlossary", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addTaxonomyClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String organizingPrinciple, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "37116c51-e6c9-4c37-942e-35d48c8c69a0", "Taxonomy", builder.getTaxonomyProperties(organizingPrinciple, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeTaxonomyClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "37116c51-e6c9-4c37-942e-35d48c8c69a0", "37116c51-e6c9-4c37-942e-35d48c8c69a0", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCanonicalVocabClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String scope, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", builder.getCanonicalVocabularyProperties(scope, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCanonicalVocabClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", "33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGlossaries(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGlossariesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGlossaryByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Glossary", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getGlossaryForCategory(String userId, String glossaryCategoryGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, glossaryCategoryGUID, guidParameterName, "GlossaryCategory", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", "Glossary", 1, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getGlossaryForTerm(String userId, String glossaryTermGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, glossaryTermGUID, guidParameterName, "GlossaryTerm", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", "Glossary", 1, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

