/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryTermHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTermRelationshipTypeNames() {
        List knownTypeDefs = this.repositoryHelper.getKnownTypeDefs();
        ArrayList<String> relationshipNames = new ArrayList<String>();
        if (knownTypeDefs != null) {
            for (TypeDef typeDef : knownTypeDefs) {
                RelationshipDef relationshipDef;
                if (typeDef == null || typeDef.getStatus() != TypeDefStatus.ACTIVE_TYPEDEF || !(typeDef instanceof RelationshipDef) || !(relationshipDef = (RelationshipDef)typeDef).getEndDef1().getEntityType().getName().equals("GlossaryTerm") || !relationshipDef.getEndDef2().getEntityType().getName().equals("GlossaryTerm")) continue;
                relationshipNames.add(relationshipDef.getName());
            }
        }
        return relationshipNames;
    }

    public String createGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, String publishVersionIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = suppliedTypeName != null ? suppliedTypeName : (initialStatus == null || initialStatus == InstanceStatus.ACTIVE ? "GlossaryTerm" : "ControlledGlossaryTerm");
        TypeDef glossaryTypeDef = this.invalidParameterHandler.validateTypeDefName(typeName, "GlossaryTerm", this.serviceName, methodName, this.repositoryHelper);
        InstanceStatus instanceStatus = initialStatus != null ? initialStatus : glossaryTypeDef.getInitialStatus();
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, summary, description, examples, abbreviation, usage, publishVersionIdentifier, additionalProperties, extendedProperties, instanceStatus, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, glossaryGUID, glossaryGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String glossaryTermGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTypeDef.getGUID(), glossaryTypeDef.getName(), builder, effectiveTime, methodName);
        if (glossaryTermGUID != null) {
            String glossaryTermGUIDParameterName = "glossaryTermGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryTermGUID, "glossaryTermGUID", "GlossaryTerm", false, false, this.supportedZones, "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", null, effectiveTime, methodName);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, String publishVersionIdentifier, InstanceStatus initialStatus, boolean deepCopy, boolean templateSubstitute, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, description, publishVersionIdentifier, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, glossaryGUID, glossaryGUIDParameterName, false, false, null, this.supportedZones, builder, methodName);
        String glossaryTermGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, deepCopy, templateSubstitute, null, methodName);
        if (glossaryTermGUID != null) {
            String glossaryTermGUIDParameterName = "glossaryTermGUID";
            if (initialStatus != null) {
                this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, "glossaryTermGUID", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", false, false, initialStatus, "initialStatus", null, methodName);
            }
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, "Glossary", glossaryTermGUID, "glossaryTermGUID", "GlossaryTerm", false, false, this.supportedZones, "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", null, null, methodName);
        }
        return glossaryTermGUID;
    }

    public void updateGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, String publishVersionIdentifier, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GlossaryTerm", this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, summary, description, examples, abbreviation, usage, publishVersionIdentifier, additionalProperties, extendedProperties, InstanceStatus.ACTIVE, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void updateGlossaryTermStatus(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, InstanceStatus glossaryTermStatus, String glossaryTermStatusParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, glossaryTermStatus, glossaryTermStatusParameterName, effectiveTime, methodName);
    }

    public void updateGlossaryTermFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String templateGUID, String templateGUIDParameterName, boolean isMergeClassifications, boolean isMergeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail templateEntity = this.repositoryHandler.getEntityByGUID(userId, templateGUID, templateGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail termEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (templateEntity != null) {
            InstanceProperties templateProperties = null;
            if (templateEntity.getProperties() != null) {
                templateProperties = new InstanceProperties();
                templateProperties.setEffectiveFromTime(templateEntity.getProperties().getEffectiveFromTime());
                templateProperties.setEffectiveToTime(templateEntity.getProperties().getEffectiveToTime());
                if (templateEntity.getProperties().getPropertyCount() > 0) {
                    Iterator propertyNames = templateEntity.getProperties().getPropertyNames();
                    while (propertyNames.hasNext()) {
                        String propertyName = (String)propertyNames.next();
                        if (OpenMetadataProperty.QUALIFIED_NAME.name.equals(propertyName)) continue;
                        templateProperties.setProperty(propertyName, templateEntity.getProperties().getPropertyValue(propertyName));
                    }
                }
            }
            this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, termEntity, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, templateProperties, isMergeProperties, effectiveTime, methodName);
            ArrayList<String> updatedClassifications = new ArrayList<String>();
            if (templateEntity.getClassifications() != null) {
                for (Classification classification : templateEntity.getClassifications()) {
                    if (OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getName())) continue;
                    this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, termEntity, glossaryTermGUIDParameterName, "GlossaryTerm", classification.getType().getTypeDefGUID(), classification.getType().getTypeDefName(), classification.getProperties(), isMergeProperties, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
                    updatedClassifications.add(classification.getName());
                }
            }
            if (!isMergeClassifications && termEntity.getClassifications() != null) {
                for (Classification classification : termEntity.getClassifications()) {
                    if (OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getName()) || updatedClassifications.contains(classification.getName())) continue;
                    this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, termEntity.getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", classification.getType().getTypeDefGUID(), classification.getType().getTypeDefName(), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                }
            }
        }
    }

    public void moveGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String newGlossaryGUID, String newGlossaryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail termEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> termAnchors = this.getAttachmentLinks(userId, termEntity.getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", null, "Glossary", 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (termAnchors != null) {
            for (Relationship termAnchor : termAnchors) {
                if (termAnchor == null) continue;
                this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, termAnchor, methodName);
            }
        }
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, termEntity.getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, newGlossaryGUID, newGlossaryGUIDParameterName, "Glossary", termEntity.getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", null, null, null, effectiveTime, methodName);
    }

    public void setupTermCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String description, int relationshipStatus, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", builder.getTermCategorizationProperties(description, relationshipStatus, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearTermCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", effectiveTime, methodName);
    }

    public void setupTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, String expression, String description, int relationshipStatus, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, builder.getTermRelationshipProperties(expression, description, relationshipStatus, steward, source, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, String expression, String description, int relationshipStatus, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "GlossaryTerm", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, isMergeUpdate, builder.getTermRelationshipProperties(expression, description, relationshipStatus, steward, source, methodName), effectiveTime, methodName);
    }

    public void clearTermRelationship(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermOneGUID, String glossaryTermOneGUIDParameterName, String relationshipTypeName, String relationshipTypeParameterName, String glossaryTermTwoGUID, String glossaryTermTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, glossaryTermOneGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeParameterName, methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, glossaryTermOneGUID, glossaryTermOneGUIDParameterName, "GlossaryTerm", glossaryTermTwoGUID, glossaryTermTwoGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, effectiveTime, methodName);
    }

    public void setTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "9d725a07-4abf-4939-a268-419d200b69c2", "AbstractConcept", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "9d725a07-4abf-4939-a268-419d200b69c2", "AbstractConcept", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ab253e31-3d8a-45a7-8592-24329a189b9e", "DataValue", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ab253e31-3d8a-45a7-8592-24329a189b9e", "DataValue", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, int activityType, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, builder.getActivityTypeProperties(activityType, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String description, String scope, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "54f9f41a-3871-4650-825d-59a41de01330e", "ContextDefinition", builder.getContextDescriptionProperties(description, scope, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "54f9f41a-3871-4650-825d-59a41de01330e", "ContextDefinition", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "a41ee152-de1e-4533-8535-2f8b37897cac", "SpineObject", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "a41ee152-de1e-4533-8535-2f8b37897cac", "SpineObject", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ccb749ba-34ec-4f71-8755-4d8b383c34c3", "SpineAttribute", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "ccb749ba-34ec-4f71-8755-4d8b383c34c3", "SpineAttribute", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "3d1e4389-27de-44fa-8df4-d57bfaf809ea", "ObjectIdentifier", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", "3d1e4389-27de-44fa-8df4-d57bfaf809ea", "ObjectIdentifier", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void archiveGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityFromRepository(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", null, null, true, forDuplicateProcessing, effectiveTime, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.classifyEntity(userId, assetManagerGUID, assetManagerName, entity.getGUID(), entity, glossaryTermGUIDParameterName, "GlossaryTerm", OpenMetadataType.MEMENTO_CLASSIFICATION.typeGUID, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, entity.getGUID(), builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), true, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getTermsByName(String userId, String glossaryGUID, String name, List<InstanceStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityGUIDParameterName = "termEntity.getGUID";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", specificMatchPropertyNames, true, false, null, limitResultsByStatus, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        ArrayList<String> validatedAnchors = new ArrayList<String>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            int matchCount = 0;
            if (entity == null) continue;
            try {
                OpenMetadataAPIGenericHandler.AnchorIdentifiers termAnchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entity, methodName);
                if (glossaryGUID != null && !glossaryGUID.equals(termAnchorIdentifiers.anchorGUID)) continue;
                if (termAnchorIdentifiers.anchorGUID == null || !validatedAnchors.contains(termAnchorIdentifiers.anchorGUID)) {
                    this.validateAnchorEntity(userId, entity.getGUID(), entity.getType().getTypeDefName(), entity, "termEntity.getGUID", false, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                    if (termAnchorIdentifiers.anchorGUID != null) {
                        validatedAnchors.add(termAnchorIdentifiers.anchorGUID);
                    }
                }
                if (++matchCount <= startFrom) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            catch (Exception exception) {}
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<B> findTerms(String userId, String glossaryGUID, String searchString, List<InstanceStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityGUIDParameterName = "termEntity.getGUID";
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, searchString, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", null, false, false, null, limitResultsByStatus, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        ArrayList<String> validatedAnchors = new ArrayList<String>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail termEntity = iterator.getNext();
            int matchCount = 0;
            if (termEntity == null) continue;
            try {
                List<EntityDetail> categoryEntities;
                OpenMetadataAPIGenericHandler.AnchorIdentifiers termAnchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)termEntity, methodName);
                if (glossaryGUID == null || glossaryGUID.equals(termAnchorIdentifiers.anchorGUID)) {
                    if (termAnchorIdentifiers.anchorGUID == null || !validatedAnchors.contains(termAnchorIdentifiers.anchorGUID)) {
                        this.validateAnchorEntity(userId, termEntity.getGUID(), "GlossaryTerm", termEntity, "termEntity.getGUID", false, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                        if (termAnchorIdentifiers.anchorGUID != null) {
                            validatedAnchors.add(termAnchorIdentifiers.anchorGUID);
                        }
                    }
                    if (++matchCount <= startFrom) continue;
                    results.add(this.converter.getNewBean(this.beanClass, termEntity, methodName));
                    continue;
                }
                if (glossaryGUID == null || (categoryEntities = this.getAttachedEntities(userId, termEntity.getGUID(), "termEntity.getGUID", "GlossaryTerm", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryCategory", null, null, 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName)) == null) continue;
                for (EntityDetail categoryEntity : categoryEntities) {
                    if (categoryEntity == null) continue;
                    OpenMetadataAPIGenericHandler.AnchorIdentifiers categoryAnchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)categoryEntity, methodName);
                    if (!glossaryGUID.equals(categoryAnchorIdentifiers.anchorGUID) || limitResultsByStatus != null && !limitResultsByStatus.contains(termEntity.getStatus()) || ++matchCount <= startFrom) continue;
                    results.add(this.converter.getNewBean(this.beanClass, termEntity, methodName));
                }
            }
            catch (Exception exception) {
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public B getTerm(String userId, String guid, String guidParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameter, "GlossaryTerm", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getTermsForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", "GlossaryTerm", null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTermsForGlossaryCategory(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, List<Integer> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (limitResultsByStatus == null || limitResultsByStatus.isEmpty()) {
            return this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryTerm", null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        }
        return this.getAttachedElements(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryTerm", null, null, limitResultsByStatus, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getRelatedTerms(String userId, String glossaryGUID, String glossaryGUIDParameterName, String relationshipTypeName, List<Integer> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        }
        if (limitResultsByStatus == null || limitResultsByStatus.isEmpty()) {
            return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "GlossaryTerm", relationshipTypeGUID, relationshipTypeName, "GlossaryTerm", null, null, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        }
        return this.getAttachedElements(userId, glossaryGUID, glossaryGUIDParameterName, "GlossaryTerm", relationshipTypeGUID, relationshipTypeName, "GlossaryTerm", null, null, limitResultsByStatus, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, 0, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAttachedMeanings(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.SEMANTIC_ASSIGNMENT.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, "GlossaryTerm", null, null, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }
}

