/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionProcessStepBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionProcessStepHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionProcessStepHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceActionProcessStep(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, boolean ignoreMultipleTriggers, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "processStepProperties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "processStepProperties.getQualifiedName", methodName);
        GovernanceActionProcessStepBuilder builder = new GovernanceActionProcessStepBuilder(qualifiedName, domainIdentifier, displayName, description, ignoreMultipleTriggers, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String governanceActionProcessStepGUID = this.createBeanInRepository(userId, null, null, "7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", builder, effectiveTime, methodName);
        if (governanceActionProcessStepGUID != null && governanceEngineGUID != null) {
            this.linkGovernanceActionExecutor(userId, governanceActionProcessStepGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return governanceActionProcessStepGUID;
    }

    private void linkGovernanceActionExecutor(String userId, String governanceActionProcessStepGUID, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionProcessStepGUIDParameterName = "governanceActionProcessStepGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.REQUEST_TYPE.name, requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, methodName);
        this.linkElementToElement(userId, null, null, governanceActionProcessStepGUID, "governanceActionProcessStepGUID", "GovernanceActionProcessStep", governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionExecutor", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateGovernanceActionProcessStep(String userId, String processStepGUID, boolean isMergeUpdate, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, boolean ignoreMultipleTriggers, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processStepGUIDParameterName = "processStepGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        String qualifiedNameParameterName = "processStepProperties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "processStepProperties.getQualifiedName", methodName);
        }
        if (!isMergeUpdate || governanceEngineGUID != null || requestType != null || requestParameters != null) {
            Relationship executorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, processStepGUID, "GovernanceActionProcessStep", "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionExecutor", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (executorRelationship == null) {
                this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
                this.linkGovernanceActionExecutor(userId, processStepGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            } else if (governanceEngineGUID == null) {
                if (!isMergeUpdate) {
                    this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                } else {
                    this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, true, methodName);
                }
            } else if (governanceEngineGUID.equals(executorRelationship.getEntityTwoProxy().getGUID())) {
                this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, isMergeUpdate, methodName);
            } else {
                this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                this.linkGovernanceActionExecutor(userId, processStepGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            }
        }
        GovernanceActionProcessStepBuilder builder = new GovernanceActionProcessStepBuilder(qualifiedName, domainIdentifier, displayName, description, ignoreMultipleTriggers, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, processStepGUID, "processStepGUID", "7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    private void updateExecutorRelationship(String userId, Relationship executorRelationship, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        InstanceProperties relationshipProperties = null;
        if (isMergeUpdate) {
            relationshipProperties = executorRelationship.getProperties();
        }
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_TYPE.name, requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, executorRelationship, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void removeGovernanceActionProcessStep(String userId, String processStepGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "processStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", methodName);
        this.deleteBeanInRepository(userId, null, null, processStepGUID, "processStepGUID", "7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> findGovernanceActionProcessSteps(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.getBeansByValue(userId, searchString, searchStringParameterName, "7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", null, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceActionProcessStepsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", specificMatchPropertyNames, true, null, null, false, false, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGovernanceActionProcessStepByGUID(String userId, String processStepGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "processStepGUID";
        return this.getBeanFromRepository(userId, processStepGUID, "processStepGUID", "GovernanceActionProcessStep", false, false, serviceSupportedZones, effectiveTime, methodName);
    }

    public void setupFirstProcessStep(String userId, String processGUID, String processStepGUID, String guard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        String processStepGUIDParameterName = "processStepGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        this.linkElementToElement(userId, null, null, processGUID, "processGUID", "GovernanceActionProcess", processStepGUID, "processStepGUID", "GovernanceActionProcessStep", forLineage, forDuplicateProcessing, serviceSupportedZones, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public B getFirstProcessStep(String userId, String processGUID, Relationship firstActionProcessStepLink, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        if (firstActionProcessStepLink != null && firstActionProcessStepLink.getEntityTwoProxy() != null) {
            return this.getGovernanceActionProcessStepByGUID(userId, firstActionProcessStepLink.getEntityTwoProxy().getGUID(), serviceSupportedZones, effectiveTime, methodName);
        }
        return this.getAttachedElement(userId, processGUID, "processGUID", "GovernanceActionProcess", "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", "GovernanceActionProcessStep", 0, false, false, serviceSupportedZones, effectiveTime, methodName);
    }

    public Relationship getFirstActionProcessStepLink(String userId, String processGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        return this.getUniqueAttachmentLink(userId, processGUID, "processGUID", "GovernanceActionProcess", "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", null, "GovernanceActionProcessStep", 2, false, false, serviceSupportedZones, effectiveTime, methodName);
    }

    public void removeFirstProcessStep(String userId, String processGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = "processGUID";
        this.unlinkConnectedElement(userId, false, null, null, processGUID, "processGUID", "GovernanceActionProcess", false, false, serviceSupportedZones, "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", "GovernanceActionProcessStep", effectiveTime, methodName);
    }

    public String setupNextProcessStep(String userId, String currentActionProcessStepGUID, String nextActionProcessStepGUID, String guard, boolean mandatoryGuard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentGUIDParameterName = "currentActionProcessStepGUID";
        String nextGUIDParameterName = "nextActionProcessStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentActionProcessStepGUID, "currentActionProcessStepGUID", methodName);
        this.invalidParameterHandler.validateGUID(nextActionProcessStepGUID, "nextActionProcessStepGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, relationshipProperties, "mandatoryGuard", mandatoryGuard, methodName);
        return this.linkElementToElement(userId, null, null, currentActionProcessStepGUID, "currentActionProcessStepGUID", "GovernanceActionProcessStep", nextActionProcessStepGUID, "nextActionProcessStepGUID", "GovernanceActionProcessStep", forLineage, forDuplicateProcessing, serviceSupportedZones, "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionProcessStep", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateNextProcessStep(String userId, String nextProcessStepLinkGUID, String guard, boolean mandatoryGuard, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "nextProcessStepLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(nextProcessStepLinkGUID, "nextProcessStepLinkGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "guard", guard, methodName);
        relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, relationshipProperties, "mandatoryGuard", mandatoryGuard, methodName);
        this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, nextProcessStepLinkGUID, relationshipProperties, methodName);
    }

    public List<Relationship> getNextGovernanceActionProcessSteps(String userId, String processStepGUID, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "processStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", methodName);
        this.validateAnchorEntity(userId, processStepGUID, "processStepGUID", "GovernanceActionProcessStep", true, false, true, false, serviceSupportedZones, effectiveTime, methodName);
        return this.repositoryHandler.getRelationshipsByType(userId, processStepGUID, "GovernanceActionProcessStep", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionProcessStep", 2, false, false, startFrom, pageSize, effectiveTime, methodName);
    }

    public void removeNextProcessStep(String userId, String actionLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionLinkGUID, "processGUID", methodName);
        this.repositoryHandler.removeRelationship(userId, null, null, "NextGovernanceActionProcessStep", actionLinkGUID, methodName);
    }
}

