/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDefinitionHandler<B>
extends ReferenceableHandler<B> {
    public GovernanceDefinitionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceDefinition(String userId, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, List<String> businessImperatives, String jurisdiction, String implementationDescription, String namePattern, String details, String distinguishedName, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        GovernanceDefinitionBuilder builder = new GovernanceDefinitionBuilder(qualifiedName, title, summary, description, scope, domainIdentifier, priority, implications, outcomes, results, businessImperatives, jurisdiction, implementationDescription, namePattern, details, distinguishedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateGovernanceDefinition(String userId, String definitionGUID, String definitionGUIDParameterName, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, List<String> businessImperatives, String jurisdiction, String implementationDescription, String namePattern, String details, String distinguishedName, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(definitionGUID, definitionGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        GovernanceDefinitionBuilder builder = new GovernanceDefinitionBuilder(qualifiedName, title, summary, description, scope, domainIdentifier, priority, implications, outcomes, results, businessImperatives, jurisdiction, implementationDescription, namePattern, details, distinguishedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, definitionGUID, definitionGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void setupDelegationRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeName, String relationshipTypeName, String rationale, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeNameParameter = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "rationale", rationale, methodName);
        this.linkElementToElement(userId, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void setupPeerRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeName, String relationshipTypeName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeNameParameter = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.linkElementToElement(userId, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearDefinitionRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeNameParameter = "relationshipTypeName";
        String definitionParentTypeNameParameter = "definitionParentTypeName";
        String definitionChildTypeNameParameter = "definitionChildTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        this.invalidParameterHandler.validateName(definitionParentTypeName, "definitionParentTypeName", methodName);
        this.invalidParameterHandler.validateName(definitionChildTypeName, "definitionChildTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        String definitionChildTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        this.unlinkElementFromElement(userId, false, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeGUID, definitionChildTypeName, forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, effectiveTime, methodName);
    }

    public void removeGovernanceDefinition(String userId, String definitionGUID, String definitionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, definitionGUID, definitionGUIDParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGovernanceDefinitions(String userId, String suppliedTypeName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        return this.findBeans(userId, searchString, searchStringParameterName, typeGUID, typeName, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLinkedDefinitions(String userId, String definitionGUID, String definitionGUIDParameterName, String definitionTypeName, String relationshipTypeGUID, String relationshipTypeName, String targetElementType, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, definitionGUID, definitionGUIDParameterName, definitionTypeName, relationshipTypeGUID, relationshipTypeName, targetElementType, null, null, 0, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceDefinitions(String userId, String suppliedTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        return this.getBeansByType(userId, typeGUID, typeName, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceDefinitionsByDomain(String userId, String suppliedTypeName, int domainIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getGovernanceDefinitions(userId, suppliedTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        List<EntityDetail> entities = this.getEntitiesByType(userId, typeGUID, typeName, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getGovernanceDefinitionsByName(String userId, String suppliedTypeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add("title");
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        return this.getBeansByValue(userId, name, nameParameterName, typeGUID, typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceDefinitionsByStringParameter(String userId, String typeGUID, String typeName, String parameterValue, String parameterParameterName, String parameterPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(parameterValue, parameterParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(parameterPropertyName);
        return this.getBeansByValue(userId, parameterValue, parameterParameterName, typeGUID, typeName, specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<Relationship> getGoverningDefinitionLinks(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String governanceDefinitionTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceDefinition";
        if (governanceDefinitionTypeName != null) {
            typeName = governanceDefinitionTypeName;
        }
        return this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", null, typeName, 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGoverningDefinitions(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String governanceDefinitionTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", governanceDefinitionTypeName, null, null, 1, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getScopedGovernanceDefinitions(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String governanceDefinitionTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "3845b5cc-8c85-462f-b7e6-47472a568793", "GovernanceDefinitionScope", governanceDefinitionTypeName, null, null, 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceResponsibilitiesForRole(String userId, String personRoleGUID, String personRoleGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, personRoleGUID, personRoleGUIDParameterName, "PersonRole", "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", "GovernanceResponsibility", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGovernanceDefinitionByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GovernanceDefinition", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getGovernanceDefinitionInContext(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, null, null, "GovernanceDefinition", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            List<Relationship> relationships = this.getAllAttachmentLinks(userId, guid, guidParameterName, "GovernanceDefinition", forLineage, forDuplicateProcessing, effectiveTime, methodName);
            return this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName);
        }
        return null;
    }
}

