/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ITInfrastructureBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ITInfrastructureHandler<B>
extends AssetHandler<B> {
    public ITInfrastructureHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void setupHostClusterMember(String userId, String externalSourceGUID, String externalSourceName, String hostClusterGUID, String hostClusterGUIDParameterName, String hostGUID, String hostGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostClusterGUID, hostClusterGUIDParameterName, OpenMetadataType.HOST_CLUSTER.typeName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearHostClusterMember(String userId, String externalSourceGUID, String externalSourceName, String hostClusterGUID, String hostClusterGUIDParameterName, String hostGUID, String hostGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostClusterGUID, hostClusterGUIDParameterName, OpenMetadataType.HOST_CLUSTER.typeName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeGUID, OpenMetadataType.HOST.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupSoftwareServerDeployment(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String softwareServerGUID, String softwareServerGUIDParameterName, Date deploymentTime, String deployer, int serverStatus, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerSupportedCapabilitiesProperties(deploymentTime, deployer, serverStatus, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.DEPLOYED_ON.typeGUID, OpenMetadataType.DEPLOYED_ON.typeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearSoftwareServerDeployment(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String softwareServerGUID, String softwareServerGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeGUID, OpenMetadataType.SOFTWARE_SERVER.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.DEPLOYED_ON.typeGUID, OpenMetadataType.DEPLOYED_ON.typeName, effectiveTime, methodName);
    }

    public void setupSoftwareServerEndpoint(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeName, endpointGUID, endpointGUIDParameterName, "Endpoint", forLineage, forDuplicateProcessing, this.supportedZones, "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearSoftwareServerEndpoint(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeName, endpointGUID, endpointGUIDParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", forLineage, forDuplicateProcessing, "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", effectiveTime, methodName);
    }

    public void setupSupportedSoftwareCapability(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, Date deploymentTime, String deployer, int serverCapabilityStatus, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerSupportedCapabilitiesProperties(deploymentTime, deployer, serverCapabilityStatus, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.IT_INFRASTRUCTURE.typeName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearSupportedSoftwareCapability(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.IT_INFRASTRUCTURE.typeName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupSoftwareCapabilityAssetUse(String userId, String externalSourceGUID, String externalSourceName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, String assetGUID, String assetGUIDParameterName, String description, int useType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getSoftwareServerCapabilitiesAssetUseProperties(description, useType, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearSoftwareCapabilityAssetUse(String userId, String externalSourceGUID, String externalSourceName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupHostNetwork(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, networkGUID, networkGUIDParameterName, "Network", forLineage, forDuplicateProcessing, this.supportedZones, "f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearHostNetwork(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String networkGUID, String networkGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, networkGUID, networkGUIDParameterName, "e0430f59-f021-411a-9d81-883e1ff3f6f6", "Network", forLineage, forDuplicateProcessing, "f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", effectiveTime, methodName);
    }

    public void setupNetworkGatewayLink(String userId, String externalSourceGUID, String externalSourceName, String networkGatewayGUID, String networkGatewayGUIDParameterName, String networkGUID, String networkGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, networkGatewayGUID, networkGatewayGUIDParameterName, "NetworkGateway", networkGUID, networkGUIDParameterName, "Network", forLineage, forDuplicateProcessing, this.supportedZones, "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearNetworkGatewayLink(String userId, String externalSourceGUID, String externalSourceName, String networkGatewayGUID, String networkGatewayGUIDParameterName, String networkGUID, String networkGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, networkGatewayGUID, networkGatewayGUIDParameterName, "NetworkGateway", networkGUID, networkGUIDParameterName, "e0430f59-f021-411a-9d81-883e1ff3f6f6", "Network", forLineage, forDuplicateProcessing, "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", effectiveTime, methodName);
    }

    public void addCloudProviderClassification(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String providerName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(hostGUID, hostGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, "a2bfdd08-d0a8-49db-bc97-7f240628104", "CloudProvider", builder.getCloudProviderProperties(providerName, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCloudProviderClassification(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, "a2bfdd08-d0a8-49db-bc97-7f240628104", "CloudProvider", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCloudPlatformClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformGUIDParameterName, String implementationType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, "1b8f8511-e606-4f65-86d3-84891706ad12", "CloudPlatform", builder.getCloudPlatformProperties(implementationType, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCloudPlatformClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareServerPlatformGUID, String softwareServerPlatformParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, softwareServerPlatformGUID, softwareServerPlatformParameterName, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, "1b8f8511-e606-4f65-86d3-84891706ad12", "CloudPlatform", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCloudTenantClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, String tenantName, String tenantType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerGUID, softwareServerGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeName, "1b8f8522-e606-4f65-86d3-84891706ad12", "CloudTenant", builder.getCloudTenantProperties(tenantName, tenantType, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCloudTenantClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareServerGUID, String softwareServerGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, softwareServerGUID, softwareServerGUIDParameterName, OpenMetadataType.SOFTWARE_SERVER.typeName, "1b8f8522-e606-4f65-86d3-84891706ad12", "CloudTenant", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCloudServiceClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, String offeringName, String serviceType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareCapabilityGUID, softwareCapabilityGUIDParameterName, methodName);
        ITInfrastructureBuilder builder = new ITInfrastructureBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, "337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe6", "CloudService", builder.getCloudServiceProperties(offeringName, serviceType, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCloudServiceClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, "337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe6", "CloudService", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

