/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LocationBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationHandler<B>
extends ReferenceableHandler<B> {
    public LocationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createLocation(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Location";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Location", this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, locationBuilder, effectiveTime, methodName);
    }

    public String createLocationFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String identifier, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setAnchors(userId, null, "Location", "Location", methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, locationBuilder, this.supportedZones, true, false, null, methodName);
    }

    public void updateLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "Location";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Location", this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, locationBuilder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addFixedLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String coordinates, String mapProjection, String postalAddress, String timeZone, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "bc111963-80c7-444f-9715-946c03142dd2", "FixedLocation", builder.getFixedLocationProperties(coordinates, mapProjection, postalAddress, timeZone, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeFixedLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "bc111963-80c7-444f-9715-946c03142dd2", "bc111963-80c7-444f-9715-946c03142dd2", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addSecureLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String description, String level, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", "SecureLocation", builder.getSecureLocationProperties(description, level, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSecureLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCyberLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String networkAddress, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", "CyberLocation", builder.getCyberLocationProperties(networkAddress, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCyberLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, locationParentGUID, locationParentGUIDParameterName, "Location", locationChildGUID, locationChildGUIDParameterName, "Location", forLineage, forDuplicateProcessing, this.supportedZones, "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, locationParentGUID, locationParentGUIDParameterName, "Location", locationChildGUID, locationChildGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", forLineage, forDuplicateProcessing, "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", effectiveTime, methodName);
    }

    public void setupPeerLocations(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, locationOneGUID, locationOneGUIDParameterName, "Location", locationTwoGUID, locationTwoGUIDParameterName, "Location", forLineage, forDuplicateProcessing, this.supportedZones, "017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearPeerLocations(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, locationOneGUID, locationOneGUIDParameterName, "Location", locationTwoGUID, locationTwoGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", forLineage, forDuplicateProcessing, "017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", effectiveTime, methodName);
    }

    public void setupProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String actorProfileGUIDParameterName, String locationGUID, String locationGUIDParameterName, String associationType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "associationType", associationType, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, actorProfileGUID, actorProfileGUIDParameterName, "ActorProfile", locationGUID, locationGUIDParameterName, "Location", forLineage, forDuplicateProcessing, this.supportedZones, "4d652ef7-99c7-4ec3-a2fd-b10c0a1ab4b4", "ProfileLocation", this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String actorProfileGUIDParameterName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, actorProfileGUID, actorProfileGUIDParameterName, "ActorProfile", locationGUID, locationGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", forLineage, forDuplicateProcessing, "4d652ef7-99c7-4ec3-a2fd-b10c0a1ab4b4", "ProfileLocation", effectiveTime, methodName);
    }

    public void setupAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "Location", assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", effectiveTime, methodName);
    }

    public void removeLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAdjacentLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", "Location", null, null, 0, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getNestedLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", "Location", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGroupingLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", "Location", null, null, 1, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssetLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetLocations(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAssetLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", "Location", null, null, 1, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getProfileLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getProfileLocations(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getProfileLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "4d652ef7-99c7-4ec3-a2fd-b10c0a1ab4b4", "ProfileLocation", "Location", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findLocations(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLocationsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.IDENTIFIER.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getLocations(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

