/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class NoteHandler<B>
extends ReferenceableHandler<B> {
    public NoteHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String attachNewNote(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String noteLogGUID, String noteLogGUIDParameterName, String suppliedQualifiedName, String title, String text, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "text";
        String noteGUIDParameter = "noteGUID";
        String anchorGUIDParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(noteLogGUID, noteLogGUIDParameterName, methodName);
        this.invalidParameterHandler.validateText(text, "text", methodName);
        Object qualifiedName = "NoteLog:" + noteLogGUID + ":Note:" + new Date().getTime();
        if (suppliedQualifiedName != null) {
            qualifiedName = suppliedQualifiedName;
        }
        NoteBuilder builder = new NoteBuilder((String)qualifiedName, title, text, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String noteGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "2a84d94c-ac6f-4be1-a72a-07dcec7b1fe3", "NoteEntry", builder, effectiveTime, methodName);
        if (noteGUID != null) {
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, noteLogGUID, noteLogGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, noteGUID, "noteGUID", "NoteEntry", forLineage, forDuplicateProcessing, this.supportedZones, "38edecc6-f385-4574-8144-524a44e3e712", "AttachedNoteLogEntry", null, effectiveFrom, methodName);
        }
        return noteGUID;
    }

    public void updateNote(String userId, String externalSourceGUID, String externalSourceName, String noteGUID, String noteGUIDParameterName, String qualifiedName, String title, String noteText, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "noteText";
        this.invalidParameterHandler.validateText(noteText, "noteText", methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, noteGUID, noteGUIDParameterName, "NoteEntry", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        NoteBuilder builder = new NoteBuilder(qualifiedName, title, noteText, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, noteGUIDParameterName, "2a84d94c-ac6f-4be1-a72a-07dcec7b1fe3", "NoteEntry", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeNoteFromElement(String userId, String externalSourceGUID, String externalSourceName, String noteGUID, String noteGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, noteGUID, noteGUIDParameterName, "2a84d94c-ac6f-4be1-a72a-07dcec7b1fe3", "NoteEntry", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getNotes(String userId, String noteLogGUID, String noteLogGUIDParameterName, String noteLogTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, noteLogGUID, noteLogGUIDParameterName, noteLogTypeName, "38edecc6-f385-4574-8144-524a44e3e712", "AttachedNoteLogEntry", "NoteEntry", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getNotes(String userId, String noteLogGUID, String noteLogGUIDParameterName, String noteLogTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, noteLogGUID, noteLogGUIDParameterName, noteLogTypeName, "38edecc6-f385-4574-8144-524a44e3e712", "AttachedNoteLogEntry", "NoteEntry", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findNotes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "2a84d94c-ac6f-4be1-a72a-07dcec7b1fe3", "NoteEntry", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

