/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteLogBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class NoteLogHandler<B>
extends ReferenceableHandler<B> {
    public NoteLogHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String attachNewNoteLog(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String parentGUID, String parentGUIDParameterName, String qualifiedName, String name, String description, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "name";
        String noteLogGUIDParameter = "noteLogGUID";
        String anchorGUIDParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateText("name", "name", methodName);
        NoteLogBuilder builder = new NoteLogBuilder(qualifiedName, name, description, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String noteLogGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "646727c7-9ad4-46fa-b660-265489ad96c6", "NoteLog", builder, effectiveTime, methodName);
        if (noteLogGUID != null) {
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentGUID, parentGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, noteLogGUID, "noteLogGUID", "NoteLog", forLineage, forDuplicateProcessing, this.supportedZones, "4f798c0c-6769-4a2d-b489-d2714d89e0a4", "AttachedNoteLog", builder.getRelationshipInstanceProperties(methodName), effectiveFrom, methodName);
        }
        return noteLogGUID;
    }

    public void updateNoteLog(String userId, String externalSourceGUID, String externalSourceName, String noteLogGUID, String noteLogGUIDParameterName, String qualifiedName, String noteLogType, String noteLogText, boolean isPublic, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "noteLogText";
        this.invalidParameterHandler.validateText(noteLogText, "noteLogText", methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, noteLogGUID, noteLogGUIDParameterName, "NoteLog", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        NoteLogBuilder builder = new NoteLogBuilder(qualifiedName, noteLogType, noteLogText, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, noteLogGUIDParameterName, "646727c7-9ad4-46fa-b660-265489ad96c6", "NoteLog", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, noteLogGUIDParameterName, "NoteLog", "4f798c0c-6769-4a2d-b489-d2714d89e0a4", "AttachedNoteLog", null, OpenMetadataType.REFERENCEABLE.typeName, 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            this.errorHandler.handleNoRelationship(noteLogGUID, "NoteLog", "AttachedNoteLog", methodName);
        } else if (relationships.size() == 1) {
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationships.get(0), builder.getRelationshipInstanceProperties(methodName), methodName);
        } else {
            this.errorHandler.handleAmbiguousRelationships(noteLogGUID, "NoteLog", "AttachedNoteLog", relationships, methodName);
        }
    }

    public void removeNoteLogFromElement(String userId, String externalSourceGUID, String externalSourceName, String noteLogGUID, String noteLogGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, noteLogGUID, noteLogGUIDParameterName, "646727c7-9ad4-46fa-b660-265489ad96c6", "NoteLog", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAttachedNoteLogs(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "4f798c0c-6769-4a2d-b489-d2714d89e0a4", "AttachedNoteLog", "NoteLog", null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAttachedNoteLogs(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, "4f798c0c-6769-4a2d-b489-d2714d89e0a4", "AttachedNoteLog", "NoteLog", null, null, 2, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findNoteLogs(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "646727c7-9ad4-46fa-b660-265489ad96c6", "NoteLog", null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getNoteLogsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "646727c7-9ad4-46fa-b660-265489ad96c6", "NoteLog", specificMatchPropertyNames, true, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }
}

