/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class OCFConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    protected OCFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected void setUpElementHeader(ElementHeader elementHeader, EntityDetail entity, String expectedTypeName, String methodName) throws PropertyServerException {
        if (entity != null) {
            super.validateInstanceType(expectedTypeName, elementHeader.getClass().getName(), (InstanceAuditHeader)entity, methodName);
            elementHeader.setGUID(entity.getGUID());
            elementHeader.setType(this.getElementType((InstanceAuditHeader)entity));
            elementHeader.setClassifications(this.getEntityClassifications(entity));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(entity.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(entity.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(entity.getMetadataCollectionName());
            elementOrigin.setLicense(entity.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)entity));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    protected void setUpElementHeader(ElementHeader elementHeader, InstanceHeader instanceHeader, List<Classification> classifications, String methodName) throws PropertyServerException {
        if (instanceHeader != null) {
            elementHeader.setGUID(instanceHeader.getGUID());
            elementHeader.setType(this.getElementType((InstanceAuditHeader)instanceHeader));
            elementHeader.setClassifications(this.getElementClassifications(classifications));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(instanceHeader.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(instanceHeader.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(instanceHeader.getMetadataCollectionName());
            elementOrigin.setLicense(instanceHeader.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)instanceHeader));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    protected ElementClassification getClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || !classification.getClassificationName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    protected List<ElementClassification> removeClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            ArrayList<ElementClassification> results = new ArrayList<ElementClassification>();
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || classification.getClassificationName().equals(classificationName)) continue;
                results.add(classification);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    protected DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.SORT_ORDER.name, instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return DataItemSortOrder.UNSORTED;
    }

    protected Connection getEmbeddedConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "VirtualConnection")) {
                return this.getNewVirtualConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Connection")) {
                return this.getNewConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType("Connection", beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Connection getNewVirtualConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            VirtualConnection connection = new VirtualConnection();
            this.fillInConnectionProperties((Connection)connection, primaryEntity, relationships, methodName);
            if (relationships == null || relationships.isEmpty()) {
                return null;
            }
            HashMap<String, EntityDetail> entityDetailMap = new HashMap<String, EntityDetail>();
            if (supplementaryEntities != null) {
                for (EntityDetail entity : supplementaryEntities) {
                    if (entity == null || entity.getGUID() == null) continue;
                    entityDetailMap.put(entity.getGUID(), entity);
                }
            }
            if (entityDetailMap.isEmpty()) {
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                return null;
            }
            ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
            for (Relationship relationship : relationships) {
                EntityDetail embeddedConnectionEntity;
                EntityProxy embeddedConnectionProxy;
                EntityProxy parentConnectionProxy;
                if (relationship == null || relationship.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection") || (parentConnectionProxy = relationship.getEntityOneProxy()) == null || !primaryEntity.getGUID().equals(parentConnectionProxy.getGUID()) || (embeddedConnectionProxy = relationship.getEntityTwoProxy()) == null || embeddedConnectionProxy.getGUID() == null || (embeddedConnectionEntity = (EntityDetail)entityDetailMap.get(embeddedConnectionProxy.getGUID())) == null) continue;
                InstanceProperties properties = relationship.getProperties();
                EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                embeddedConnection.setPosition(this.getPosition(properties));
                embeddedConnection.setDisplayName(this.getDisplayName(properties));
                embeddedConnection.setArguments(this.getArguments(properties));
                embeddedConnection.setEmbeddedConnection(this.getEmbeddedConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName));
                embeddedConnections.add(embeddedConnection);
            }
            if (!embeddedConnections.isEmpty()) {
                connection.setEmbeddedConnections(embeddedConnections);
            }
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Connection getNewConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Connection connection = new Connection();
            this.fillInConnectionProperties(connection, primaryEntity, relationships, methodName);
            if (supplementaryEntities != null) {
                for (EntityDetail entity : supplementaryEntities) {
                    if (entity == null || entity.getType() == null) continue;
                    String actualTypeName = entity.getType().getTypeDefName();
                    if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "Endpoint")) {
                        Endpoint endpoint = this.getEndpoint(entity, methodName);
                        connection.setEndpoint(endpoint);
                        continue;
                    }
                    if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "ConnectorType")) continue;
                    ConnectorType connectorType = this.getConnectorType(entity, methodName);
                    connection.setConnectorType(connectorType);
                }
            }
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private void fillInConnectionProperties(Connection connection, EntityDetail entity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        this.setUpElementHeader((ElementHeader)connection, entity, "Connection", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        connection.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connection.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connection.setDisplayName(this.removeDisplayName(instanceProperties));
        connection.setDescription(this.removeDescription(instanceProperties));
        connection.setSecuredProperties(this.removeSecuredProperties(instanceProperties));
        connection.setConfigurationProperties(this.removeConfigurationProperties(instanceProperties));
        connection.setUserId(this.removeUserId(instanceProperties));
        connection.setClearPassword(this.removeClearPassword(instanceProperties));
        connection.setEncryptedPassword(this.removeEncryptedPassword(instanceProperties));
        connection.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionToAsset")) continue;
                connection.setAssetSummary(this.getAssetSummary(instanceProperties));
            }
        }
    }

    private Endpoint getEndpoint(EntityDetail entity, String methodName) throws PropertyServerException {
        Endpoint endpoint = new Endpoint();
        this.setUpElementHeader((ElementHeader)endpoint, entity, "Endpoint", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        endpoint.setQualifiedName(this.removeQualifiedName(instanceProperties));
        endpoint.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        endpoint.setDisplayName(this.removeName(instanceProperties));
        endpoint.setDescription(this.removeDescription(instanceProperties));
        endpoint.setAddress(this.removeNetworkAddress(instanceProperties));
        endpoint.setProtocol(this.removeProtocol(instanceProperties));
        endpoint.setEncryptionMethod(this.removeEncryptionMethod(instanceProperties));
        endpoint.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return endpoint;
    }

    private ConnectorType getConnectorType(EntityDetail entity, String methodName) throws PropertyServerException {
        ConnectorType connectorType = new ConnectorType();
        this.setUpElementHeader((ElementHeader)connectorType, entity, "ConnectorType", methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        connectorType.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connectorType.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connectorType.setDisplayName(this.removeDisplayName(instanceProperties));
        connectorType.setDescription(this.removeDescription(instanceProperties));
        connectorType.setSupportedAssetTypeName(this.removeSupportedAssetTypeName(instanceProperties));
        connectorType.setDeployedImplementationType(this.removeDeployedImplementationType(instanceProperties));
        connectorType.setExpectedDataFormat(this.removeExpectedDataFormat(instanceProperties));
        connectorType.setConnectorProviderClassName(this.removeConnectorProviderClassName(instanceProperties));
        connectorType.setConnectorFrameworkName(this.removeConnectorFrameworkName(instanceProperties));
        connectorType.setConnectorInterfaceLanguage(this.removeConnectorInterfaceLanguage(instanceProperties));
        connectorType.setConnectorInterfaces(this.removeConnectorInterfaces(instanceProperties));
        connectorType.setTargetTechnologySource(this.removeTargetTechnologySource(instanceProperties));
        connectorType.setTargetTechnologyName(this.removeTargetTechnologyName(instanceProperties));
        connectorType.setTargetTechnologyInterfaces(this.removeTargetTechnologyInterfaces(instanceProperties));
        connectorType.setTargetTechnologyVersions(this.removeTargetTechnologyVersions(instanceProperties));
        connectorType.setRecognizedAdditionalProperties(this.removeRecognizedAdditionalProperties(instanceProperties));
        connectorType.setRecognizedSecuredProperties(this.removeRecognizedSecuredProperties(instanceProperties));
        connectorType.setRecognizedConfigurationProperties(this.removeRecognizedConfigurationProperties(instanceProperties));
        connectorType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return connectorType;
    }
}

