/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIRootHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryFindEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryFindRelationshipsIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelatedEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositorySelectedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataAPIGenericHandler<B>
extends OpenMetadataAPIRootHandler<B> {
    private static final Logger log = LoggerFactory.getLogger(OpenMetadataAPIGenericHandler.class);

    public OpenMetadataAPIGenericHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, boolean isMergeUpdate, Map<String, Object> classificationProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, classificationProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, instanceProperties, isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail beanEntity, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (beanEntity != null) {
            int latestChangeActionOrdinal;
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, beanEntity.getGUID(), beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            Classification existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName);
            if (existingClassification == null) {
                latestChangeActionOrdinal = 0;
                this.repositoryHandler.classifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, ClassificationOrigin.ASSIGNED, null, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                latestChangeActionOrdinal = 1;
                InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, classificationProperties, existingClassification.getProperties());
                if (newProperties == null && existingClassification.getProperties() == null) {
                    this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_CLASSIFICATION_UPDATE.getMessageDefinition(classificationTypeName, beanEntity.getGUID(), methodName, userId));
                    return;
                }
                if (newProperties != null && newProperties.equals((Object)existingClassification.getProperties())) {
                    this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_CLASSIFICATION_UPDATE.getMessageDefinition(classificationTypeName, beanEntity.getGUID(), methodName, userId));
                    return;
                }
                this.repositoryHandler.reclassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            String actionDescriptionTemplate = "Adding %s classification to %s %s";
            String actionDescription = String.format("Adding %s classification to %s %s", classificationTypeName, beanGUIDTypeName, beanEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, latestChangeActionOrdinal, classificationTypeName, beanEntity.getGUID(), beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 2, latestChangeActionOrdinal, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateClassificationEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, beanGUID, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null) {
            Classification existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName);
            this.invalidParameterHandler.validateObject((Object)existingClassification, classificationTypeName, methodName);
            int latestChangeActionOrdinal = 1;
            InstanceProperties newProperties = existingClassification.getProperties();
            if (newProperties == null) {
                newProperties = new InstanceProperties();
            }
            this.repositoryHandler.reclassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, this.setUpEffectiveDates(newProperties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String actionDescriptionTemplate = "Updating effectivity dates for %s classification to %s %s";
            String actionDescription = String.format("Updating effectivity dates for %s classification to %s %s", classificationTypeName, beanGUIDTypeName, beanGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, latestChangeActionOrdinal, classificationTypeName, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 2, latestChangeActionOrdinal, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateBeanEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeGUID, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanEffectivityDates(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeGUID, beanGUIDTypeName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, this.supportedZones, effectiveTime, methodName);
    }

    public void updateBeanEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeGUID, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, beanGUID, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null) {
            InstanceProperties newProperties = this.setUpEffectiveDates(null, effectiveFrom, effectiveTo);
            this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDTypeGUID, beanGUIDTypeName, newProperties, methodName);
            String actionDescriptionTemplate = "Updating effectivity dates for %s %s";
            String actionDescription = String.format("Updating effectivity dates for %s %s", beanGUIDTypeName, beanGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateRelationshipEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipGUIDTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipEffectivityDates(userId, externalSourceGUID, externalSourceName, relationshipGUID, relationshipGUIDParameterName, relationshipGUIDTypeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void updateRelationshipEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipGUIDTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipGUIDTypeName, effectiveTime, methodName);
        if (relationship != null) {
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            this.validateAnchorEntity(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.validateAnchorEntity(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            InstanceProperties newProperties = relationship.getProperties();
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationshipGUID, this.setUpEffectiveDates(newProperties, effectiveFrom, effectiveTo), methodName);
        }
    }

    private InstanceProperties setUpNewProperties(boolean isMergeUpdate, InstanceProperties suppliedProperties, InstanceProperties existingProperties) {
        InstanceProperties newProperties;
        if (isMergeUpdate) {
            newProperties = existingProperties;
            if (newProperties == null) {
                newProperties = suppliedProperties;
            } else if (suppliedProperties != null) {
                Map propertyMap = suppliedProperties.getInstanceProperties();
                for (String propertyName : propertyMap.keySet()) {
                    if (propertyName == null) continue;
                    newProperties.setProperty(propertyName, (InstancePropertyValue)propertyMap.get(propertyName));
                }
                if (suppliedProperties.getEffectiveFromTime() != null) {
                    newProperties.setEffectiveFromTime(suppliedProperties.getEffectiveFromTime());
                }
                if (suppliedProperties.getEffectiveToTime() != null) {
                    newProperties.setEffectiveToTime(suppliedProperties.getEffectiveToTime());
                }
            }
        } else {
            newProperties = suppliedProperties;
            if (existingProperties != null) {
                if (existingProperties.getEffectiveFromTime() != null) {
                    newProperties.setEffectiveFromTime(existingProperties.getEffectiveFromTime());
                }
                if (existingProperties.getEffectiveToTime() != null) {
                    newProperties.setEffectiveToTime(existingProperties.getEffectiveToTime());
                }
            }
        }
        return newProperties;
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean isMergeUpdate, InstanceProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, isMergeUpdate, relationshipProperties, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean isMergeUpdate, InstanceProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            this.validateAnchorEntity(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.validateAnchorEntity(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (newProperties == null && relationship.getProperties() == null) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_RELATIONSHIP_UPDATE.getMessageDefinition(relationship.getType().getTypeDefName(), relationship.getGUID(), methodName, userId));
                return;
            }
            if (newProperties != null && newProperties.equals((Object)relationship.getProperties())) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_RELATIONSHIP_UPDATE.getMessageDefinition(relationship.getType().getTypeDefName(), relationship.getGUID(), methodName, userId));
                return;
            }
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
        }
    }

    public void deleteRelationship(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            this.validateAnchorEntity(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            this.validateAnchorEntity(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    Classification getExistingClassification(EntitySummary beanEntity, String classificationTypeName) {
        List existingClassifications;
        Classification existingClassification = null;
        if (beanEntity != null && (existingClassifications = beanEntity.getClassifications()) != null) {
            for (Classification classification : existingClassifications) {
                if (classification == null || !classificationTypeName.equals(classification.getName())) continue;
                existingClassification = classification;
            }
        }
        return existingClassification;
    }

    public void removeClassificationFromRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void removeClassificationFromRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Classification existingClassification;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, beanGUID, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null && (existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName)) != null) {
            this.repositoryHandler.declassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String actionDescriptionTemplate = "Removing %s classification from %s %s";
            String actionDescription = String.format("Removing %s classification from %s %s", classificationTypeName, beanGUIDTypeName, beanGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, 2, classificationTypeName, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 2, 2, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private boolean visibleToUserThroughRelationship(String userId, Relationship relationship, String methodName) {
        if (relationship == null) {
            return false;
        }
        String relationshipTypeName = null;
        if (relationship.getType() != null) {
            relationshipTypeName = relationship.getType().getTypeDefName();
        }
        if (relationshipTypeName == null) {
            return false;
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedLike") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedTag") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedRating") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedComment")) {
            if (userId.equals(relationship.getCreatedBy())) {
                return true;
            }
            return this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, relationship.getProperties(), methodName);
        }
        return true;
    }

    public AnchorIdentifiers getAnchorGUIDFromAnchorsClassification(EntitySummary connectToEntity, String methodName) {
        AnchorIdentifiers anchorIdentifiers = null;
        try {
            Classification anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, connectToEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && anchorsClassification.getProperties() != null) {
                anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorTypeName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorDomainName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorsClassification.getProperties(), methodName);
                if (anchorIdentifiers.anchorGUID == null) {
                    anchorIdentifiers.anchorGUID = connectToEntity.getGUID();
                }
                if ("<unknown>".equals(anchorIdentifiers.anchorGUID)) {
                    String localMethodName = "getAnchorGUIDFromAnchorsClassification";
                    throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("getAnchorGUIDFromAnchorsClassification", this.serviceName, methodName), this.getClass().getName(), "getAnchorGUIDFromAnchorsClassification");
                }
            }
        }
        catch (ClassificationErrorException localMethodName) {
        }
        catch (PropertyServerException error) {
            try {
                this.errorHandler.handleUnsupportedAnchorsType((Exception)((Object)error), methodName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
            }
            catch (PropertyServerException propertyServerException) {
                // empty catch block
            }
        }
        return anchorIdentifiers;
    }

    private void maintainAnchorGUIDInClassification(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntitySummary targetEntity, AnchorIdentifiers anchorIdentifiers, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Classification anchorsClassification;
        InstanceProperties anchorsProperties = null;
        String currentAnchorGUID = null;
        String newAnchorGUID = null;
        if (anchorIdentifiers != null) {
            newAnchorGUID = anchorIdentifiers.anchorGUID;
        }
        if ("<unknown>".equals(newAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        try {
            anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, targetEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && (anchorsProperties = anchorsClassification.getProperties()) != null) {
                currentAnchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
            }
        }
        catch (ClassificationErrorException noAnchorsClassification) {
            anchorsClassification = null;
        }
        if ("<unknown>".equals(currentAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        if (currentAnchorGUID == null && newAnchorGUID != null || currentAnchorGUID != null && !currentAnchorGUID.equals(newAnchorGUID)) {
            try {
                if (anchorIdentifiers != null) {
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_GUID.name, anchorIdentifiers.anchorGUID, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorIdentifiers.anchorTypeName, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorIdentifiers.anchorDomainName, methodName);
                }
                if (anchorsClassification == null) {
                    this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (newAnchorGUID != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, targetGUID, targetGUIDParameterName, targetTypeName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (targetEntity instanceof EntityDetail) {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, (EntityDetail)targetEntity, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (Exception error) {
                String typeName = "<null>";
                String typeGUID = "<null>";
                if (targetEntity.getType() != null) {
                    typeName = targetEntity.getType().getTypeDefName();
                    typeGUID = targetEntity.getType().getTypeDefGUID();
                }
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, targetGUID, typeName, typeGUID, methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaType(String userId, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6", "APIHeader", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "4ab3b466-31bd-48ea-8aa2-75623476f2e2", "APIRequest", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "e8001de2-1bb1-442b-a66f-9addc3641eae", "APIResponse", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaAttribute(String userId, String attributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, false, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueParentRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForConnection(String userId, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, "Connection", true, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForEndpoint(String userId, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, "Endpoint", "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            if (relationships.size() == 1) {
                EntityProxy proxy = ((Relationship)relationships.get(0)).getEntityOneProxy();
                if (proxy != null && proxy.getGUID() != null && proxy.getType() != null) {
                    AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                    anchorIdentifiers.anchorGUID = proxy.getGUID();
                    anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                    return anchorIdentifiers;
                }
            } else {
                return null;
            }
        }
        if ((relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, "Endpoint", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", 2, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName)) != null && relationships.size() == 1) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForLike(String userId, String likeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, likeGUID, "Like", false, "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForRating(String userId, String ratingGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, ratingGUID, "Rating", false, "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForOpenDiscoveryAnalysisReport(String userId, String reportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, reportGUID, "OpenDiscoveryAnalysisReport", false, "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSurveyReport(String userId, String reportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, reportGUID, OpenMetadataType.SURVEY_REPORT.typeName, false, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotation(String userId, String annotationGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, annotationGUID, OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null || annotationGUID.equals(proxy.getGUID()) || !this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.SURVEY_REPORT.typeName)) continue;
                return this.getAnchorGUIDForSurveyReport(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotationReview(String userId, String annotationReviewGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, annotationReviewGUID, OpenMetadataType.ANNOTATION_REVIEW.typeName, false, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForDataField(String userId, String dataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, dataFieldGUID, OpenMetadataType.DATA_FIELD.typeName, false, "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForComment(String userId, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, commentGUID, OpenMetadataType.COMMENT.typeName, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                AnchorIdentifiers parentAnchorIdentifiers;
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                if (!commentGUID.equals(proxy.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.COMMENT.typeName) && (parentAnchorIdentifiers = this.getAnchorGUIDForComment(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                    return parentAnchorIdentifiers;
                }
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForGlossaryTerm(String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryTermGUID, "GlossaryTerm", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForGlossaryCategory(String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryCategoryGUID, "GlossaryCategory", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", 1, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers deriveAnchorGUID(String targetGUID, String targetTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AnchorIdentifiers anchorIdentifiers = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "SchemaType")) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaType(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaAttribute(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Connection")) {
            anchorIdentifiers = this.getAnchorGUIDForConnection(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Endpoint")) {
            anchorIdentifiers = this.getAnchorGUIDForEndpoint(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.COMMENT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForComment(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Rating")) {
            anchorIdentifiers = this.getAnchorGUIDForRating(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Like")) {
            anchorIdentifiers = this.getAnchorGUIDForLike(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "OpenDiscoveryAnalysisReport")) {
            anchorIdentifiers = this.getAnchorGUIDForOpenDiscoveryAnalysisReport(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SURVEY_REPORT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSurveyReport(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotation(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION_REVIEW.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotationReview(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.DATA_FIELD.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForDataField(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "GlossaryTerm")) {
            anchorIdentifiers = this.getAnchorGUIDForGlossaryTerm(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "GlossaryCategory")) {
            anchorIdentifiers = this.getAnchorGUIDForGlossaryCategory(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ASSET.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Person")) {
            anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = targetGUID;
            anchorIdentifiers.anchorTypeName = targetTypeName;
        }
        if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null && anchorIdentifiers.anchorTypeName != null && anchorIdentifiers.anchorDomainName == null) {
            anchorIdentifiers.anchorDomainName = this.getDomainName(anchorIdentifiers.anchorTypeName);
        }
        return anchorIdentifiers;
    }

    private String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail targetElement;
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && (targetElement = this.repositoryHandler.getEntityByGUID(this.localServerUserId, targetGUID, targetGUIDParameterName, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    private String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntityDetail targetElement, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && targetElement != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    public EntityDetail validateAnchorEntity(String userId, String connectToGUID, String connectToGUIDParameterName, String connectToType, boolean isExplicitGetRequest, boolean isUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectToGUID, connectToGUIDParameterName, methodName);
        EntityDetail connectToEntity = this.repositoryHandler.getEntityByGUID(userId, connectToGUID, connectToGUIDParameterName, connectToType, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.validateAnchorEntity(userId, connectToGUID, connectToType, connectToEntity, connectToGUIDParameterName, isExplicitGetRequest, isUpdate, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
    }

    public EntityDetail validateAnchorEntity(String userId, String connectToGUID, String connectToType, EntityDetail connectToEntity, String connectToGUIDParameterName, boolean isExplicitGetRequest, boolean isUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceType anchorEntityType;
        this.invalidParameterHandler.validateObject((Object)connectToEntity, connectToGUIDParameterName, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "InformalTag")) {
            if (!this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, connectToEntity.getProperties(), methodName) && !userId.equals(connectToEntity.getCreatedBy())) {
                this.invalidParameterHandler.throwUnknownElement(userId, connectToGUID, connectToType, this.serviceName, this.serverName, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Connection")) {
            this.securityVerifier.validateUserForConnection(userId, connectToEntity, this.repositoryHelper, this.serviceName, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.ASSET.typeName)) {
            this.securityVerifier.validateUserForAssetRead(userId, connectToGUID, connectToGUIDParameterName, connectToEntity, isExplicitGetRequest, suppliedSupportedZones, this.repositoryHelper, this.serviceName, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Glossary")) {
            this.securityVerifier.validateUserForGlossaryRead(userId, connectToEntity, this.repositoryHelper, this.serviceName, methodName);
        }
        EntityDetail anchorEntity = null;
        AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)connectToEntity, methodName);
        if (anchorIdentifiers == null && (anchorIdentifiers = this.deriveAnchorGUID(connectToGUID, connectToEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(connectToGUID, connectToGUIDParameterName, connectToType, (EntitySummary)connectToEntity, anchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
            String anchorGUIDParameterName = "anchorIdentifiers";
            anchorEntity = !anchorIdentifiers.anchorGUID.equals(connectToEntity.getGUID()) ? this.repositoryHandler.getEntityByGUID(userId, anchorIdentifiers.anchorGUID, "anchorIdentifiers", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName) : connectToEntity;
        }
        if (anchorEntity != null && (anchorEntityType = anchorEntity.getType()) != null) {
            boolean isFeedbackEntity;
            boolean bl = isFeedbackEntity = this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "InformalTag") || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.COMMENT.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Rating") || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Like");
            if (OpenMetadataType.ASSET.typeName.equals(anchorEntityType.getTypeDefName())) {
                this.securityVerifier.validateUserForAssetAttachment(userId, connectToGUID, connectToGUIDParameterName, anchorEntity, isFeedbackEntity, isUpdate, suppliedSupportedZones, this.repositoryHelper, this.serviceName, methodName);
            } else if ("Glossary".equals(anchorEntityType.getTypeDefName())) {
                if (isFeedbackEntity) {
                    this.securityVerifier.validateUserForGlossaryFeedback(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
                } else if (isUpdate) {
                    this.securityVerifier.validateUserForGlossaryMemberUpdate(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
                } else {
                    this.securityVerifier.validateUserForGlossaryRead(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
                }
            }
        }
        return anchorEntity;
    }

    public void validateUniqueProperty(String entityGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> existingEntities;
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(uniqueParameterName);
        String owningEntityTypeGUID = null;
        String owningEntityTypeName = null;
        String entityTypeNameToCheck = entityTypeName;
        while (owningEntityTypeGUID == null) {
            TypeDefLink superTypeDefLink;
            TypeDef potentialOwningEntityTypeDef = this.repositoryHelper.getTypeDefByName(methodName, entityTypeNameToCheck);
            List typeDefAttributes = potentialOwningEntityTypeDef.getPropertiesDefinition();
            if (typeDefAttributes != null && !typeDefAttributes.isEmpty()) {
                for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                    if (!typeDefAttribute.isUnique() || !typeDefAttribute.getAttributeName().equals(uniqueParameterName)) continue;
                    owningEntityTypeGUID = potentialOwningEntityTypeDef.getGUID();
                    owningEntityTypeName = potentialOwningEntityTypeDef.getName();
                }
            }
            if ((superTypeDefLink = potentialOwningEntityTypeDef.getSuperType()) == null) break;
            entityTypeNameToCheck = superTypeDefLink.getName();
        }
        if ((existingEntities = this.getEntitiesByValue(this.localServerUserId, uniqueParameterValue, uniqueParameterName, owningEntityTypeGUID, owningEntityTypeName, propertyNames, true, false, null, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, false, false, this.supportedZones, null, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) != null && !existingEntities.isEmpty()) {
            if (entityGUID != null) {
                for (EntityDetail existingEntity : existingEntities) {
                    if (existingEntity == null || entityGUID.equals(existingEntity.getGUID())) continue;
                    this.invalidParameterHandler.throwUniqueNameInUse(uniqueParameterValue, uniqueParameterName, entityTypeName, this.serviceName, methodName);
                }
            } else {
                this.invalidParameterHandler.throwUniqueNameInUse(uniqueParameterValue, uniqueParameterName, entityTypeName, this.serviceName, methodName);
            }
        }
    }

    private void validateUniqueProperties(String entityGUID, String entityTypeName, InstanceProperties newProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Iterator uniquePropertyNames;
        InstanceProperties uniqueProperties = this.repositoryHelper.getUniqueProperties(this.serviceName, entityTypeName, newProperties);
        if (uniqueProperties != null && uniqueProperties.getPropertyCount() > 0 && (uniquePropertyNames = uniqueProperties.getPropertyNames()) != null) {
            while (uniquePropertyNames.hasNext()) {
                String uniquePropertyName = (String)uniquePropertyNames.next();
                if (uniquePropertyName == null) continue;
                InstancePropertyValue uniquePropertyValue = uniqueProperties.getPropertyValue(uniquePropertyName);
                this.validateUniqueProperty(entityGUID, entityTypeName, uniquePropertyValue.valueAsString(), uniquePropertyName, effectiveTime, methodName);
            }
        }
    }

    void validateNewEntityRequest(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties newProperties, List<Classification> classifications, InstanceStatus instanceStatus, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.validateUniqueProperties(null, entityTypeName, newProperties, effectiveTime, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.ASSET.typeName)) {
            this.securityVerifier.validateUserForAssetCreate(userId, entityTypeGUID, entityTypeName, newProperties, classifications, instanceStatus, this.defaultZones, this.repositoryHelper, this.serviceName, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "Glossary")) {
            this.securityVerifier.validateUserForGlossaryCreate(userId, entityTypeGUID, entityTypeName, newProperties, classifications, instanceStatus, this.repositoryHelper, this.serviceName, methodName);
        }
    }

    private InstanceProperties getLatestChangeClassificationProperties(int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, String methodName) throws TypeErrorException {
        InstanceProperties properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CHANGE_TARGET.name, "a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d", "LatestChangeTarget", latestChangeTargetOrdinal, methodName);
        properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CHANGE_ACTION.name, "032d844b-868f-4c4a-bc5d-81f0f9704c4d", "LatestChangeAction", latestChangeActionOrdinal, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CLASSIFICATION_NAME.name, classificationName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ATTACHMENT_GUID.name, attachmentGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ATTACHMENT_TYPE.name, attachmentTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RELATIONSHIP_TYPE.name, relationshipTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USER.name, userId, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_DESCRIPTION.name, actionDescription, methodName);
        return properties;
    }

    public void addAnchorGUIDToBuilder(String userId, String anchorGUID, String anchorGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, List<String> serviceSuppliedSupportedZones, OpenMetadataAPIGenericBuilder builder, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail anchorEntity;
        if (anchorGUID != null && (anchorEntity = this.getEntityFromRepository(userId, anchorGUID, anchorGUIDParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, forLineage, forDuplicateProcessing, serviceSuppliedSupportedZones, effectiveTime, methodName)) != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
        }
    }

    public String getDomainName(EntitySummary instance) {
        return this.getDomainName(instance.getType().getTypeDefName());
    }

    public String getDomainName(String typeName) {
        String anchorDomainName = typeName;
        List superTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeName);
        if (superTypes != null) {
            for (TypeDefLink typeDefLink : superTypes) {
                if (OpenMetadataType.OPEN_METADATA_ROOT.typeName.equals(typeDefLink.getName()) || OpenMetadataType.REFERENCEABLE.typeName.equals(typeDefLink.getName())) continue;
                anchorDomainName = typeDefLink.getName();
            }
        }
        return anchorDomainName;
    }

    public void addAnchorsClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String anchorGUID, String anchorTypeName, String anchorDomainName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, builder.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private void addLatestChangeToAnchor(EntityDetail anchorEntity, int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        AnchorIdentifiers parentAnchorIdentifiers;
        String guidParameterName = "anchorEntity.getGUID()";
        InstanceProperties newProperties = null;
        String anchorTypeName = anchorEntity.getType().getTypeDefName();
        if ((this.repositoryHelper.isTypeOf(this.serviceName, anchorTypeName, OpenMetadataType.ASSET.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, anchorTypeName, "Glossary")) && !OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classificationName)) {
            try {
                this.invalidParameterHandler.validateObject((Object)anchorEntity, "anchorEntity.getGUID()", methodName);
                newProperties = this.getLatestChangeClassificationProperties(latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, methodName);
                Classification classification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)anchorEntity, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, methodName);
                if (classification != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), "anchorEntity.getGUID()", anchorEntity.getType().getTypeDefName(), OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeGUID, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, (InstanceAuditHeader)classification, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (ClassificationErrorException newClassificationNeeded) {
                try {
                    this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), anchorEntity, "anchorEntity.getGUID()", anchorEntity.getType().getTypeDefName(), OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeGUID, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                catch (PropertyServerException propertyServerException) {}
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | TypeErrorException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
        }
        if ((parentAnchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)anchorEntity, methodName)) != null && !anchorEntity.getGUID().equals(parentAnchorIdentifiers.anchorGUID)) {
            try {
                String parentAnchorGUIDParameterName = "parentAnchorGUID";
                EntityDetail parentAnchorEntity = this.repositoryHandler.getEntityByGUID(userId, parentAnchorIdentifiers.anchorGUID, "parentAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.addLatestChangeToAnchor(parentAnchorEntity, latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)((Object)error));
            }
        }
    }

    private String getSupplementaryPropertiesGlossary(boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryGUID = this.getEntityGUIDByValue(this.localServerUserId, "Supplementary Properties Glossary", "supplementaryPropertiesGlossaryName", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", this.qualifiedNamePropertyNamesList, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryGUID == null) {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, "Supplementary Properties Glossary", methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, "Supplementary Properties Glossary", methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, "This glossary contains glossary terms containing the business-oriented descriptive names and related properties for open metadata assets.", methodName);
            glossaryGUID = this.repositoryHandler.createEntity(this.localServerUserId, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, properties, null, InstanceStatus.ACTIVE, methodName);
        }
        return glossaryGUID;
    }

    private InstanceProperties getSupplementaryInstanceProperties(InstanceProperties existingProperties, String qualifiedName, String displayName, String summary, String description, String abbreviation, String usage, String methodName) {
        InstanceProperties properties = existingProperties;
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUMMARY.name, summary, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ABBREVIATION.name, abbreviation, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, usage, methodName);
        return properties;
    }

    public void maintainSupplementaryProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String elementDomainName, String elementQualifiedName, String displayName, String summary, String description, String abbreviation, String usage, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail glossaryTerm = this.getAttachedEntity(this.localServerUserId, elementGUID, elementGUIDParameterName, elementTypeName, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", OpenMetadataType.GLOSSARY_TERM.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (glossaryTerm == null) {
            String glossaryGUID;
            InstanceProperties glossaryTermProperties;
            if ((displayName != null || summary != null || description != null || abbreviation != null || usage != null) && (glossaryTermProperties = this.getSupplementaryInstanceProperties(null, elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName)) != null && (glossaryGUID = this.getSupplementaryPropertiesGlossary(forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                ArrayList<Classification> initialClassifications = new ArrayList<Classification>();
                try {
                    InstanceProperties classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANCHOR_GUID.name, elementGUID, methodName);
                    classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, elementTypeName, methodName);
                    classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, elementDomainName, methodName);
                    Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, OpenMetadataType.GLOSSARY_TERM.typeName, ClassificationOrigin.ASSIGNED, null, classificationProperties);
                    initialClassifications.add(classification);
                    classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "ElementSupplement", OpenMetadataType.GLOSSARY_TERM.typeName, ClassificationOrigin.ASSIGNED, null, null);
                    initialClassifications.add(classification);
                }
                catch (TypeErrorException error) {
                    throw new PropertyServerException((OCFCheckedExceptionBase)((Object)error));
                }
                String glossaryTermGUID = this.repositoryHandler.createEntity(this.localServerUserId, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, glossaryTermProperties, initialClassifications, InstanceStatus.ACTIVE, methodName);
                this.repositoryHandler.createRelationship(userId, OpenMetadataType.TERM_ANCHOR.typeGUID, null, null, glossaryGUID, glossaryTermGUID, null, methodName);
                this.repositoryHandler.createRelationship(userId, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", null, null, elementGUID, glossaryTermGUID, null, methodName);
            }
        } else {
            InstanceProperties glossaryTermProperties = isMergeUpdate ? this.getSupplementaryInstanceProperties(glossaryTerm.getProperties(), elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName) : this.getSupplementaryInstanceProperties(null, elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName);
            this.repositoryHandler.updateEntityProperties(userId, null, null, glossaryTerm.getGUID(), glossaryTerm, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, glossaryTermProperties, methodName);
        }
    }

    public EntityDetail getSupplementaryProperties(String elementGUID, String elementGUIDParameterName, String elementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedEntity(this.localServerUserId, elementGUID, elementGUIDParameterName, elementTypeName, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", OpenMetadataType.GLOSSARY_TERM.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public int countAttachments(String userId, String elementGUID, String elementTypeName, String attachmentTypeGUID, String attachmentTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        int count = 0;
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, elementGUID, elementTypeName, attachmentTypeGUID, attachmentTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            ++count;
        }
        return count;
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntity(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, 0, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.getEntityFromRepository(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, startingEntity, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, resultingElementTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity != null) {
            this.validateAnchorEntity(userId, entity.getGUID(), resultingElementTypeName, entity, startingElementGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return entity;
    }

    public EntityDetail getAttachedEntityFromUser(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getAttachedEntityFromUser";
        RepositoryRelatedEntitiesIterator iterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, null, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
            this.errorHandler.validateInstanceType((InstanceHeader)entity, attachedEntityTypeName, methodName, "getAttachedEntityFromUser");
            return entity;
        }
        return null;
    }

    public List<EntityDetail> getAttachedEntitiesFromUser(String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, String attachedEntityTypeGUID, String attachedEntityTypeName, String sequencingPropertyName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String localMethodName = "getAttachedEntitiesFromUser";
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        RepositoryRelatedEntitiesIterator iterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, sequencingPropertyName, false, false, startingFrom, pageSize, effectiveTime, methodName);
        while (iterator.moreToReceive() && (pageSize == 0 || results.size() < pageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy()) && !userId.equals(entity.getUpdatedBy()) && (entity.getMaintainedBy() == null || !entity.getMaintainedBy().contains(userId))) continue;
            this.errorHandler.validateInstanceType((InstanceHeader)entity, attachedEntityTypeName, methodName, "getAttachedEntitiesFromUser");
            results.add(entity);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getAttachedEntities(userId, startingEntity, startingGUIDParameterName, startingTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getAttachedEntities(String userId, EntityDetail startingElement, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)startingElement, startingElementGUIDParameterName, methodName);
        List<Relationship> visibleRelationships = this.getAttachmentLinks(userId, startingElement, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, null, resultingElementTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (visibleRelationships != null) {
            ArrayList<EntityDetail> visibleEntities = new ArrayList<EntityDetail>();
            for (Relationship relationship : visibleRelationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingElement.getGUID(), startingElementTypeName, relationship, attachmentEntityEnd, methodName)) == null || entityProxy.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, entityProxy.getType().getTypeDefName(), resultingElementTypeName)) continue;
                try {
                    String guidParameterName = "entityProxy.getGUID()";
                    visibleEntities.add(this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxy.getGUID()", resultingElementTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName));
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
                }
            }
            if (!visibleEntities.isEmpty()) {
                return visibleEntities;
            }
        }
        return null;
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntities(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public Relationship getAttachmentLink(String userId, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            return relationship;
        }
        return null;
    }

    public Relationship getUniqueAttachmentLink(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getUniqueAttachmentLink(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public Relationship getUniqueAttachmentLink(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        this.errorHandler.handleAmbiguousRelationships(startingGUID, startingTypeName, attachmentRelationshipTypeName, relationships, methodName);
        return null;
    }

    public List<Relationship> getAllAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, null, null, 0, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getAttachmentLinks(userId, startingEntity, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, EntityDetail startingEntity, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)startingEntity, startingGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        this.validateAnchorEntity(userId, startingEntity.getGUID(), startingTypeName, startingEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntity, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, startingFrom, queryPageSize, effectiveTime, methodName);
        ArrayList<Relationship> visibleRelationships = new ArrayList<Relationship>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || visibleRelationships.size() < queryPageSize)) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            EntityProxy otherEnd = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingTypeName, relationship, attachmentEntityEnd, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, otherEnd.getType().getTypeDefName(), attachmentEntityTypeName)) {
                if (attachmentEntityGUID == null || attachmentEntityGUID.equals(otherEnd.getGUID())) {
                    log.debug("Accepting relationship: " + relationship.getGUID());
                    visibleRelationships.add(relationship);
                    continue;
                }
                log.debug("Ignoring relationship based on entity instance: " + relationship.getGUID());
                continue;
            }
            log.debug("Ignoring relationship based on type of attachment: " + relationship.getGUID());
        }
        if (!visibleRelationships.isEmpty()) {
            return visibleRelationships;
        }
        return null;
    }

    public List<Relationship> findAttachmentLinks(String userId, String relationshipTypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        RepositoryFindRelationshipsIterator iterator = new RepositoryFindRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, relationshipTypeGUID, null, searchProperties, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, startingFrom, queryPageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        ArrayList<String> validatedAnchorGUIDs = new ArrayList<String>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            try {
                String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
                String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
                this.validateEntityProxyAnchor(userId, relationship.getEntityOneProxy(), "relationship.getEntityOneProxy().getGUID()", validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                this.validateEntityProxyAnchor(userId, relationship.getEntityTwoProxy(), "relationship.getEntityTwoProxy().getGUID()", validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                results.add(relationship);
            }
            catch (Exception exception) {}
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    private void validateEntityProxyAnchor(String userId, EntityProxy entityProxy, String entityProxyParameterName, List<String> validatedAnchorGUIDs, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entityProxy, methodName);
        if (anchorIdentifiers == null) {
            EntityDetail connectToEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), entityProxyParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entityProxy, methodName);
            if (anchorIdentifiers == null || anchorIdentifiers.anchorGUID == null || !validatedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) {
                this.validateAnchorEntity(userId, entityProxy.getGUID(), entityProxyParameterName, connectToEntity, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
                    validatedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
                }
            }
        } else if (anchorIdentifiers.anchorGUID == null || !validatedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) {
            this.validateAnchorEntity(userId, entityProxy.getGUID(), entityProxyParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (anchorIdentifiers.anchorGUID != null) {
                validatedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
            }
        }
    }

    public String createBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityTypeGUID, String entityTypeName, OpenMetadataAPIGenericBuilder propertyBuilder, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, entityTypeGUID, entityTypeName, null, propertyBuilder, false, effectiveTime, methodName);
    }

    public String createBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityTypeGUID, String entityTypeName, String entityDomainName, OpenMetadataAPIGenericBuilder propertyBuilder, boolean isOwnAnchor, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (isOwnAnchor) {
            propertyBuilder.setAnchors(userId, null, entityTypeName, entityDomainName, methodName);
        }
        this.validateNewEntityRequest(userId, entityTypeGUID, entityTypeName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(), propertyBuilder.getInstanceStatus(), effectiveTime, methodName);
        String entityGUID = this.repositoryHandler.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(), propertyBuilder.getInstanceStatus(), methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.ASSET.typeName)) {
            this.auditLog.logMessage("userAssetMonitoring", GenericHandlersAuditCode.ASSET_ACTIVITY_CREATE.getMessageDefinition(userId, entityTypeName, entityGUID, methodName, this.serviceName));
        }
        return entityGUID;
    }

    public void updateBeanPropertyInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String propertyName, String propertyValue, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyParameterName = "propertyValue";
        String propertyNameParameterName = "propertyName";
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        this.invalidParameterHandler.validateObject((Object)propertyValue, "propertyValue", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, propertyName, propertyValue, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, true, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, InstanceProperties properties, boolean isMergeUpdate, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, false, false, (List<String>)this.supportedZones, properties, isMergeUpdate, new Date(), methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, updateProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, updateProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail originalEntity, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, originalEntity.getGUID(), entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, updateProperties, originalEntity.getProperties());
            if (newProperties == null && originalEntity.getProperties() == null) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_ENTITY_UPDATE.getMessageDefinition(originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, userId));
                return;
            }
            if (newProperties != null && newProperties.equals((Object)originalEntity.getProperties())) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_ENTITY_UPDATE.getMessageDefinition(originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, userId));
                return;
            }
            this.validateUniqueProperties(originalEntity.getGUID(), entityTypeName, newProperties, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                this.securityVerifier.validateUserForAssetUpdate(userId, originalEntity, newProperties, originalEntity.getStatus(), this.repositoryHelper, this.serviceName, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), "Glossary")) {
                this.securityVerifier.validateUserForGlossaryDetailUpdate(userId, originalEntity, newProperties, this.repositoryHelper, this.serviceName, methodName);
            }
            this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), originalEntity, entityTypeGUID, entityTypeName, newProperties, methodName);
            String actionDescriptionTemplate = "Updating properties in %s %s";
            String actionDescription = String.format("Updating properties in %s %s", entityTypeName, originalEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, originalEntity.getGUID(), entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            String entityGUID = "<null>";
            if (originalEntity != null) {
                entityGUID = originalEntity.getGUID();
            }
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    public void updateBeanStatusInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, InstanceStatus newStatus, String newStatusParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, this.supportedZones, newStatus, newStatusParameterName, effectiveTime, methodName);
    }

    public void updateBeanStatusInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceStatus newStatus, String newStatusParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)newStatus, newStatusParameterName, methodName);
        EntityDetail originalEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                this.securityVerifier.validateUserForAssetUpdate(userId, originalEntity, originalEntity.getProperties(), newStatus, this.repositoryHelper, this.serviceName, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), "GlossaryTerm")) {
                this.securityVerifier.validateUserForGlossaryMemberStatusUpdate(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
            }
            this.repositoryHandler.updateEntityStatus(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), originalEntity, entityTypeGUID, entityTypeName, newStatus, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String actionDescriptionTemplate = "Updating instance status in %s %s";
            String actionDescription = String.format("Updating instance status in %s %s", entityTypeName, entityGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 5, 1, null, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 0, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.undoBeanUpdateInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.undoBeanUpdateInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail originalEntity, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String originalEntityParameterName = "originalEntity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, originalEntity.getGUID(), entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            EntityDetail recoveredEntity = this.repositoryHandler.undoEntityUpdate(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), methodName);
            try {
                if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                    this.securityVerifier.validateUserForAssetUpdate(userId, originalEntity, recoveredEntity.getProperties(), recoveredEntity.getStatus(), this.repositoryHelper, this.serviceName, methodName);
                } else if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), "Glossary")) {
                    this.securityVerifier.validateUserForGlossaryDetailUpdate(userId, originalEntity, recoveredEntity.getProperties(), this.repositoryHelper, this.serviceName, methodName);
                }
            }
            catch (UserNotAuthorizedException notAuth) {
                this.repositoryHandler.updateEntity(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), "originalEntity", originalEntity.getType().getTypeDefGUID(), originalEntity.getType().getTypeDefName(), originalEntity.getProperties(), originalEntity.getClassifications(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                throw notAuth;
            }
            String actionDescriptionTemplate = "Undo last update of properties in %s %s";
            String actionDescription = String.format("Undo last update of properties in %s %s", entityTypeName, originalEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, originalEntity.getGUID(), entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (recoveredEntity != null) {
                return this.converter.getNewBean(this.beanClass, recoveredEntity, methodName);
            }
        } else {
            String entityGUID = "<null>";
            if (originalEntity != null) {
                entityGUID = originalEntity.getGUID();
            }
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
        return null;
    }

    private void archiveAnchoredEntity(String userId, String externalSourceGUID, String externalSourceName, EntityDetail anchorEntity, EntityProxy potentialAnchoredEntity, String classificationOriginGUID, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorEntity != null) {
            EntityDetail entity;
            AnchorIdentifiers anchorIdentifiers;
            String guidParameterName = "potentialAnchoredEntity";
            if (potentialAnchoredEntity != null && potentialAnchoredEntity.getType() != null && (anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)(entity = this.repositoryHandler.getEntityByGUID(userId, potentialAnchoredEntity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)), methodName)) != null && anchorIdentifiers.equals(anchorEntity.getGUID())) {
                this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefName(), ClassificationOrigin.PROPAGATED, classificationOriginGUID, classificationProperties, anchorEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, classificationProperties, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityGUIDParameterName, entityTypeName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        this.invalidParameterHandler.validateAnchorGUID(entityGUID, entityGUIDParameterName, anchorEntity, entityGUID, entityTypeName, methodName);
        EntityDetail entity = this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, ClassificationOrigin.ASSIGNED, entityGUID, classificationProperties, anchorEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
            String actionDescriptionTemplate = "Classifying as Memento %s %s";
            String actionDescription = String.format("Classifying as Memento %s %s", entityTypeName, entityGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, 0, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (entity != null) {
                this.addLatestChangeToAnchor(entity, 2, 0, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private EntityDetail archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties, EntityDetail anchorEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail targetEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (targetEntity != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, targetEntity, entityTypeName, null, null, 0, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (anchorEntity == null) {
                    this.archiveAnchoredEntity(userId, externalSourceGUID, externalSourceName, targetEntity, this.repositoryHandler.getOtherEnd(targetEntity.getGUID(), entityTypeName, relationship, 0, methodName), classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    continue;
                }
                this.archiveAnchoredEntity(userId, externalSourceGUID, externalSourceName, anchorEntity, this.repositoryHandler.getOtherEnd(targetEntity.getGUID(), entityTypeName, relationship, 0, methodName), classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.repositoryHandler.classifyEntity(userId, null, null, targetEntity.getGUID(), targetEntity, entityGUIDParameterName, entityTypeName, OpenMetadataType.MEMENTO_CLASSIFICATION.typeGUID, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, classificationOrigin, classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                String qualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, targetEntity.getProperties(), methodName) + "_archivedOn_" + new Date();
                String entityTypeGUID = this.invalidParameterHandler.validateTypeName(entityTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
                this.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return targetEntity;
    }

    public void deleteAnchoredEntity(List<String> anchoredEntityGUIDs, String externalSourceGUID, String externalSourceName, EntityProxy potentialAnchoredEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchoredEntityGUIDs != null && !anchoredEntityGUIDs.isEmpty()) {
            AnchorIdentifiers derivedAnchorGUID;
            String entityTypeName;
            String entityGUID;
            EntityDetail entity;
            AnchorIdentifiers anchorIdentifiers;
            String guidParameterName = "potentialAnchoredEntity";
            if (potentialAnchoredEntity != null && potentialAnchoredEntity.getType() != null && (anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)(entity = this.repositoryHandler.getEntityByGUID(this.localServerUserId, entityGUID = potentialAnchoredEntity.getGUID(), "potentialAnchoredEntity", entityTypeName = potentialAnchoredEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)), methodName)) != null && anchoredEntityGUIDs.contains(anchorIdentifiers.anchorGUID) && (derivedAnchorGUID = this.deriveAnchorGUID(entity.getGUID(), entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) {
                this.deleteBeanInRepository(this.localServerUserId, externalSourceGUID, externalSourceName, entity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefGUID(), potentialAnchoredEntity.getType().getTypeDefName(), null, null, anchoredEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityTypeName, entity, entityGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
        if (anchorEntity != null) {
            anchorEntityGUIDs.add(anchorEntity.getGUID());
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (!entityGUID.equals(anchorEntity.getGUID())) {
                String actionDescriptionTemplate = "Deleting %s %s";
                String actionDescription = String.format("Deleting %s %s", entityTypeName, entityGUID);
                int latestChangeTarget = 4;
                this.addLatestChangeToAnchor(anchorEntity, latestChangeTarget, 2, null, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            anchorEntityGUIDs.add(entity.getGUID());
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, List<String> anchorEntityGUIDs, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorEntityGUIDs == null) {
            anchorEntityGUIDs = new ArrayList<String>();
        }
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, startingEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
            this.securityVerifier.validateUserForAssetDelete(userId, startingEntity, this.repositoryHelper, this.serviceName, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, startingEntity.getType().getTypeDefName(), "Glossary")) {
            this.securityVerifier.validateUserForGlossaryDelete(userId, startingEntity, this.repositoryHelper, this.serviceName, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, startingEntity.getType().getTypeDefName(), "GlossaryTerm") || this.repositoryHelper.isTypeOf(this.serviceName, startingEntity.getType().getTypeDefName(), "GlossaryCategory")) {
            this.securityVerifier.validateUserForGlossaryMemberUpdate(userId, startingEntity, this.repositoryHelper, this.serviceName, methodName);
        }
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntity, entityTypeName, null, null, 0, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            this.deleteAnchoredEntity(anchorEntityGUIDs, externalSourceGUID, externalSourceName, this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), entityTypeName, relationship, 0, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public boolean isBeanIsolated(String userId, String entityGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, entityGUID, entityTypeName, null, null, 0, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        return !iterator.moreToReceive();
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelatedEntityGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationshipPath, relatedEntityTypeName, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Relationship relationship : relationships) {
            EntityProxy entityProxy;
            if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingTypeName, relationship, 0, methodName)) == null) continue;
            try {
                this.validateAnchorEntity(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                results.add(entityProxy.getGUID());
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException nonAccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping entity: " + (OCFCheckedExceptionBase)nonAccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, selectionEnd, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        String result = null;
        for (Relationship relationship : relationships) {
            EntityProxy entityProxy;
            if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingTypeName, relationship, selectionEnd, methodName)) == null) continue;
            try {
                this.validateAnchorEntity(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (result == null) {
                    result = entityProxy.getGUID();
                    continue;
                }
                this.errorHandler.handleAmbiguousRelationships(startingGUID, startingTypeName, attachmentRelationshipTypeName, relationships, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException nonAccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping entity: " + (OCFCheckedExceptionBase)nonAccessibleEntity);
            }
        }
        return result;
    }

    public B getAttachedElement(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        EntityDetail startingEntity = this.getEntityFromRepository(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, startingEntity, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, resultingElementTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity != null) {
            this.validateAnchorEntity(userId, startingElementGUID, startingElementTypeName, entity, startingElementGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, List<Integer> limitResultsByEnumValues, String enumPropertyName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, true, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<B> results = new ArrayList<B>();
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            try {
                B bean;
                Integer relationshipOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, enumPropertyName, relationship.getProperties(), methodName);
                if (!limitResultsByEnumValues.contains(relationshipOrdinal) || (bean = this.getAttachedElement(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationship, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAttachedElements(String userId, String anchorGUID, String anchorGUIDParameterName, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        this.invalidParameterHandler.validateAnchorGUID(anchorGUID, anchorGUIDParameterName, anchorEntity, startingGUID, startingTypeName, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, selectionEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<B> results = new ArrayList<B>();
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            try {
                B bean = this.getAttachedElement(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationship, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getAttachedElement(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, Relationship relationship, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        if (relationship != null) {
            EntityProxy entityProxy = null;
            if (selectionEnd == 0) {
                entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, selectionEnd, methodName);
            } else if (selectionEnd == 1) {
                entityProxy = relationship.getEntityOneProxy();
            } else if (selectionEnd == 2) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            if (entityProxy != null) {
                EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, entityProxy.getGUID(), attachmentEntityTypeName, entity, "relationship.end.guid", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                boolean beanValid = true;
                if (requiredClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, requiredClassificationName, methodName) == null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException error) {
                        beanValid = false;
                    }
                }
                if (omittedClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException classificationErrorException) {
                        // empty catch block
                    }
                }
                if (beanValid) {
                    return this.converter.getNewBean(this.beanClass, entity, relationship, methodName);
                }
            }
        }
        return null;
    }

    public List<EntityDetail> getAttachedFilteredEntities(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String relationshipTypeName, String relationshipTypeGUID, int selectionEnd, Set<String> specificMatchPropertyNames, String searchCriteria, int startFrom, boolean startsWith, boolean ignoreCase, int queryPageSize, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedFilteredEntities(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationshipTypeName, relationshipTypeGUID, selectionEnd, null, null, true, specificMatchPropertyNames, searchCriteria, startFrom, startsWith, ignoreCase, queryPageSize, false, false, new Date(), methodName);
    }

    public List<EntityDetail> getAttachedFilteredEntities(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String relationshipTypeName, String relationshipTypeGUID, int selectionEnd, Set<String> specificMatchPropertyNames, String searchCriteria, int startFrom, boolean startsWith, boolean ignoreCase, int queryPageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedFilteredEntities(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationshipTypeName, relationshipTypeGUID, selectionEnd, null, null, true, specificMatchPropertyNames, searchCriteria, startFrom, startsWith, ignoreCase, queryPageSize, false, false, effectiveTime, methodName);
    }

    public List<EntityDetail> getAttachedFilteredEntities(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String relationshipTypeName, String relationshipTypeGUID, int selectionEnd, String attachedEntityFilterRelationshipTypeName, String attachedEntityFilterRelationshipTypeGUID, boolean attachedEntityParentAtEnd1, Set<String> specificMatchPropertyNames, String searchCriteria, int startFrom, boolean startsWith, boolean ignoreCase, int queryPageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        int localStartFrom = 0;
        RepositoryRelatedEntitiesIterator relatedEntityIterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingGUID, startingTypeName, relationshipTypeGUID, relationshipTypeName, null, forLineage, forDuplicateProcessing, localStartFrom, queryPageSize, selectionEnd, effectiveTime, methodName);
        ArrayList<EntityDetail> resultsToReturn = new ArrayList<EntityDetail>();
        ArrayList<EntityDetail> totalFilteredResults = new ArrayList<EntityDetail>();
        while (relatedEntityIterator.moreToReceive() && (queryPageSize == 0 || resultsToReturn.size() < queryPageSize)) {
            EntityDetail relatedEntity = relatedEntityIterator.getNext();
            if (relatedEntity == null) continue;
            if (log.isDebugEnabled()) {
                String displayName = "";
                String qualifiedName = "";
                if (relatedEntity.getProperties() != null && relatedEntity.getProperties().getInstanceProperties() != null) {
                    if (relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.DISPLAY_NAME.name) != null) {
                        displayName = ((InstancePropertyValue)relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.DISPLAY_NAME.name)).toString();
                    } else if (relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.NAME.name) != null) {
                        displayName = ((InstancePropertyValue)relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.NAME.name)).toString();
                    }
                    if (relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.QUALIFIED_NAME.name) != null) {
                        qualifiedName = ((InstancePropertyValue)relatedEntity.getProperties().getInstanceProperties().get(OpenMetadataProperty.QUALIFIED_NAME.name)).toString();
                    }
                }
                log.debug("getAttachedFilteredEntities - while  relatedEntity guid=" + relatedEntity.getGUID() + ",displayName=" + displayName + ",qualifiedName=" + qualifiedName);
            }
            Relationship parentRelationship = null;
            if (attachedEntityFilterRelationshipTypeGUID != null && attachedEntityFilterRelationshipTypeName != null) {
                parentRelationship = this.repositoryHandler.getUniqueParentRelationshipByType(userId, relatedEntity.getGUID(), relatedEntity.getType().getTypeDefName(), attachedEntityFilterRelationshipTypeGUID, attachedEntityFilterRelationshipTypeName, attachedEntityParentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (log.isDebugEnabled() && parentRelationship != null) {
                    log.debug("getAttachedFilteredEntities - while found parent relationship  parentRelationship" + parentRelationship.getGUID());
                }
            }
            if (parentRelationship != null || !this.entityMatchSearchCriteria(relatedEntity, specificMatchPropertyNames, searchCriteria, !startsWith, ignoreCase)) continue;
            totalFilteredResults.add(relatedEntity);
            if (totalFilteredResults.size() <= startFrom) continue;
            resultsToReturn.add(relatedEntity);
        }
        if (resultsToReturn.isEmpty()) {
            return null;
        }
        return resultsToReturn;
    }

    protected boolean entityMatchSearchCriteria(EntityDetail entity, Set<String> attributeNames, String searchCriteria, boolean exactValue, boolean ignoreCase) {
        if (attributeNames == null) {
            return true;
        }
        if (searchCriteria == null) {
            return true;
        }
        String regExedSearchCriteria = this.regexSearchCriteria(searchCriteria, exactValue, ignoreCase);
        boolean isMatch = false;
        InstanceProperties matchProperties = entity.getProperties();
        Iterator propertyNames = matchProperties.getPropertyNames();
        if (propertyNames != null) {
            while (propertyNames.hasNext()) {
                String currentValue;
                PrimitivePropertyValue ppv;
                PrimitiveDefCategory pdCat;
                InstancePropertyValue instancePropertyValue;
                InstancePropertyCategory ipCat;
                String propertyName = (String)propertyNames.next();
                if (!attributeNames.contains(propertyName) || (ipCat = (instancePropertyValue = matchProperties.getPropertyValue(propertyName)).getInstancePropertyCategory()) != InstancePropertyCategory.PRIMITIVE || (pdCat = (ppv = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory()) != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING || (currentValue = (String)ppv.getPrimitiveValue()) == null || !currentValue.matches(regExedSearchCriteria)) continue;
                isMatch = true;
            }
        }
        return isMatch;
    }

    protected String regexSearchCriteria(String searchCriteria, boolean exactValue, boolean ignoreCase) {
        if (searchCriteria == null || searchCriteria.trim().length() == 0) {
            searchCriteria = ".*";
        } else {
            searchCriteria = searchCriteria.trim();
            searchCriteria = exactValue ? this.repositoryHelper.getExactMatchRegex(searchCriteria, ignoreCase) : this.repositoryHelper.getStartsWithRegex(searchCriteria, ignoreCase);
        }
        return searchCriteria;
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityFromRepository(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(requestedEntityGUID, requestedEntityGUIDParameterName, methodName);
        EntityDetail retrievedEntity = this.repositoryHandler.getEntityByGUID(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.validateAnchorEntity(userId, retrievedEntity.getGUID(), requestedEntityTypeName, retrievedEntity, requestedEntityGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        boolean beanValid = true;
        if (requiredClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, requiredClassificationName, methodName) == null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException error) {
                beanValid = false;
            }
        }
        if (omittedClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, omittedClassificationName, methodName) != null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException classificationErrorException) {
                // empty catch block
            }
        }
        if (!beanValid) {
            return null;
        }
        return retrievedEntity;
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String resultTypeName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, resultTypeName, false, false, this.supportedZones, new Date(), methodName);
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, entityTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, entityTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    public B getBeanFromEntity(String userId, EntityDetail entity, String entityParameterName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)entity, entityParameterName, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanStringPropertyFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, propertyName, false, false, this.supportedZones, effectiveTime, methodName);
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyNameParameter = "propertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        String property = null;
        EntityDetail entityDetail = this.getEntityFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (entityDetail != null) {
            property = this.repositoryHelper.getStringProperty(this.serviceName, propertyName, entityDetail.getProperties(), methodName);
        }
        return property;
    }

    private InstanceProperties getSearchInstanceProperties(String searchValue, List<String> specificMatchPropertyNames, String methodName) {
        InstanceProperties properties = new InstanceProperties();
        for (String propertyName : specificMatchPropertyNames) {
            if (propertyName == null) continue;
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, propertyName, searchValue, methodName);
        }
        return properties;
    }

    RepositoryIteratorForEntities getEntitySearchIterator(String userId, String searchString, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, boolean caseInsensitive, String sequencingPropertyName, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int queryPageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        RepositoryEntitiesIterator iterator;
        if (searchString != null) {
            String searchValue = searchString;
            if (exactValueMatch) {
                searchValue = this.repositoryHelper.getExactMatchRegex(searchString, caseInsensitive);
            }
            iterator = specificMatchPropertyNames == null || specificMatchPropertyNames.isEmpty() ? new RepositorySelectedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, resultTypeGUID, searchValue, sequencingPropertyName, limitResultsByStatus, limitResultsByClassification, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName) : new RepositorySelectedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, resultTypeGUID, this.getSearchInstanceProperties(searchValue, specificMatchPropertyNames, methodName), MatchCriteria.ANY, sequencingPropertyName, limitResultsByStatus, limitResultsByClassification, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        } else {
            iterator = new RepositoryEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, resultTypeGUID, resultTypeName, sequencingPropertyName, limitResultsByStatus, limitResultsByClassification, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        }
        return iterator;
    }

    public String getBeanGUIDByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDByUniqueName(userId, name, nameParameterName, namePropertyName, resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getBeanGUIDByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(namePropertyName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, resultTypeGUID, resultTypeName, propertyNames, true, false, null, null, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        String guid = null;
        HashSet<String> duplicateEntities = new HashSet<String>();
        String entityParameterName = "Entity from search of value " + name;
        while (iterator.moreToReceive() && (queryPageSize == 0 || duplicateEntities.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            duplicateEntities.add(entity.getGUID());
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (guid != null) continue;
                guid = entity.getGUID();
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (guid == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return guid;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByUniqueName(userId, name, nameParameterName, namePropertyName, resultTypeGUID, resultTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(namePropertyName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, resultTypeGUID, resultTypeName, propertyNames, true, false, null, null, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        B bean = null;
        HashSet<String> duplicateEntities = new HashSet<String>();
        String entityParameterName = "Entity from search of value " + name;
        while (iterator.moreToReceive() && (queryPageSize == 0 || duplicateEntities.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            duplicateEntities.add(entity.getGUID());
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (bean != null) continue;
                bean = this.converter.getNewBean(this.beanClass, entity, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (bean == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return bean;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getBeanHistory(String userId, String guid, String guidParameterName, String entityTypeName, Date fromTime, Date toTime, int startingFrom, int pageSize, HistorySequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        this.validateAnchorEntity(userId, guid, guidParameterName, entityTypeName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        List entities = this.repositoryHandler.getEntityDetailHistory(userId, guid, fromTime, toTime, startingFrom, pageSize, sequencingOrder, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getBeanByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return this.converter.getNewBean(this.beanClass, results.get(0), methodName);
        }
        this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
        return null;
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeans(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<EntityDetail> findEntities(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findEntities(userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, pageSize, this.supportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> findEntities(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entityGUIDParameterName = "foundEntity.GUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        String typeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        if (metadataElementTypeName != null) {
            typeName = metadataElementTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
        ArrayList<String> subTypeGUIDs = null;
        if (metadataElementSubtypeNames != null) {
            subTypeGUIDs = new ArrayList<String>();
            for (String subTypeName : metadataElementSubtypeNames) {
                String subTypeGUID;
                if (subTypeName == null || (subTypeGUID = this.invalidParameterHandler.validateTypeName(subTypeName, typeName, this.serviceName, methodName, this.repositoryHelper)) == null) continue;
                subTypeGUIDs.add(subTypeGUID);
            }
        }
        RepositoryFindEntitiesIterator iterator = new RepositoryFindEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, typeGUID, subTypeGUIDs, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, queryPageSize, effectiveTime, methodName);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        ArrayList<String> validatedAnchorGUIDs = new ArrayList<String>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entity, methodName);
            if (anchorIdentifiers == null || anchorIdentifiers.anchorGUID == null || !validatedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) {
                this.validateAnchorEntity(userId, entity.getGUID(), entity.getType().getTypeDefName(), entity, "foundEntity.GUID", false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
                    validatedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
                }
            }
            results.add(entity);
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByIntValue(String userId, int value, String resultTypeGUID, String resultTypeName, String propertyName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByIntValue(userId, value, resultTypeGUID, resultTypeName, propertyName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByType(userId, resultTypeGUID, resultTypeName, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, null, resultTypeGUID, resultTypeName, null, false, false, sequencingPropertyName, null, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        String entityParameterName = "Entity of type" + resultTypeName;
        int skippedValues = 0;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                boolean beanArchived = false;
                try {
                    if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, methodName) != null) {
                        beanArchived = true;
                    }
                }
                catch (ClassificationErrorException classificationErrorException) {
                    // empty catch block
                }
                if (beanArchived) continue;
                if (skippedValues < startFrom) {
                    ++skippedValues;
                    continue;
                }
                results.add(entity);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> findEntities(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, String sequencingPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findEntities(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, requiredClassificationName, omittedClassificationName, sequencingPropertyName, startFrom, pageSize, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> findEntities(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, String sequencingPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.getEntitiesByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, false, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByIntValue(String userId, int value, String resultTypeGUID, String resultTypeName, String propertyName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyParameterName = "propertyName";
        String entityParameterName = "Entity from search of value " + value;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<String> limitResultsByClassification = null;
        if (requiredClassificationName != null) {
            limitResultsByClassification = new ArrayList<String>();
            limitResultsByClassification.add(requiredClassificationName);
        }
        RepositorySelectedEntitiesIterator iterator = new RepositorySelectedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, resultTypeGUID, this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, propertyName, value, methodName), MatchCriteria.ANY, sequencingPropertyName, null, limitResultsByClassification, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        return this.getEntitiesByValue(userId, (RepositoryIteratorForEntities)iterator, entityParameterName, resultTypeName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, queryPageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, boolean caseInsensitive, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(value, valueParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<String> limitResultsByClassifications = null;
        if (requiredClassificationName != null) {
            limitResultsByClassifications = new ArrayList<String>();
            limitResultsByClassifications.add(requiredClassificationName);
        }
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, value, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, caseInsensitive, sequencingPropertyName, null, limitResultsByClassifications, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        String entityParameterName = "Entity from search of value " + value;
        return this.getEntitiesByValue(userId, iterator, entityParameterName, resultTypeName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, queryPageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, RepositoryIteratorForEntities iterator, String entityParameterName, String resultTypeName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int queryPageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        ArrayList<String> validatedAnchorEntities = new ArrayList<String>();
        int skippedValues = 0;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            boolean beanValid = true;
            try {
                AnchorIdentifiers anchorIdentifiers;
                if (omittedClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException classificationErrorException) {
                        // empty catch block
                    }
                }
                if ((anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entity, methodName)) == null || anchorIdentifiers.anchorGUID == null || !validatedAnchorEntities.contains(anchorIdentifiers.anchorGUID)) {
                    this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
                        validatedAnchorEntities.add(anchorIdentifiers.anchorGUID);
                    }
                }
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException invisibleEntity) {
                beanValid = false;
            }
            if (!beanValid) continue;
            if (skippedValues < startFrom) {
                ++skippedValues;
                continue;
            }
            results.add(entity);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<String> getEntityGUIDsByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<String> results = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(entity.getGUID());
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public EntityDetail getEntityByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getEntityByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getEntityByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results != null) {
            if (results.size() == 1) {
                return results.get(0);
            }
            if (results.size() > 1) {
                this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
            }
        }
        return null;
    }

    public String getEntityGUIDByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail result = this.getEntityByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (result != null) {
            return result.getGUID();
        }
        return null;
    }

    public List<String> findBeanGUIDs(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityGUIDsByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, sequencingPropertyName, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByCreator(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(searchString, searchStringParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, searchString, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, sequencingPropertyName, null, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        String entityParameterName = "Entity from createdBy search of " + searchString;
        int skippedValues = 0;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy())) continue;
            try {
                Object bean;
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                boolean beanArchived = false;
                try {
                    if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, methodName) != null) {
                        beanArchived = true;
                    }
                }
                catch (ClassificationErrorException classificationErrorException) {
                    // empty catch block
                }
                if (beanArchived || (bean = this.converter.getNewBean(this.beanClass, entity, methodName)) == null) continue;
                if (skippedValues < startFrom) {
                    ++skippedValues;
                    continue;
                }
                results.add(bean);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByType(userId, resultTypeGUID, resultTypeName, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, resultTypeGUID, resultTypeName, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null && !entities.isEmpty()) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                Object bean;
                if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> getBeanGUIDsByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDsByType(userId, resultTypeGUID, resultTypeName, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getBeanGUIDsByType(String userId, String resultTypeGUID, String resultTypeName, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, null, resultTypeGUID, resultTypeName, null, false, false, sequencingPropertyName, null, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        ArrayList<String> results = new ArrayList<String>();
        String entityParameterName = "Entity of type" + resultTypeName;
        int skippedValues = 0;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (skippedValues < startFrom) {
                    ++skippedValues;
                    continue;
                }
                results.add(entity.getGUID());
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getBeansByClassification(String userId, String resultTypeGUID, String resultClassificationName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, resultClassificationName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList beans = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                beans.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public List<String> getBeanGUIDsByClassification(String userId, String resultTypeGUID, String resultClassificationName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, resultClassificationName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<String> softwareServerCapabilityGUIDs = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                softwareServerCapabilityGUIDs.add(entity.getGUID());
            }
            if (!softwareServerCapabilityGUIDs.isEmpty()) {
                return softwareServerCapabilityGUIDs;
            }
        }
        return null;
    }

    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String relationshipTypeGUID, String relationshipTypeName, Date effectiveFrom, Date effectiveTo, Map<String, Object> relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, relationshipProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingElementGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Iterator iterator;
        Object guids;
        String attachingGUID;
        String startingGUID;
        block22: {
            String attachingElementAnchorGUID;
            String startingElementAnchorGUID;
            Relationship newRelationship;
            int actionOrdinal;
            String actionDescriptionTemplate;
            EntityDetail attachingElementAnchorEntity;
            EntityDetail attachingElementEntity;
            EntityDetail startingElementAnchorEntity;
            EntityDetail startingElementEntity;
            block18: {
                block23: {
                    block21: {
                        block19: {
                            List existingRelationships;
                            block20: {
                                this.invalidParameterHandler.validateUserId(userId, methodName);
                                this.invalidParameterHandler.validateGUID(startingElementGUID, startingGUIDParameterName, methodName);
                                this.invalidParameterHandler.validateGUID(attachingElementGUID, attachingGUIDParameterName, methodName);
                                startingGUID = startingElementGUID;
                                attachingGUID = attachingElementGUID;
                                startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingElementGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                if (startingElementEntity != null) {
                                    startingGUID = startingElementEntity.getGUID();
                                }
                                startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                                attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                if (attachingElementEntity != null) {
                                    attachingGUID = attachingElementEntity.getGUID();
                                }
                                attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachingGUID, attachingElementTypeName, attachingElementEntity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                                existingRelationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, startingElementEntity, startingElementEntity.getType().getTypeDefName(), attachingGUID, attachmentTypeGUID, attachmentTypeName, 2, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, true, methodName);
                                if (existingRelationships == null) break block19;
                                if (existingRelationships.size() != 1) break block20;
                                actionDescriptionTemplate = "Updating link from %s %s to %s %s";
                                actionOrdinal = 1;
                                newRelationship = this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, (Relationship)existingRelationships.get(0), relationshipProperties, methodName);
                                break block21;
                            }
                            guids = null;
                            iterator = existingRelationships.iterator();
                            break block22;
                        }
                        actionDescriptionTemplate = "Linking %s %s to %s %s";
                        actionOrdinal = 0;
                        newRelationship = this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, attachingGUID, relationshipProperties, methodName);
                    }
                    if (startingElementAnchorEntity != null) break block23;
                    startingElementAnchorGUID = this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    if (startingElementAnchorGUID != null) {
                        if (attachingElementAnchorEntity != null && attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                            startingElementAnchorEntity = attachingElementAnchorEntity;
                            break block18;
                        } else {
                            String anchorGUIDParameterName = "startingElementAnchorGUID";
                            startingElementAnchorEntity = this.repositoryHandler.getEntityByGUID(userId, startingElementAnchorGUID, "startingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                        }
                        break block18;
                    } else {
                        startingElementAnchorGUID = startingGUID;
                    }
                    break block18;
                }
                startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
            }
            if (attachingElementAnchorEntity == null && (attachingElementAnchorGUID = this.reEvaluateAnchorGUID(attachingGUID, attachingGUIDParameterName, attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                if (attachingElementAnchorGUID.equals(startingElementAnchorGUID)) {
                    attachingElementAnchorEntity = startingElementAnchorEntity;
                } else {
                    String anchorGUIDParameterName = "attachingElementAnchorGUID";
                    attachingElementAnchorEntity = this.repositoryHandler.getEntityByGUID(userId, attachingElementAnchorGUID, "attachingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            String actionDescription = String.format(actionDescriptionTemplate, startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, actionOrdinal, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(startingElementEntity, 3, actionOrdinal, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (attachingElementAnchorEntity != null) {
                if (!attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, 8, actionOrdinal, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else if (!attachingGUID.equals(startingElementAnchorGUID) && attachingElementEntity != null && this.repositoryHelper.isTypeOf(this.serviceName, attachingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(attachingElementEntity, 3, actionOrdinal, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (newRelationship != null) {
                return newRelationship.getGUID();
            }
            return null;
        }
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (relationship == null) continue;
            guids = guids == null ? "[" : ", ";
            guids = (String)guids + relationship.getGUID() + " ";
        }
        guids = guids == null ? "[]" : (String)guids + "]";
        throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(new String[]{attachmentTypeName, startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID, guids, methodName, this.serverName}), this.getClass().getName(), methodName, attachmentTypeName);
    }

    public String uncheckedLinkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingElementGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingElementGUID, attachingGUIDParameterName, methodName);
        String startingGUID = startingElementGUID;
        String attachingGUID = attachingElementGUID;
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingElementGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (startingElementEntity != null) {
            startingGUID = startingElementEntity.getGUID();
        }
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        EntityDetail attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (attachingElementEntity != null) {
            attachingGUID = attachingElementEntity.getGUID();
        }
        EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachingGUID, attachingElementTypeName, attachingElementEntity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        Relationship newRelationship = this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, attachingGUID, relationshipProperties, methodName);
        if (startingElementAnchorEntity == null) {
            this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (attachingElementAnchorEntity == null) {
            this.reEvaluateAnchorGUID(attachingGUID, attachingGUIDParameterName, attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newRelationship != null) {
            return newRelationship.getGUID();
        }
        return null;
    }

    public String multiLinkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingElementGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, startingElementGUID, startingGUIDParameterName, startingElementTypeName, attachingElementGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, relationshipProperties, effectiveTime, methodName);
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, boolean isMergeUpdate, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingGUID, attachingGUIDParameterName, methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachingGUID, attachingElementTypeName, attachingElementEntity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, startingGUID, startingElementTypeName, attachingGUID, attachmentTypeGUID, attachmentTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
            String actionDescriptionTemplate = "Updating link from %s %s to %s %s";
            String actionDescription = String.format("Updating link from %s %s to %s %s", startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 1, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(startingElementEntity, 3, 1, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (attachingElementAnchorEntity != null) {
                if (!attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, 8, 1, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(attachingElementEntity, 3, 1, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(attachingGUID, attachingGUIDParameterName, attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, Map<String, Object> relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, relationshipProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, forLineage, forDuplicateProcessing, this.supportedZones, isMergeUpdate, this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, boolean isMergeUpdate, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (relationship != null) {
            String startingGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
            String attachingGUIDParameterName = "relationship.getEntityTwoProxy().getGUID()";
            String startingGUID = relationship.getEntityOneProxy().getGUID();
            String attachingGUID = relationship.getEntityTwoProxy().getGUID();
            String startingElementTypeName = relationship.getEntityOneProxy().getType().getTypeDefName();
            String attachingElementTypeName = relationship.getEntityTwoProxy().getType().getTypeDefName();
            EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, "relationship.getEntityOneProxy().getGUID()", startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, "relationship.getEntityOneProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
            String startingElementAnchorGUID = startingGUID;
            if (startingElementAnchorEntity != null) {
                startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
            }
            EntityDetail attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, "relationship.getEntityTwoProxy().getGUID()", attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachingGUID, attachingElementTypeName, attachingElementEntity, "relationship.getEntityTwoProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
            String actionDescriptionTemplate = "Updating link from %s %s to %s %s";
            String actionDescription = String.format("Updating link from %s %s to %s %s", startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 1, null, attachingGUID, attachingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(startingElementEntity, 3, 1, null, attachingGUID, attachingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(startingGUID, "relationship.getEntityOneProxy().getGUID()", startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (attachingElementAnchorEntity != null) {
                if (!attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, 8, 1, null, startingGUID, startingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(attachingElementEntity, 3, 1, null, startingGUID, startingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(attachingGUID, "relationship.getEntityTwoProxy().getGUID()", attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, startAtEnd1, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, attachmentTypeGUID, attachmentTypeName, relationshipProperties, effectiveTime, methodName);
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(newAttachingGUID, newAttachingGUIDParameterName, methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail newAttachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail newAttachingElementAnchorEntity = this.validateAnchorEntity(userId, newAttachingGUID, newAttachingElementTypeName, newAttachingElementEntity, newAttachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        int attachmentEntityEnd = 1;
        if (startAtEnd1) {
            attachmentEntityEnd = 2;
        }
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, startingGUID, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, attachmentEntityEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String oldAttachingGUID = "<null>";
        String oldAttachingElementTypeName = "<null";
        if (relationship != null) {
            EntityProxy proxy = startAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy();
            if (proxy != null) {
                oldAttachingGUID = proxy.getGUID();
                if (proxy.getType() != null) {
                    oldAttachingElementTypeName = proxy.getType().getTypeDefName();
                }
            }
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
        if (startAtEnd1) {
            this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, newAttachingGUID, relationshipProperties, methodName);
        } else {
            this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, newAttachingGUID, startingGUID, relationshipProperties, methodName);
        }
        String actionDescriptionTemplate = "Relinking %s %s from %s %s to %s %s";
        String actionDescription = String.format("Relinking %s %s from %s %s to %s %s", startingElementTypeName, startingGUID, oldAttachingElementTypeName, oldAttachingGUID, newAttachingElementTypeName, newAttachingGUID);
        if (startingElementAnchorEntity != null) {
            this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 0, null, newAttachingGUID, newAttachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, startingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(startingElementEntity, 3, 0, null, newAttachingGUID, newAttachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAttachingElementAnchorEntity != null) {
            if (!newAttachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                this.addLatestChangeToAnchor(newAttachingElementAnchorEntity, 8, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, newAttachingElementEntity, newAttachingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            if (this.repositoryHelper.isTypeOf(this.serviceName, newAttachingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(newAttachingElementEntity, 3, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, newAttachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeGUID, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeGUID, attachingElementTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachedGUID, attachedGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, startingGUID, startingElementTypeName, attachedGUID, attachmentTypeGUID, attachmentTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeName, relationship, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeName, Relationship relationship, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, attachmentTypeName, relationship, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeName, Relationship relationship, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String relationshipParameterName = "relationship";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachedGUID, attachedGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)relationship, "relationship", methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        String newStartingAnchorGUID = null;
        String newAttachedAnchorGUID = null;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail attachedElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachedGUID, attachedGUIDParameterName, attachedElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail attachedElementAnchorEntity = this.validateAnchorEntity(userId, attachedGUID, attachedElementTypeName, attachedElementEntity, attachedGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        if (!onlyCreatorPermitted || userId.equals(relationship.getCreatedBy())) {
            if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
                this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            }
        } else {
            throw new UserNotAuthorizedException(GenericHandlersErrorCode.ONLY_CREATOR_CAN_DELETE.getMessageDefinition(methodName, startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID, userId), this.getClass().getName(), methodName, userId);
        }
        String actionDescriptionTemplate = "Unlinking %s %s from %s %s";
        String actionDescription = String.format("Unlinking %s %s from %s %s", startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID);
        if (startingElementAnchorEntity != null) {
            this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 2, null, attachedGUID, attachedElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            newStartingAnchorGUID = this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, attachedElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(startingElementEntity, 3, 2, null, attachedGUID, attachedElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (attachedElementAnchorEntity != null) {
            if (!attachedElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                this.addLatestChangeToAnchor(attachedElementAnchorEntity, 8, 2, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            newAttachedAnchorGUID = this.reEvaluateAnchorGUID(attachedGUID, attachedGUIDParameterName, attachedElementTypeName, attachedElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, attachedElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(startingElementEntity, 3, 2, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (attachedElementAnchorEntity != null && newAttachedAnchorGUID == null) {
            try {
                ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
                anchorEntityGUIDs.add(attachedElementAnchorEntity.getGUID());
                this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, null, null, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_DELETE_UNANCHORED_BEAN.getMessageDefinition(this.serviceName, attachedGUID, attachedElementTypeName, attachedElementTypeGUID, methodName, error.getClass().getName(), error.getMessage()), error);
            }
        }
        if (startingElementAnchorEntity != null && newStartingAnchorGUID == null) {
            String startingElementTypeGUID = this.repositoryHelper.getTypeDefByName(methodName, startingElementTypeName).getGUID();
            try {
                ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
                anchorEntityGUIDs.add(startingElementAnchorEntity.getGUID());
                this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeGUID, startingElementTypeName, null, null, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_DELETE_UNANCHORED_BEAN.getMessageDefinition(this.serviceName, startingGUID, startingElementTypeName, startingElementTypeGUID, methodName, error.getClass().getName(), error.getMessage()), error);
            }
        }
    }

    public void unlinkAllElements(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntity, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, 2, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingElementTypeName, relationship, 2, methodName);
            if (entityProxy == null || entityProxy.getType() == null) continue;
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), forLineage, forDuplicateProcessing, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
        }
    }

    public String unlinkConnectedElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, String detachedElementTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> links;
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, startingGUIDParameterName, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, null, detachedElementTypeName, 0, forLineage, forDuplicateProcessing, suppliedSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships == null) {
            return null;
        }
        if (onlyCreatorPermitted) {
            links = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null || !userId.equals(relationship.getCreatedBy())) continue;
                links.add(relationship);
            }
        } else {
            links = relationships;
        }
        if (links.size() > 1) {
            this.errorHandler.handleAmbiguousRelationships(startingGUID, startingElementTypeName, attachmentTypeName, links, methodName);
        }
        EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingElementTypeName, links.get(0), 0, methodName);
        String detachedElementGUID = null;
        if (entityProxy != null && entityProxy.getType() != null) {
            detachedElementGUID = entityProxy.getGUID();
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
        }
        return detachedElementGUID;
    }

    InstanceProperties setUpEffectiveDates(InstanceProperties currentProperties, Date effectiveFrom, Date effectiveTo) {
        InstanceProperties properties = currentProperties;
        if (effectiveFrom != null || effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        return properties;
    }

    public void verifyExternalSourceIdentity(String userId, String externalSourceGUID, String externalSourceName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "externalSourceGUID";
        if (externalSourceGUID == null && externalSourceName == null) {
            return;
        }
        try {
            EntityDetail integrator = this.getEntityFromRepository(userId, externalSourceGUID, "externalSourceGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (integrator == null) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, null), this.getClass().getName(), methodName, externalSourceGUID);
            }
            String qualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrator.getProperties(), methodName);
            if (!externalSourceName.equals(qualifiedName)) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.BAD_INTEGRATOR_NAME.getMessageDefinition(this.serviceName, methodName, externalSourceName, qualifiedName, externalSourceGUID), this.getClass().getName(), methodName, externalSourceGUID);
            }
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, externalSourceGUID);
        }
    }

    public boolean isEntityATypeOf(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "GUID", methodName);
        this.invalidParameterHandler.validateObject((Object)entityTypeName, "entityTypeName", methodName);
        EntityDetail entityDetail = this.getEntityFromRepository(userId, guid, guidParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return entityDetail != null && entityDetail.getType().getTypeDefName().equals(entityTypeName);
    }

    public Map<String, List<Map<String, String>>> getSpecification(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSpecification";
        String parameterName = "refDataRelationship.getEntityTwoProxy().getGUID()";
        HashMap<String, List<Map<String, String>>> specification = new HashMap<String, List<Map<String, String>>>();
        List<Relationship> refDataRelationships = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 2, false, false, serviceSupportedZones, 0, 0, new Date(), "getSpecification");
        if (refDataRelationships != null) {
            for (Relationship refDataRelationship : refDataRelationships) {
                String propertyType;
                if (refDataRelationship == null || (propertyType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROPERTY_TYPE.name, refDataRelationship.getProperties(), "getSpecification")) == null) continue;
                EntityDetail specificationDetail = this.getEntityFromRepository(userId, refDataRelationship.getEntityTwoProxy().getGUID(), "refDataRelationship.getEntityTwoProxy().getGUID()", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, false, false, serviceSupportedZones, new Date(), "getSpecification");
                HashMap<CallSite, String> additionalProperties = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, specificationDetail.getProperties(), "getSpecification");
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<CallSite, String>();
                }
                additionalProperties.put((CallSite)((Object)(propertyType + "Name")), this.repositoryHelper.getStringProperty(this.serviceName, "preferredValue", specificationDetail.getProperties(), "getSpecification"));
                ArrayList<HashMap<CallSite, String>> properties = (ArrayList<HashMap<CallSite, String>>)specification.get(propertyType);
                if (properties == null) {
                    properties = new ArrayList<HashMap<CallSite, String>>();
                }
                properties.add(additionalProperties);
                specification.put(propertyType, properties);
            }
        }
        if (!specification.isEmpty()) {
            return specification;
        }
        return null;
    }

    public static class AnchorIdentifiers {
        public String anchorGUID = null;
        String anchorTypeName = null;
        String anchorDomainName = null;
    }
}

