/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OpenMetadataAPIRootHandler<B> {
    protected OpenMetadataAPIGenericConverter<B> converter;
    protected Class<B> beanClass;
    protected String serviceName;
    protected String serverName;
    protected OMRSRepositoryHelper repositoryHelper;
    protected RepositoryHandler repositoryHandler;
    protected InvalidParameterHandler invalidParameterHandler;
    protected String localServerUserId;
    protected OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    protected List<String> supportedZones;
    protected List<String> publishZones;
    protected List<String> defaultZones;
    protected RepositoryErrorHandler errorHandler;
    protected final List<String> qualifiedNamePropertyNamesList;
    protected static final String assetActionDescription = "userAssetMonitoring";
    protected AuditLog auditLog;

    public OpenMetadataAPIRootHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.converter = converter;
        this.beanClass = beanClass;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.localServerUserId = localServerUserId;
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
        this.publishZones = publishZones;
        this.auditLog = auditLog;
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
        this.qualifiedNamePropertyNamesList = new ArrayList<String>();
        this.qualifiedNamePropertyNamesList.add(OpenMetadataProperty.QUALIFIED_NAME.name);
    }

    public OpenMetadataAPIGenericConverter<B> getConverter() {
        return this.converter;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    public OMRSRepositoryHelper getRepositoryHelper() {
        return this.repositoryHelper;
    }

    public RepositoryHandler getRepositoryHandler() {
        return this.repositoryHandler;
    }

    public ElementStub getElementStub(EntityProxy entityProxy) throws PropertyServerException {
        String methodName = "getElementStub";
        return this.converter.getElementStub(this.beanClass, entityProxy, "getElementStub");
    }

    public List<String> getSupportedZones() {
        return this.supportedZones;
    }

    public TypeDef getTypeDefByName(String suppliedTypeName, String defaultTypeName) {
        String resultsTypeName = defaultTypeName;
        if (suppliedTypeName != null) {
            resultsTypeName = suppliedTypeName;
        }
        return this.repositoryHelper.getTypeDefByName(this.serviceName, resultsTypeName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerName() {
        return this.serverName;
    }
}

