/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataAPITemplateHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    private static final Logger log = LoggerFactory.getLogger(OpenMetadataAPITemplateHandler.class);

    public OpenMetadataAPITemplateHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createBeanFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String entityTypeGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, OpenMetadataAPIGenericBuilder propertyBuilder, List<String> serviceSupportedZones, boolean deepCopy, boolean templateSubstitute, Map<String, String> placeholderProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TemplateProgress templateProgress = new TemplateProgress();
        if (log.isDebugEnabled()) {
            log.debug("Creating new element of type " + entityTypeName + " using template " + templateGUID);
        }
        templateProgress = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, true, templateProgress, templateGUID, templateGUIDParameterName, entityTypeGUID, entityTypeName, uniqueParameterValue, uniqueParameterName, propertyBuilder, serviceSupportedZones, deepCopy, templateSubstitute, placeholderProperties, methodName);
        if (log.isDebugEnabled()) {
            log.debug("Adding SourcedFrom relationship from new element " + templateProgress.newBeanGUID + " of type " + entityTypeName + " to template " + templateGUID);
        }
        InstanceProperties relationshipProperties = null;
        if (templateProgress.sourceVersionNumber != 0L) {
            relationshipProperties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, null, OpenMetadataProperty.SOURCE_VERSION_NUMBER.name, templateProgress.sourceVersionNumber, methodName);
        }
        this.repositoryHandler.createRelationship(this.localServerUserId, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID, externalSourceGUID, externalSourceName, templateProgress.newBeanGUID, templateGUID, relationshipProperties, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.ASSET.typeName)) {
            this.auditLog.logMessage("userAssetMonitoring", GenericHandlersAuditCode.ASSET_ACTIVITY_CREATE.getMessageDefinition(userId, entityTypeName, templateProgress.newBeanGUID, methodName, this.serviceName));
        }
        return templateProgress.newBeanGUID;
    }

    private TemplateProgress createBeanFromTemplate(String userId, String externalSourceGUID, String externalSourceName, boolean firstIteration, TemplateProgress templateProgress, String templateGUID, String templateGUIDParameterName, String entityTypeGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, OpenMetadataAPIGenericBuilder propertyBuilder, List<String> serviceSupportedZones, boolean deepCopy, boolean templateSubstitute, Map<String, String> placeholderProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Classification templateSubstituteClassification;
        String newEntityParameterName = "newEntityGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        boolean forLineage = true;
        boolean forDuplicateProcessing = false;
        Date effectiveTime = new Date();
        if (log.isDebugEnabled()) {
            log.debug(templateProgress.toString());
        }
        EntityDetail templateEntity = this.repositoryHandler.getEntityByGUID(userId, templateGUID, templateGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (firstIteration && templateEntity != null && (templateSubstituteClassification = this.getExistingClassification((EntitySummary)templateEntity, OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION.typeName)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Template entity " + templateEntity.getGUID() + " is a template substitute - retrieving real template.");
            }
            templateEntity = this.getAttachedEntity(userId, templateEntity.getGUID(), templateGUIDParameterName, entityTypeName, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, entityTypeName, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        if (templateEntity != null) {
            List<Classification> builderClassifications;
            if (log.isDebugEnabled()) {
                log.debug("Using template entity " + templateEntity.getGUID());
            }
            templateProgress.sourceVersionNumber = templateEntity.getVersion();
            EntityDetail templateAnchorEntity = this.validateAnchorEntity(userId, templateGUID, entityTypeName, templateEntity, templateGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (templateAnchorEntity != null) {
                if (firstIteration && !templateGUID.equals(templateAnchorEntity.getGUID())) {
                    templateProgress.beanAnchorGUID = templateAnchorEntity.getGUID();
                    templateProgress.beanAnchorTypeName = templateAnchorEntity.getType().getTypeDefName();
                    templateProgress.beanAnchorDomainName = this.getDomainName((EntitySummary)templateAnchorEntity);
                }
                templateProgress.templateAnchorGUIDs.add(templateAnchorEntity.getGUID());
            }
            if (templateProgress.beanAnchorGUID != null && !propertyBuilder.isClassificationSet(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName)) {
                propertyBuilder.setAnchors(userId, templateProgress.beanAnchorGUID, templateProgress.beanAnchorTypeName, templateProgress.beanAnchorDomainName, methodName);
            }
            if (firstIteration && templateSubstitute) {
                propertyBuilder.setTemplateSubstitute(userId, methodName);
            }
            propertyBuilder.setTemplateProperties(templateEntity.getProperties(), placeholderProperties);
            propertyBuilder.setTemplateClassifications(userId, externalSourceGUID, externalSourceName, templateEntity.getClassifications(), placeholderProperties, methodName);
            this.validateNewEntityRequest(userId, templateEntity.getType().getTypeDefGUID(), templateEntity.getType().getTypeDefName(), propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(), propertyBuilder.getInstanceStatus(), effectiveTime, methodName);
            HashMap<String, Classification> newClassificationMap = new HashMap<String, Classification>();
            if (templateEntity.getClassifications() != null) {
                for (Classification templateClassification : templateEntity.getClassifications()) {
                    if (templateClassification == null || OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName.equals(templateClassification.getName()) || OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName.equals(templateClassification.getName()) || OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(templateClassification.getName())) continue;
                    newClassificationMap.put(templateClassification.getName(), templateClassification);
                }
            }
            if ((builderClassifications = propertyBuilder.getEntityClassifications()) != null) {
                for (Classification builderClassification : builderClassifications) {
                    if (builderClassification == null) continue;
                    newClassificationMap.put(builderClassification.getName(), builderClassification);
                }
            }
            ArrayList newClassifications = null;
            if (!newClassificationMap.isEmpty()) {
                newClassifications = new ArrayList(newClassificationMap.values());
            }
            String newEntityGUID = this.repositoryHandler.createEntity(userId, templateEntity.getType().getTypeDefGUID(), templateEntity.getType().getTypeDefName(), externalSourceGUID, externalSourceName, propertyBuilder.getInstanceProperties(methodName), newClassifications, propertyBuilder.getInstanceStatus(), methodName);
            if (firstIteration) {
                templateProgress.beanAnchorGUID = newEntityGUID;
                templateProgress.beanAnchorTypeName = templateEntity.getType().getTypeDefName();
                templateProgress.beanAnchorDomainName = this.getDomainName((EntitySummary)templateEntity);
            }
            if (deepCopy) {
                templateProgress = this.addAttachmentsFromTemplate(userId, externalSourceGUID, externalSourceName, templateProgress, newEntityGUID, templateGUID, entityTypeName, uniqueParameterValue, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, placeholderProperties, methodName);
            }
            templateProgress.newBeanGUID = newEntityGUID;
        } else {
            templateProgress.newBeanGUID = null;
        }
        return templateProgress;
    }

    private TemplateProgress addAttachmentsFromTemplate(String userId, String externalSourceGUID, String externalSourceName, TemplateProgress templateProgress, String startingGUID, String templateGUID, String expectedTypeName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, Map<String, String> placeholderProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nextTemplateEntityGUIDParameterName = "nextTemplateEntity.getGUID";
        String nextQualifiedNameParameterName = "nextQualifiedName";
        String nextBeanEntityGUIDParameterName = "nextBeanEntityGUID";
        HashMap<CallSite, Integer> qualifiedNameUsageCount = new HashMap<CallSite, Integer>();
        String previousTemplateGUID = templateProgress.previousTemplateGUID;
        templateProgress.previousTemplateGUID = templateGUID;
        templateProgress.coveredGUIDMap.put(templateGUID, startingGUID);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, templateGUID, expectedTypeName, null, null, 0, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            String startingGUIDParameterName;
            String nextBeanEntityGUID;
            EntityDetail nextTemplateEntity;
            boolean relationshipOneToTwo;
            Relationship relationship = iterator.getNext();
            EntityProxy entityProxy = relationship.getEntityOneProxy();
            if (templateGUID.equals(entityProxy.getGUID())) {
                entityProxy = relationship.getEntityTwoProxy();
                relationshipOneToTwo = true;
            } else {
                relationshipOneToTwo = false;
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName)) continue;
            Classification templateSubstituteClassification = this.getExistingClassification((EntitySummary)entityProxy, OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION.typeName);
            if (templateSubstituteClassification != null) {
                List<Relationship> realRelationships;
                if (log.isDebugEnabled()) {
                    log.debug("Template entity " + entityProxy.getGUID() + " is a template substitute - retrieving real template.");
                }
                if ((realRelationships = this.getAttachmentLinks(userId, entityProxy.getGUID(), "nextTemplateEntity.getGUID", entityProxy.getType().getTypeDefName(), OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, null, entityProxy.getType().getTypeDefName(), 2, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, 0, effectiveTime, methodName)) != null) {
                    for (Relationship realRelationship : realRelationships) {
                        if (realRelationship == null) continue;
                        entityProxy = realRelationship.getEntityTwoProxy();
                    }
                }
            }
            if (entityProxy == null || entityProxy.getType() == null || entityProxy.getGUID().equals(previousTemplateGUID) || (nextTemplateEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "nextTemplateEntity.getGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null || nextTemplateEntity.getType() == null) continue;
            String nextTemplateEntityTypeGUID = nextTemplateEntity.getType().getTypeDefGUID();
            String nextTemplateEntityTypeName = nextTemplateEntity.getType().getTypeDefName();
            EntityDetail nextTemplateEntityAnchor = this.validateAnchorEntity(userId, nextTemplateEntity.getGUID(), null, nextTemplateEntity, "nextTemplateEntity.getGUID", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            String nextTemplateAnchorGUID = null;
            if (nextTemplateEntityAnchor != null) {
                nextTemplateAnchorGUID = nextTemplateEntityAnchor.getGUID();
            }
            if (templateProgress.coveredGUIDMap.containsKey(nextTemplateEntity.getGUID())) {
                nextBeanEntityGUID = templateProgress.coveredGUIDMap.get(nextTemplateEntity.getGUID());
            } else if (nextTemplateAnchorGUID == null || !templateProgress.templateAnchorGUIDs.contains(nextTemplateAnchorGUID)) {
                nextBeanEntityGUID = nextTemplateEntity.getGUID();
            } else {
                OpenMetadataAPIGenericBuilder builder;
                String nextQualifiedName = null;
                if (qualifiedName != null && this.repositoryHelper.isTypeOf(this.serviceName, nextTemplateEntityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                    templateProgress.templateAnchorGUIDs.add(nextTemplateEntity.getGUID());
                    nextQualifiedName = qualifiedName + "::" + nextTemplateEntityTypeName;
                    int nextQualifiedNameCount = 0;
                    if (qualifiedNameUsageCount.get(nextQualifiedName) != null) {
                        nextQualifiedNameCount = (Integer)qualifiedNameUsageCount.get(nextQualifiedName);
                    }
                    qualifiedNameUsageCount.put((CallSite)((Object)nextQualifiedName), nextQualifiedNameCount + 1);
                    if (nextQualifiedNameCount > 0) {
                        nextQualifiedName = nextQualifiedName + "_" + nextQualifiedNameCount;
                    }
                    builder = new ReferenceableBuilder(nextQualifiedName, null, nextTemplateEntityTypeGUID, nextTemplateEntityTypeName, null, nextTemplateEntity.getStatus(), this.repositoryHelper, this.serviceName, this.serverName);
                } else {
                    builder = new OpenMetadataAPIGenericBuilder(nextTemplateEntityTypeGUID, nextTemplateEntityTypeName, null, nextTemplateEntity.getStatus(), null, this.repositoryHelper, this.serviceName, this.serverName);
                }
                builder.setTemplateProperties(nextTemplateEntity.getProperties(), placeholderProperties);
                builder.setTemplateClassifications(userId, externalSourceGUID, externalSourceName, nextTemplateEntity.getClassifications(), placeholderProperties, methodName);
                templateProgress = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, false, templateProgress, nextTemplateEntity.getGUID(), "nextTemplateEntity.getGUID", nextTemplateEntity.getType().getTypeDefGUID(), nextTemplateEntityTypeName, nextQualifiedName, "nextQualifiedName", builder, serviceSupportedZones, true, false, placeholderProperties, methodName);
                nextBeanEntityGUID = templateProgress.newBeanGUID;
            }
            InstanceProperties relationshipProperties = relationship.getProperties();
            if (relationshipProperties != null) {
                OpenMetadataAPIGenericBuilder builder = new OpenMetadataAPIGenericBuilder(relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), this.repositoryHelper, this.serviceName, this.serverName);
                relationshipProperties = builder.replaceStringPropertiesWithPlaceholders(relationshipProperties, placeholderProperties);
            }
            if (relationshipOneToTwo) {
                startingGUIDParameterName = "templateRelationshipEnd1.getGUID()";
                this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, "templateRelationshipEnd1.getGUID()", expectedTypeName, nextBeanEntityGUID, "nextBeanEntityGUID", nextTemplateEntityTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationshipProperties, effectiveTime, methodName);
                continue;
            }
            startingGUIDParameterName = "templateRelationshipEnd2.getGUID()";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, nextBeanEntityGUID, "nextBeanEntityGUID", nextTemplateEntityTypeName, startingGUID, "templateRelationshipEnd2.getGUID()", expectedTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationshipProperties, effectiveTime, methodName);
        }
        return templateProgress;
    }

    static class TemplateProgress {
        String newBeanGUID = null;
        long sourceVersionNumber = 0L;
        String previousTemplateGUID = null;
        Map<String, String> coveredGUIDMap = new HashMap<String, String>();
        List<String> templateAnchorGUIDs = new ArrayList<String>();
        String beanAnchorGUID = null;
        String beanAnchorTypeName = null;
        String beanAnchorDomainName = null;

        TemplateProgress() {
        }

        public String toString() {
            return "TemplateProgress{newBeanGUID='" + this.newBeanGUID + "', sourceVersionNumber=" + this.sourceVersionNumber + ", previousTemplateGUID='" + this.previousTemplateGUID + "', coveredGUIDMap=" + this.coveredGUIDMap + ", templateAnchorGUIDs=" + this.templateAnchorGUIDs + ", beanAnchorGUID='" + this.beanAnchorGUID + "', beanAnchorTypeName='" + this.beanAnchorTypeName + "', beanAnchorDomainName='" + this.beanAnchorDomainName + "'}";
        }
    }
}

