/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ProjectBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private String name = null;
    private String description = null;
    private Date startDate = null;
    private Date plannedEndDate = null;
    private String projectPhase = null;
    private String projectHealth = null;
    private String projectStatus = null;
    private int priority = 0;

    public ProjectBuilder(String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectPhase, String projectHealth, String projectStatus, int priority, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.startDate = startDate;
        this.plannedEndDate = plannedEndDate;
        this.projectPhase = projectPhase;
        this.projectHealth = projectHealth;
        this.projectStatus = projectStatus;
        this.priority = priority;
    }

    public ProjectBuilder(String qualifiedName, String identifier, String name, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
    }

    ProjectBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.PROJECT.typeGUID, OpenMetadataType.PROJECT.typeName, repositoryHelper, serviceName, serverName);
    }

    public void setCampaignClassification(String userId, String methodName) throws InvalidParameterException {
        this.setProjectTypeClassification(userId, OpenMetadataType.CAMPAIGN_CLASSIFICATION.typeName, methodName);
    }

    public void setTaskClassification(String userId, String methodName) throws InvalidParameterException {
        this.setProjectTypeClassification(userId, OpenMetadataType.TASK_CLASSIFICATION.typeName, methodName);
    }

    public void setProjectTypeClassification(String userId, String classificationName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, classificationName);
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IDENTIFIER.name, this.identifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.START_DATE.name, this.startDate, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PLANNED_END_DATE.name, this.plannedEndDate, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROJECT_PHASE.name, this.projectPhase, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROJECT_HEALTH.name, this.projectHealth, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROJECT_STATUS.name, this.projectStatus, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PRIORITY.name, this.priority, methodName);
        return properties;
    }
}

