/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceDataHandler<VALID_VALUE, VALID_VALUE_ASSIGNMENT, VALID_VALUE_ASSIGNMENT_DEF, VALID_VALUE_IMPLEMENTATION, VALID_VALUE_IMPLEMENTATION_DEF, VALID_VALUE_MAPPING, REFERENCE_VALUE_ASSIGNMENT, REFERENCE_VALUE_ASSIGNED_ITEM>
extends ValidValuesHandler<VALID_VALUE> {
    private final OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT> validValueAssignmentConverter;
    private final Class<VALID_VALUE_ASSIGNMENT> validValueAssignmentClass;
    private final OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefConverter;
    private final Class<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefClass;
    private final OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION> validValueImplementationConverter;
    private final Class<VALID_VALUE_IMPLEMENTATION> validValueImplementationClass;
    private final OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefConverter;
    private final Class<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefClass;
    private final OpenMetadataAPIGenericConverter<VALID_VALUE_MAPPING> validValueMappingConverter;
    private final Class<VALID_VALUE_MAPPING> validValueMappingClass;
    private final OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentConverter;
    private final Class<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentClass;
    private final OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemConverter;
    private final Class<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemClass;

    public ReferenceDataHandler(OpenMetadataAPIGenericConverter<VALID_VALUE> converter, Class<VALID_VALUE> beanClass, OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT> validValueAssignmentConverter, Class<VALID_VALUE_ASSIGNMENT> validValueAssignmentClass, OpenMetadataAPIGenericConverter<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefConverter, Class<VALID_VALUE_ASSIGNMENT_DEF> validValueAssignmentDefClass, OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION> validValueImplementationConverter, Class<VALID_VALUE_IMPLEMENTATION> validValueImplementationClass, OpenMetadataAPIGenericConverter<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefConverter, Class<VALID_VALUE_IMPLEMENTATION_DEF> validValueImplementationDefClass, OpenMetadataAPIGenericConverter<VALID_VALUE_MAPPING> validValueMappingConverter, Class<VALID_VALUE_MAPPING> validValueMappingClass, OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentConverter, Class<REFERENCE_VALUE_ASSIGNMENT> referenceValueAssignmentClass, OpenMetadataAPIGenericConverter<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemConverter, Class<REFERENCE_VALUE_ASSIGNED_ITEM> referenceValueAssignedItemClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.validValueAssignmentConverter = validValueAssignmentConverter;
        this.validValueAssignmentClass = validValueAssignmentClass;
        this.validValueAssignmentDefConverter = validValueAssignmentDefConverter;
        this.validValueAssignmentDefClass = validValueAssignmentDefClass;
        this.validValueImplementationConverter = validValueImplementationConverter;
        this.validValueImplementationClass = validValueImplementationClass;
        this.validValueImplementationDefConverter = validValueImplementationDefConverter;
        this.validValueImplementationDefClass = validValueImplementationDefClass;
        this.validValueMappingConverter = validValueMappingConverter;
        this.validValueMappingClass = validValueMappingClass;
        this.referenceValueAssignmentConverter = referenceValueAssignmentConverter;
        this.referenceValueAssignmentClass = referenceValueAssignmentClass;
        this.referenceValueAssignedItemConverter = referenceValueAssignedItemConverter;
        this.referenceValueAssignedItemClass = referenceValueAssignedItemClass;
    }

    public void linkValidValueToImplementation(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String assetGUID, String symbolicName, String implementationValue, Map<String, String> additionalValues, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        InstanceProperties properties = null;
        if (symbolicName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "symbolicName", symbolicName, methodName);
        }
        if (implementationValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "implementationValue", implementationValue, methodName);
        }
        if (additionalValues != null && !additionalValues.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalValues", additionalValues, methodName);
        }
        this.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void unlinkValidValueFromImplementation(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void mapValidValues(String userId, String externalSourceGUID, String externalSourceName, String validValue1GUID, String validValue2GUID, String associationDescription, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "associationDescription", associationDescription, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.NOTES.name, notes, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, validValue2GUID, "validValue2GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValue1GUID, "validValue1GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unmapValidValues(String userId, String externalSourceGUID, String externalSourceName, String validValue1GUID, String validValue2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, validValue2GUID, "validValue2GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValue1GUID, "validValue1GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<VALID_VALUE_ASSIGNMENT> getValidValuesAssignmentConsumers(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.REFERENCEABLE.typeName, 1, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_ASSIGNMENT> results = new ArrayList<VALID_VALUE_ASSIGNMENT>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end1.guid", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), OpenMetadataType.REFERENCEABLE.typeName, consumerEntity, "relationship.end1.guid", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                VALID_VALUE_ASSIGNMENT bean = this.validValueAssignmentConverter.getNewBean(this.validValueAssignmentClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_ASSIGNMENT_DEF> getValidValuesAssignmentDefinition(String userId, String referenceableGUID, String referenceableGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, referenceableGUIDParameter, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, referenceableGUID, referenceableGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_ASSIGNMENT_DEF> results = new ArrayList<VALID_VALUE_ASSIGNMENT_DEF>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end2.guid", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, consumerEntity, "relationship.end2.guid", true, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                VALID_VALUE_ASSIGNMENT_DEF bean = this.validValueAssignmentDefConverter.getNewBean(this.validValueAssignmentDefClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_IMPLEMENTATION> getValidValuesImplementationAssets(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName, null, OpenMetadataType.ASSET.typeName, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_IMPLEMENTATION> results = new ArrayList<VALID_VALUE_IMPLEMENTATION>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end1.guid", OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), OpenMetadataType.ASSET.typeName, consumerEntity, "relationship.end1.guid", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                VALID_VALUE_IMPLEMENTATION bean = this.validValueImplementationConverter.getNewBean(this.validValueImplementationClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_IMPLEMENTATION_DEF> getValidValuesImplementationDefinitions(String userId, String assetGUID, String assetGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameter, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, assetGUID, assetGUIDParameter, OpenMetadataType.ASSET.typeName, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName, null, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 1, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_IMPLEMENTATION_DEF> results = new ArrayList<VALID_VALUE_IMPLEMENTATION_DEF>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end2.guid", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, consumerEntity, "relationship.end2.guid", true, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                VALID_VALUE_IMPLEMENTATION_DEF bean = this.validValueImplementationDefConverter.getNewBean(this.validValueImplementationDefClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<VALID_VALUE_MAPPING> getValidValueMappings(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeName, null, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 0, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<VALID_VALUE_MAPPING> results = new ArrayList<VALID_VALUE_MAPPING>();
        for (Relationship relationship : relationships) {
            EntityProxy proxy;
            if (relationship == null || (proxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, relationship, 0, methodName)) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, proxy.getGUID(), "relationship.end1.guid", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, proxy.getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, consumerEntity, "relationship.end1.guid", true, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                VALID_VALUE_MAPPING bean = this.validValueMappingConverter.getNewBean(this.validValueMappingClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<REFERENCE_VALUE_ASSIGNED_ITEM> getReferenceValueAssignedItems(String userId, String validValueGUID, String validValueGUIDParameter, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end1.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, validValueGUIDParameter, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.REFERENCEABLE.typeName, 1, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<REFERENCE_VALUE_ASSIGNED_ITEM> results = new ArrayList<REFERENCE_VALUE_ASSIGNED_ITEM>();
        for (Relationship relationship : relationships) {
            EntityProxy end1;
            if (relationship == null || (end1 = relationship.getEntityOneProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "relationship.end1.guid", OpenMetadataType.REFERENCEABLE.typeName, false, false, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end1.getGUID(), OpenMetadataType.REFERENCEABLE.typeName, consumerEntity, "relationship.end1.guid", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                REFERENCE_VALUE_ASSIGNED_ITEM bean = this.referenceValueAssignedItemConverter.getNewBean(this.referenceValueAssignedItemClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<REFERENCE_VALUE_ASSIGNMENT> getReferenceValueAssignments(String userId, String referenceableGUID, String referenceableGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationship.end2.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, referenceableGUIDParameterName, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 2, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<REFERENCE_VALUE_ASSIGNMENT> results = new ArrayList<REFERENCE_VALUE_ASSIGNMENT>();
        for (Relationship relationship : relationships) {
            EntityProxy end2;
            if (relationship == null || (end2 = relationship.getEntityTwoProxy()) == null) continue;
            try {
                EntityDetail consumerEntity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "relationship.end2.guid", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, end2.getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, consumerEntity, "relationship.end2.guid", true, false, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                REFERENCE_VALUE_ASSIGNMENT bean = this.referenceValueAssignmentConverter.getNewBean(this.referenceValueAssignmentClass, consumerEntity, relationship, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

