/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableBuilder
extends OpenMetadataAPIGenericBuilder {
    protected String qualifiedName = null;
    private Map<String, String> additionalProperties = null;

    public ReferenceableBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, repositoryHelper, serviceName, serverName);
    }

    protected ReferenceableBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
    }

    protected ReferenceableBuilder(String qualifiedName, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, null, null, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, instanceStatus, null, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected void setOwnershipClassification(String userId, String owner, String ownerTypeName, String ownerPropertyName, String methodName) throws InvalidParameterException {
        if (owner != null) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOwnershipProperties(owner, ownerTypeName, ownerPropertyName, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName);
            }
        }
    }

    InstanceProperties getOwnershipProperties(String owner, String ownerTypeName, String ownerPropertyName, String methodName) {
        InstanceProperties properties = null;
        if (owner != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.OWNER.name, owner, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.OWNER_TYPE_NAME.name, ownerTypeName, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.OWNER_PROPERTY_NAME.name, ownerPropertyName, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    public void setTemplate(String userId, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, this.getTemplateProperties(name, versionIdentifier, description, additionalProperties, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName);
        }
    }

    InstanceProperties getTemplateProperties(String name, String versionIdentifier, String description, Map<String, String> additionalProperties, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NAME.name, name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VERSION_IDENTIFIER.name, versionIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getDataFieldValuesProperties(String defaultValue, List<String> sampleValues, List<String> dataPattern, List<String> namePattern, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "defaultValue", defaultValue, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "sampleValues", sampleValues, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "dataPattern", dataPattern, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "namePattern", namePattern, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    public void setMemento(String userId, Date archiveDate, String archiveUser, String archiveProcess, Map<String, String> archiveProperties, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, this.getMementoProperties(archiveDate, archiveUser, archiveProcess, archiveProperties, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName);
        }
    }

    public InstanceProperties getMementoProperties(Date archiveDate, String archiveUser, String archiveProcess, Map<String, String> archiveProperties, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, OpenMetadataProperty.ARCHIVE_DATE.name, archiveDate != null ? archiveDate : new Date(), methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_USER.name, archiveUser, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_PROCESS.name, archiveProcess, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_PROPERTIES.name, archiveProperties, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_SERVICE.name, this.serviceName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_METHOD.name, methodName, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    public void setSecurityTags(String userId, List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "SecurityTags", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getSecurityTagProperties(securityLabels, securityProperties, accessGroups, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "SecurityTags");
        }
    }

    InstanceProperties getSecurityTagProperties(List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "securityLabels", securityLabels, methodName);
        properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "securityProperties", securityProperties, methodName);
        properties = this.repositoryHelper.addStringArrayStringMapPropertyToInstance(this.serviceName, properties, "accessGroups", accessGroups, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getBusinessSignificanceProperties(String description, String scope, String businessCapabilityGUID, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "scope", scope, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapabilityGUID", businessCapabilityGUID, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getDataFlowProperties(String qualifiedName, String description, String formula, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.FORMULA.name, formula, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getControlFlowProperties(String qualifiedName, String description, String guard, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "guard", guard, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getProcessCallProperties(String qualifiedName, String description, String formula, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.FORMULA.name, formula, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getLineageMappingProperties(String qualifiedName, String description, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUALIFIED_NAME.name, this.qualifiedName, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, this.additionalProperties, methodName);
        }
        return properties;
    }
}

