/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SearchKeywordBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SearchKeywordHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public SearchKeywordHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createKeyword(String userId, String externalSourceGUID, String externalSourceName, String keywordName, String keywordDescription, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "keywordName";
        this.invalidParameterHandler.validateName(keywordName, "keywordName", methodName);
        SearchKeywordBuilder builder = new SearchKeywordBuilder(keywordName, keywordDescription, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, builder, effectiveTime, methodName);
    }

    public void updateKeywordDescription(String userId, String externalSourceGUID, String externalSourceName, String keywordGUID, String keywordGUIDParameterName, String keywordDescription, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, keywordDescription, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, keywordGUID, keywordGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, effectiveTime, methodName);
    }

    public void deleteKeyword(String userId, String externalSourceGUID, String externalSourceName, String keywordGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String keywordGUIDParameterName = "keywordGUID";
        B keyword = this.getKeyword(userId, keywordGUID, "keywordGUID", this.supportedZones, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (keyword != null) {
            if (this.repositoryHandler.countAttachedRelationshipsByType(userId, keywordGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, 2, forLineage, forDuplicateProcessing, effectiveTime, methodName) == 0) {
                this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, keywordGUID, "keywordGUID", OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                this.invalidParameterHandler.throwCannotDeleteElementInUse(keywordGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, this.serviceName, methodName);
            }
        }
    }

    public List<B> getAttachedKeywords(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, OpenMetadataType.SEARCH_KEYWORD.typeName, null, null, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getRelatedKeywords(String userId, String startingKeywordGUID, String startingKeywordGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingKeywordGUID, startingKeywordGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeGUID, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeName, OpenMetadataType.SEARCH_KEYWORD.typeName, null, null, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public B getKeyword(String userId, String guid, String guidParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> getKeywordsByName(String userId, String keyword, String keywordParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.KEYWORD.name);
        return this.getBeansByValue(userId, keyword, keywordParameterName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, propertyNames, true, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findKeywords(String userId, String searchString, String searchStringParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, null, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addKeywordToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String keywordGUID, String keywordGUIDParameterName, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, keywordGUID, keywordGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeKeywordFromElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String keywordGUID, String keywordGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, keywordGUID, keywordGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void linkRelatedKeywords(String userId, String externalSourceGUID, String externalSourceName, String keywordOneGUID, String keywordOneGUIDParameterName, String keywordTwoGUID, String keywordTwoGUIDParameterName, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, keywordOneGUID, keywordOneGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, keywordTwoGUID, keywordTwoGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeGUID, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unlinkRelatedKeywords(String userId, String externalSourceGUID, String externalSourceName, String keywordOneGUID, String keywordOneGUIDParameterName, String keywordTwoGUID, String keywordTwoGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, keywordOneGUID, keywordOneGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeName, keywordTwoGUID, keywordTwoGUIDParameterName, OpenMetadataType.SEARCH_KEYWORD.typeGUID, OpenMetadataType.SEARCH_KEYWORD.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeGUID, OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeName, effectiveTime, methodName);
    }
}

