/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SoftwareCapabilityHandler<B>
extends ReferenceableHandler<B> {
    public SoftwareCapabilityHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, OpenMetadataType.DATA_MANAGER.typeGUID, OpenMetadataType.DATA_MANAGER.typeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        builder.setFileSystemClassification(userId, format, encryption, methodName);
        String fileSystemGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_MANAGER.typeGUID, OpenMetadataType.DATA_MANAGER.typeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, builder, true, effectiveTime, methodName);
        if (fileSystemGUID != null) {
            this.setVendorProperties(userId, fileSystemGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return fileSystemGUID;
    }

    public String createSoftwareCapability(String userId, String externalSourceGUID, String externalSourceName, String specializedTypeName, String classificationName, String uniqueName, String displayName, String description, String deployedImplementationType, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String capabilityGUID;
        String typeGUID = OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID;
        String typeName = OpenMetadataType.SOFTWARE_CAPABILITY.typeName;
        if (specializedTypeName != null) {
            typeName = specializedTypeName;
            typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(uniqueName, displayName, description, deployedImplementationType, version, patchLevel, source, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (classificationName != null) {
            builder.setCapabilityTypeClassification(userId, classificationName, methodName);
        }
        if ((capabilityGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, builder, true, effectiveTime, methodName)) != null) {
            this.setVendorProperties(userId, capabilityGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return capabilityGUID;
    }

    public String createSoftwareCapabilityFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
    }

    public void addSoftwareCapabilityClassification(String userId, String externalSourceGUID, String externalSourceName, String softwareCapabilityGUID, String softwareCapabilityGUIDParameterName, String classificationName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String classificationParameterName = "classificationName";
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        this.invalidParameterHandler.validateGUID(classificationName, "classificationName", methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, softwareCapabilityGUID, softwareCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, classificationTypeGUID, classificationName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateSoftwareCapability(String userId, String externalSourceGUID, String externalSourceName, String capabilityGUID, String capabilityGUIDParameterName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeGUID = OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID;
        String typeName = OpenMetadataType.SOFTWARE_CAPABILITY.typeName;
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, capabilityGUID, capabilityGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
        this.setVendorProperties(userId, capabilityGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> getSoftwareCapabilityGUIDsByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanGUIDsByType(userId, typeGUID, typeName, null, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<B> getSoftwareServerCapabilitiesByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, typeGUID, typeName, null, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<B> getSoftwareServerCapabilitiesByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByClassification(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, classificationName, forLineage, forDuplicateProcessing, startingFrom, maxPageSize, effectiveTime, methodName);
    }

    public List<String> getSoftwareCapabilityGUIDsByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanGUIDsByClassification(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, classificationName, forLineage, forDuplicateProcessing, startingFrom, maxPageSize, effectiveTime, methodName);
    }
}

