/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final String description;
    private final String category;
    private final String usage;
    private final String scope;
    private final String preferredValue;
    private final String dataType;
    private final boolean isDeprecated;
    private final boolean isCaseSensitive;

    ValidValuesBuilder(String qualifiedName, String displayName, String description, String category, String usage, String scope, String preferredValue, String dataType, boolean isDeprecated, boolean isCaseSensitive, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.category = category;
        this.usage = usage;
        this.scope = scope;
        this.preferredValue = preferredValue;
        this.dataType = dataType;
        this.isDeprecated = isDeprecated;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "category", this.category, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, this.usage, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "scope", this.scope, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "preferredValue", this.preferredValue, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataType", this.dataType, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isCaseSensitive", this.isCaseSensitive, methodName);
        return properties;
    }
}

