/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.APIParameterListType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterListProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APIParameterListConverter<B>
extends OMFConverter<B> {
    public APIParameterListConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof APIParameterListElement) {
                APIParameterListElement bean = (APIParameterListElement)returnBean;
                if (primaryEntity != null && primaryEntity.getProperties() != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    APIParameterListProperties properties = new APIParameterListProperties();
                    InstanceProperties propertiesCopy = new InstanceProperties(primaryEntity.getProperties());
                    properties.setQualifiedName(this.removeQualifiedName(propertiesCopy));
                    properties.setDisplayName(this.removeDisplayName(propertiesCopy));
                    properties.setDescription(this.removeDescription(propertiesCopy));
                    properties.setIsDeprecated(this.removeIsDeprecated(propertiesCopy));
                    properties.setVersionNumber(this.removeVersionNumber(propertiesCopy));
                    properties.setAuthor(this.removeAuthor(propertiesCopy));
                    properties.setUsage(this.removeUsage(propertiesCopy));
                    properties.setEncodingStandard(this.removeEncodingStandard(propertiesCopy));
                    properties.setNamespace(this.removeNamespace(propertiesCopy));
                    properties.setAdditionalProperties(this.removeAdditionalProperties(propertiesCopy));
                    properties.setRequired(this.removeRequired(propertiesCopy));
                    properties.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
                    bean.setProperties(properties);
                    if (relationships != null) {
                        int parameterCount = 0;
                        for (Relationship relationship : relationships) {
                            if (relationship == null) continue;
                            EntityProxy endOne = relationship.getEntityOneProxy();
                            if (this.repositoryHelper.isTypeOf(this.serviceName, endOne.getType().getTypeDefName(), "APIOperation")) {
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "APIHeader")) {
                                    bean.setParameterListType(APIParameterListType.HEADER);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "APIRequest")) {
                                    bean.setParameterListType(APIParameterListType.REQUEST);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "APIResponse")) continue;
                                bean.setParameterListType(APIParameterListType.RESPONSE);
                                continue;
                            }
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, endOne.getType().getTypeDefName(), "APIParameter")) continue;
                            ++parameterCount;
                        }
                        bean.setParameterCount(parameterCount);
                    }
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }
}

