/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APIParameterListHandler<B>
extends ReferenceableHandler<B> {
    public APIParameterListHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private Map<String, Object> getExtendedProperties(Map<String, Object> suppliedExtendedProperties, boolean required) {
        Map<String, Object> schemaTypeExtendedProperties = suppliedExtendedProperties;
        if (schemaTypeExtendedProperties == null) {
            schemaTypeExtendedProperties = new HashMap<String, Object>();
        }
        schemaTypeExtendedProperties.put("required", required);
        return schemaTypeExtendedProperties;
    }

    public String createAPIParameterList(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, boolean required, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiOperationGUID, apiOperationGUIDParameterName, methodName);
        String typeName = "APIParameterList";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "APIParameterList", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, this.getExtendedProperties(extendedProperties, required), this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, apiOperationGUID, apiOperationGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        String apiParameterListGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (apiParameterListGUID != null) {
            String apiParameterListGUIDParameterName = "apiParameterListGUID";
            TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, relationshipTypeName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, apiParameterListGUID, "apiParameterListGUID", relationshipTypeDef.getGUID(), null, methodName);
        }
        return apiParameterListGUID;
    }

    public String createAPIParameterListFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String apiParameterListGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "ba167b12-969f-49d3-8bea-d04228d9a44b", "APIParameterList", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        if (apiParameterListGUID != null) {
            String apiParameterListGUIDParameterName = "apiParameterListGUID";
            TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, relationshipTypeName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, apiParameterListGUID, "apiParameterListGUID", relationshipTypeDef.getGUID(), null, methodName);
        }
        return apiParameterListGUID;
    }

    public void updateAPIParameterList(String userId, String externalSourceGUID, String externalSourceName, String apiParameterListGUID, String apiParameterListGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, boolean required, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiParameterListGUID, apiParameterListGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "APIParameterList";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "APIParameterList", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, this.getExtendedProperties(extendedProperties, required), this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, apiParameterListGUID, apiParameterListGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeAPIParameterList(String userId, String externalSourceGUID, String externalSourceName, String apiParameterListGUID, String apiParameterListGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, apiParameterListGUID, apiParameterListGUIDParameterName, "ba167b12-969f-49d3-8bea-d04228d9a44b", "APIParameterList", OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findAPIParameterLists(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, "ba167b12-969f-49d3-8bea-d04228d9a44b", "APIParameterList", null, null, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getBeansForEntities(userId, entities, searchStringParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAPIParameterListsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, "ba167b12-969f-49d3-8bea-d04228d9a44b", "APIParameterList", specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getBeansForEntities(userId, entities, nameParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private List<B> getBeansForEntities(String userId, List<EntityDetail> entities, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (entities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getBeanForEntity(userId, entity, guidParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> getAPIParameterListsForOperation(String userId, String apiOperationGUID, String apiOperationGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endTwoGUIDParameterName = "endTwo.guid";
        List<Relationship> relationships = this.getAttachmentLinks(userId, apiOperationGUID, apiOperationGUIDParameterName, "APIOperation", null, null, null, "APIParameterList", 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (Relationship relationship : relationships) {
                B bean;
                EntityProxy endTwo;
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, (endTwo = relationship.getEntityTwoProxy()).getType().getTypeDefName(), "SchemaType") || (bean = this.getAPIParameterListByGUID(userId, endTwo.getGUID(), "endTwo.guid", forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getAPIParameterListByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, "SchemaType", null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getBeanForEntity(userId, entity, guidParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private B getBeanForEntity(String userId, EntityDetail entity, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (entity != null) {
            List<Relationship> relationships = this.getAttachmentLinks(userId, entity, guidParameterName, "SchemaType", null, null, null, "SchemaElement", 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
            return this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName);
        }
        return null;
    }
}

