/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class AssetBuilder
extends ReferenceableBuilder {
    private String name = null;
    private String resourceName = null;
    private String versionIdentifier = null;
    private String technicalDescription = null;
    private String deployedImplementationType = null;

    protected AssetBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, repositoryHelper, serviceName, serverName);
    }

    protected AssetBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
    }

    protected AssetBuilder(String qualifiedName, String name, String resourceName, String versionIdentifier, String technicalDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.name = name;
        this.resourceName = resourceName;
        this.versionIdentifier = versionIdentifier;
        this.technicalDescription = technicalDescription;
        this.deployedImplementationType = deployedImplementationType;
    }

    protected AssetBuilder(String qualifiedName, String name, String resourceName, String versionIdentifier, String technicalDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        this.name = name;
        this.resourceName = resourceName;
        this.versionIdentifier = versionIdentifier;
        this.technicalDescription = technicalDescription;
        this.deployedImplementationType = deployedImplementationType;
    }

    protected void setAssetZones(String userId, List<String> zoneMembership, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetZoneMembership", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getZoneMembershipProperties(zoneMembership, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "AssetZoneMembership");
        }
    }

    InstanceProperties getZoneMembershipProperties(List<String> zoneMembership, String methodName) {
        InstanceProperties properties = null;
        if (zoneMembership != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ZONE_MEMBERSHIP.name, zoneMembership, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    protected void setAssetOwnership(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        if (owner != null) {
            if (ownerType == 0) {
                this.setOwnershipClassification(userId, owner, OpenMetadataType.USER_IDENTITY.typeName, null, methodName);
            } else if (ownerType == 1) {
                this.setOwnershipClassification(userId, owner, OpenMetadataType.ACTOR_PROFILE.typeName, null, methodName);
            }
            this.setOwnershipClassification(userId, owner, null, null, methodName);
        }
    }

    @Deprecated
    InstanceProperties getOwnerProperties(String owner, int ownerType, String methodName) {
        if (owner != null) {
            if (ownerType == 0) {
                return this.getOwnershipProperties(owner, OpenMetadataType.USER_IDENTITY.typeName, null, methodName);
            }
            if (ownerType == 1) {
                return this.getOwnershipProperties(owner, OpenMetadataType.ACTOR_PROFILE.typeName, null, methodName);
            }
            return this.getOwnershipProperties(owner, null, null, methodName);
        }
        return null;
    }

    void setAssetOrigin(String userId, String organization, String organizationPropertyName, String businessCapability, String businessCapabilityPropertyName, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException {
        if (organization != null || businessCapability != null || otherOriginValues != null && !otherOriginValues.isEmpty()) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOrigin", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOriginProperties(organization, organizationPropertyName, businessCapability, businessCapabilityPropertyName, otherOriginValues, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, "AssetOrigin");
            }
        }
    }

    InstanceProperties getOriginProperties(String organization, String organizationPropertyName, String businessCapability, String businessCapabilityPropertyName, Map<String, String> otherOriginValues, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "organization", organization, methodName);
        if (organization != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "organizationPropertyName", organizationPropertyName, methodName);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapability", businessCapability, methodName);
        if (businessCapability != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapabilityPropertyName", businessCapabilityPropertyName, methodName);
        }
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "otherOriginValues", otherOriginValues, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    void setReferenceData(String userId, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName);
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_NAME.name, this.resourceName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VERSION_IDENTIFIER.name, this.versionIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.technicalDescription, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, this.deployedImplementationType, methodName);
        return properties;
    }
}

