/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CertificationHandler<B>
extends GovernanceDefinitionHandler<B> {
    public CertificationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getCertifications(String userId, String parentGUID, String parentGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getCertifications(userId, parentGUID, parentGUIDParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getCertifications(String userId, String parentGUID, String parentGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, parentGUID, parentGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", null, "CertificationType", 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList results = new ArrayList();
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityParameterName = "entityProxyTwo.getGUID";
                EntityDetail entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxyTwo.getGUID", "CertificationType", null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
                results.add(this.converter.getNewBean(this.beanClass, entity, relationship, methodName));
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        return null;
    }

    public String certifyElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementTypeName, String certificationTypeGUID, String certificationTypeGUIDParameterName, String certificationTypeGUIDTypeName, String certificateGUID, Date start, Date end, String conditions, String certifiedBy, String certifiedByTypeName, String certifiedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String recipient, String recipientTypeName, String recipientPropertyName, String notes, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementTypeName, certificationTypeGUID, certificationTypeGUIDParameterName, certificationTypeGUIDTypeName, forLineage, forDuplicateProcessing, this.supportedZones, "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", this.getCertificationProperties(certificateGUID, start, end, conditions, certifiedBy, certifiedByTypeName, certifiedByPropertyName, custodian, custodianTypeName, custodianPropertyName, recipient, recipientTypeName, recipientPropertyName, notes, effectiveFrom, effectiveTo, methodName), effectiveTime, methodName);
    }

    public void updateCertification(String userId, String externalSourceGUID, String externalSourceName, String certificationGUID, String certificationGUIDParameterName, String certificateGUID, Date start, Date end, String conditions, String certifiedBy, String certifiedByTypeName, String certifiedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String recipient, String recipientTypeName, String recipientPropertyName, String notes, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, certificationGUID, certificationGUIDParameterName, "Certification", isMergeUpdate, this.getCertificationProperties(certificateGUID, start, end, conditions, certifiedBy, certifiedByTypeName, certifiedByPropertyName, custodian, custodianTypeName, custodianPropertyName, recipient, recipientTypeName, recipientPropertyName, notes, effectiveFrom, effectiveTo, methodName), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    private InstanceProperties getCertificationProperties(String certificateGUID, Date start, Date end, String conditions, String certifiedBy, String certifiedByTypeName, String certifiedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String recipient, String recipientTypeName, String recipientPropertyName, String notes, Date effectiveFrom, Date effectiveTo, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "certificateGUID", certificateGUID, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "start", start, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "end", end, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "conditions", conditions, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "certifiedBy", certifiedBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "certifiedByTypeName", certifiedByTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "certifiedByPropertyName", certifiedByPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodian", custodian, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodianTypeName", custodianTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "custodianPropertyName", custodianPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "recipient", recipient, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "recipientTypeName", recipientTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "recipientPropertyName", recipientPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "notes", notes, methodName);
        return this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
    }

    public void decertifyElement(String userId, String externalSourceGUID, String externalSourceName, String certificationGUID, String certificationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelationship(userId, externalSourceGUID, externalSourceName, certificationGUID, certificationGUIDParameterName, "Certification", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

