/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CollectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CollectionHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public CollectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createCollection(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String collectionType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String classificationName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = OpenMetadataType.COLLECTION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.COLLECTION.typeName, this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, collectionType, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (classificationName != null) {
            builder.setupCollectionClassification(userId, classificationName, methodName);
        }
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String qualifiedName, String displayName, String description, String collectionType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String typeName = OpenMetadataType.COLLECTION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.COLLECTION.typeName, this.serviceName, methodName, this.repositoryHelper);
        CollectionBuilder builder = new CollectionBuilder(qualifiedName, displayName, description, collectionType, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addFolderClassificationToCollection(String userId, String collectionGUID, String collectionGUIDParameterName, int orderBy, String orderPropertyName, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(collectionGUID, collectionGUIDParameterName, methodName);
        CollectionBuilder builder = new CollectionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.FOLDER.typeGUID, OpenMetadataType.FOLDER.typeName, builder.getFolderProperties(orderBy, orderPropertyName, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addMemberToCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String membershipRationale, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, membershipRationale, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, memberGUID, memberGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateCollectionMembership(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, String membershipRationale, String expression, int membershipStatus, String userDefinedStatus, int confidence, String createdBy, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationship;
        InstanceProperties properties = null;
        if (isMergeUpdate && (relationship = this.getUniqueAttachmentLink(userId, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, memberGUID, OpenMetadataType.REFERENCEABLE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
            properties = relationship.getProperties();
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, membershipRationale, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXPRESSION.name, expression, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MEMBERSHIP_STATUS.name, CollectionMemberStatus.getOpenTypeGUID(), CollectionMemberStatus.getOpenTypeName(), membershipStatus, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)classificationNotSupported), OpenMetadataProperty.MEMBERSHIP_STATUS.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "userDefinedStatus", userDefinedStatus, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", createdBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NOTES.name, notes, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, memberGUID, memberGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeMemberFromCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, String memberGUID, String memberGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, memberGUID, memberGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String collectionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeGUID, OpenMetadataType.COLLECTION.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findCollections(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.COLLECTION.typeGUID, OpenMetadataType.COLLECTION.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getCollectionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.COLLECTION.typeGUID, OpenMetadataType.COLLECTION.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getCollectionByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.COLLECTION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

