/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentHandler<B>
extends ReferenceableHandler<B> {
    public CommentHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String attachNewComment(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String parentGUID, String parentGUIDParameterName, int commentType, String commentText, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.attachNewComment(userId, externalSourceGUID, externalSourceName, anchorGUID, parentGUID, parentGUIDParameterName, null, commentType, commentText, isPublic, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String attachNewComment(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String parentGUID, String parentGUIDParameterName, String suppliedQualifiedName, int commentType, String commentText, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "commentText";
        String commentGUIDParameter = "commentGUID";
        String anchorGUIDParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        String qualifiedName = suppliedQualifiedName;
        if (qualifiedName == null) {
            qualifiedName = UUID.randomUUID().toString();
        }
        CommentBuilder builder = new CommentBuilder(qualifiedName, commentType, commentText, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String commentGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, builder, effectiveTime, methodName);
        if (commentGUID != null) {
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentGUID, parentGUIDParameterName, commentGUID, "commentGUID", OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, builder.getRelationshipInstanceProperties(methodName), methodName);
        }
        return commentGUID;
    }

    public void updateComment(String userId, String externalSourceGUID, String externalSourceName, String commentGUID, String commentGUIDParameterName, String qualifiedName, int commentType, String commentText, boolean isPublic, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String textParameter = "commentText";
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, commentGUID, commentGUIDParameterName, OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        CommentBuilder builder = new CommentBuilder(qualifiedName, commentType, commentText, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, commentGUIDParameterName, OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingEntity, commentGUIDParameterName, OpenMetadataType.COMMENT.typeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, null, OpenMetadataType.REFERENCEABLE.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            this.errorHandler.handleNoRelationship(commentGUID, OpenMetadataType.COMMENT.typeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, methodName);
        } else if (relationships.size() == 1) {
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationships.get(0), builder.getRelationshipInstanceProperties(methodName), methodName);
        } else {
            this.errorHandler.handleAmbiguousRelationships(commentGUID, OpenMetadataType.COMMENT.typeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, relationships, methodName);
        }
    }

    public void removeCommentFromElement(String userId, String externalSourceGUID, String externalSourceName, String commentGUID, String commentGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, commentGUID, commentGUIDParameterName, OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupAcceptedAnswer(String userId, String externalSourceGUID, String externalSourceName, String questionCommentGUID, String questionCommentGUIDParameterName, String answerCommentGUID, String answerCommentGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties instanceProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IS_PUBLIC.name, isPublic, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, questionCommentGUID, questionCommentGUIDParameterName, OpenMetadataType.COMMENT.typeName, answerCommentGUID, answerCommentGUIDParameterName, OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, instanceProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearAcceptedAnswer(String userId, String externalSourceGUID, String externalSourceName, String questionCommentGUID, String questionCommentGUIDParameterName, String answerCommentGUID, String answerCommentGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, questionCommentGUID, questionCommentGUIDParameterName, OpenMetadataType.COMMENT.typeName, answerCommentGUID, answerCommentGUIDParameterName, OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getComments(String userId, String anchorGUID, String anchorGUIDParameterName, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, anchorGUID, anchorGUIDParameterName, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, OpenMetadataType.COMMENT.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getComments(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, OpenMetadataType.COMMENT.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }
}

