/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionConverter<B>
extends OMFConverter<B> {
    public ConnectionConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ConnectionElement) {
                ConnectionElement bean = (ConnectionElement)returnBean;
                ConnectionProperties connectionProperties = new ConnectionProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    connectionProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    connectionProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    connectionProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    connectionProperties.setDescription(this.removeDescription(instanceProperties));
                    connectionProperties.setSecuredProperties(this.removeSecuredProperties(instanceProperties));
                    connectionProperties.setConfigurationProperties(this.removeConfigurationProperties(instanceProperties));
                    connectionProperties.setUserId(this.removeUserId(instanceProperties));
                    connectionProperties.setClearPassword(this.removeClearPassword(instanceProperties));
                    connectionProperties.setEncryptedPassword(this.removeEncryptedPassword(instanceProperties));
                    connectionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    connectionProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setConnectionProperties(connectionProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationships != null) {
                    ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
                    for (Relationship relationship : relationships) {
                        if (relationship == null || relationship.getType() == null) continue;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName)) {
                            EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                            InstanceProperties relationshipProperties = relationship.getProperties();
                            embeddedConnection.setPosition(this.getPosition(relationshipProperties));
                            embeddedConnection.setDisplayName(this.getDisplayName(relationshipProperties));
                            embeddedConnection.setArguments(this.getArguments(relationshipProperties));
                            embeddedConnection.setEmbeddedConnection(this.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName));
                            embeddedConnections.add(embeddedConnection);
                            continue;
                        }
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName)) {
                            bean.setConnectorType(this.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName));
                            continue;
                        }
                        if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName)) continue;
                        bean.setEndpoint(this.getElementStub(beanClass, relationship.getEntityOneProxy(), methodName));
                    }
                    if (!embeddedConnections.isEmpty()) {
                        bean.setEmbeddedConnections(embeddedConnections);
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

