/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContactDetailsBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContactDetailsHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public ContactDetailsHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getContactDetails(String userId, String profileGUID, String profileGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, profileGUID, profileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeGUID, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeName, OpenMetadataType.CONTACT_DETAILS.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public String createContactMethod(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String contactName, String contactType, int contactMethodType, String contactMethodService, String contactMethodValue, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ContactDetailsBuilder builder = new ContactDetailsBuilder(contactName, contactType, contactMethodType, contactMethodService, contactMethodValue, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, profileGUID, profileGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String contactMethodGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.CONTACT_DETAILS.typeGUID, OpenMetadataType.CONTACT_DETAILS.typeName, builder, effectiveTime, methodName);
        if (contactMethodGUID != null && profileGUID != null) {
            String contactMethodGUIDParameterName = "contactMethodGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, contactMethodGUID, "contactMethodGUID", OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeGUID, null, methodName);
        }
        return contactMethodGUID;
    }

    public void removeContactDetail(String userId, String externalSourceGUID, String externalSourceName, String contactMethodGUID, String contactMethodGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, contactMethodGUID, contactMethodGUIDParameterName, OpenMetadataType.CONTACT_DETAILS.typeGUID, OpenMetadataType.CONTACT_DETAILS.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

