/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFieldElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.display.DataFieldProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFieldConverter<B>
extends OMFConverter<B> {
    public DataFieldConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataFieldElement) {
                DataFieldElement bean = (DataFieldElement)returnBean;
                DataFieldProperties properties = new DataFieldProperties();
                if (schemaAttributeEntity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    properties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    properties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    properties.setDisplayName(this.removeDisplayName(instanceProperties));
                    properties.setDescription(this.removeDescription(instanceProperties));
                    properties.setElementPosition(this.removePosition(instanceProperties));
                    properties.setMinCardinality(this.removeMinCardinality(instanceProperties));
                    properties.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
                    properties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
                    properties.setOrderedValues(this.removeOrderedValues(instanceProperties));
                    properties.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
                    properties.setSortOrder(this.removeSortOrder(instanceProperties));
                    properties.setMinimumLength(this.removeMinimumLength(instanceProperties));
                    properties.setLength(this.removeLength(instanceProperties));
                    properties.setPrecision(this.removePrecision(instanceProperties));
                    properties.setSignificantDigits(this.removeSignificantDigits(instanceProperties));
                    properties.setIsNullable(this.removeIsNullable(instanceProperties));
                    properties.setNativeJavaClass(this.removeNativeClass(instanceProperties));
                    properties.setAliases(this.removeAliases(instanceProperties));
                    properties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (schemaType instanceof SchemaTypeElement) {
                        SchemaTypeElement schemaTypeElement = (SchemaTypeElement)schemaType;
                        this.addSchemaTypeToAttribute(schemaTypeElement, (SchemaAttributeProperties)properties);
                    }
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    properties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    bean.setProperties(properties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

