/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DataFieldBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFieldHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public DataFieldHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getPreviousDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        return null;
    }

    public List<B> getNewDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<Relationship> annotationRelationships = super.getAttachmentLinks(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", null, OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (annotationRelationships != null && !annotationRelationships.isEmpty()) {
            for (Relationship relationship : annotationRelationships) {
                EntityProxy annotationEnd;
                if (relationship == null || (annotationEnd = relationship.getEntityOneProxy()) == null) continue;
                String annotationEndParameterName = "annotationEnd.getGUID()";
                List<String> entityGUIDs = super.getAttachedElementGUIDs(userId, annotationEnd.getGUID(), "annotationEnd.getGUID()", OpenMetadataType.DATA_FIELD.typeName, "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", OpenMetadataType.DATA_FIELD.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
                return this.getDataFields(userId, entityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    public List<B> getNestedDataFields(String userId, String parentDataFieldGUID, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "parentDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<String> entityGUIDs = super.getAttachedElementGUIDs(userId, parentDataFieldGUID, "parentDataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, "60f2d263-e24d-4f20-8c0d-b5e12356cd54", "NestedDataField", OpenMetadataType.DATA_FIELD.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        return this.getDataFields(userId, entityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLinkedDataFields(String userId, String dataFieldGUID, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<Relationship> relationships = super.getAttachmentLinks(userId, dataFieldGUID, "dataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, "cca4b116-4490-44c4-84e1-535231ae46a1", "LinkedDataField", null, OpenMetadataType.DATA_FIELD.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            String attachedEntityGUIDParameterName = "relationship.getEntityProxyXXX().getGUID()";
            ArrayList results = new ArrayList();
            for (Relationship relationship : relationships) {
                Object bean;
                EntityProxy entityProxy;
                EntityDetail entityDetail;
                if (relationship == null || (entityDetail = super.getEntityFromRepository(userId, (entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, dataFieldGUID, relationship)).getGUID(), "relationship.getEntityProxyXXX().getGUID()", OpenMetadataType.DATA_FIELD.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null || (bean = this.converter.getNewBean(this.beanClass, entityDetail, relationship, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private List<B> getDataFields(String userId, List<String> dataFieldGUIDs, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<B> results = new ArrayList<B>();
        if (dataFieldGUIDs != null) {
            for (String entityGUID : dataFieldGUIDs) {
                B bean;
                if (entityGUID == null || (bean = this.getDataField(userId, entityGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getDataField(String userId, String dataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", methodName);
        EntityDetail entity = super.getEntityFromRepository(userId, dataFieldGUID, "dataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        List<Relationship> relationships = super.getAllAttachmentLinks(userId, dataFieldGUID, "dataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName);
    }

    private String addDataField(String userId, String externalSourceGUID, String externalSourceName, String parentEntityGUID, String parentEntityParameterName, String parentEntityType, String relationshipTypeGUID, String relationshipTypeName, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUID;
        String dataFieldNameParameterName = "dataFieldName";
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentEntityGUID, parentEntityParameterName, methodName);
        this.invalidParameterHandler.validateName(dataFieldName, "dataFieldName", methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, parentEntityGUID, parentEntityParameterName, parentEntityType, true, false, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
        DataFieldBuilder builder = new DataFieldBuilder(dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorEntity != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
        }
        if ((dataFieldGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, builder, effectiveTime, methodName)) != null) {
            InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "dataFieldPosition", dataFieldPosition, methodName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentEntityGUID, parentEntityParameterName, dataFieldGUID, "dataFieldGUID", relationshipTypeGUID, relationshipProperties, methodName);
        }
        return dataFieldGUID;
    }

    public String addDataFieldToDiscoveryReport(String userId, String externalSourceGUID, String externalSourceName, String annotationGUID, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        return this.addDataField(userId, externalSourceGUID, externalSourceName, annotationGUID, "annotationGUID", OpenMetadataType.ANNOTATION.typeName, "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", dataFieldPosition, dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addDataFieldToDataField(String userId, String externalSourceGUID, String externalSourceName, String parentDataFieldGUID, int dataFieldPosition, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentDataFieldGUIDParameterName = "parentDataFieldGUID";
        return this.addDataField(userId, externalSourceGUID, externalSourceName, parentDataFieldGUID, "parentDataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, "60f2d263-e24d-4f20-8c0d-b5e12356cd54", "NestedDataField", dataFieldPosition, dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void linkDataFields(String userId, String externalSourceGUID, String externalSourceName, String linkFromDataFieldGUID, String linkToDataFieldGUID, int relationshipEnd, String relationshipTypeName, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String linkFromDataFieldGUIDParameterName = "linkFromDataFieldGUID";
        String linkToDataFieldGUIDParameterName = "linkToDataFieldGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.RELATIONSHIP_END.name, relationshipEnd, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name, relationshipTypeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, linkFromDataFieldGUID, "linkFromDataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, linkToDataFieldGUID, "linkToDataFieldGUID", OpenMetadataType.DATA_FIELD.typeName, forLineage, forDuplicateProcessing, this.supportedZones, "cca4b116-4490-44c4-84e1-535231ae46a1", "LinkedDataField", relationshipProperties, null, null, effectiveTime, methodName);
    }

    public void updateDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, boolean isMergeUpdate, String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        DataFieldBuilder builder = new DataFieldBuilder(dataFieldName, dataFieldType, dataFieldDescription, dataFieldAliases, dataFieldSortOrder, defaultValue, additionalProperties, OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        super.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFieldGUID, "dataFieldGUID", OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void deleteDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", methodName);
        super.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFieldGUID, "dataFieldGUID", OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

