/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFileElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.DataFileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFileConverter<B>
extends OMFConverter<B> {
    public DataFileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataFileElement) {
                DataFileElement bean = (DataFileElement)returnBean;
                DataFileProperties fileProperties = new DataFileProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    fileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    fileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    fileProperties.setName(this.removeName(instanceProperties));
                    fileProperties.setResourceName(this.removeResourceName(instanceProperties));
                    fileProperties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    fileProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    fileProperties.setPathName(this.removePathName(instanceProperties));
                    fileProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    fileProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    fileProperties.setDeployedImplementationType(this.removeDeployedImplementationType(instanceProperties));
                    fileProperties.setFileName(this.removeFileName(instanceProperties));
                    fileProperties.setFileType(this.removeFileType(instanceProperties));
                    fileProperties.setFileExtension(this.removeFileExtension(instanceProperties));
                    fileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    fileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties(OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, entity);
                    fileProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    fileProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    fileProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    fileProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setProperties(fileProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

