/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.DatabaseManagerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.SoftwareCapabilityProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseManagerConverter<B>
extends OMFConverter<B> {
    public DatabaseManagerConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SoftwareCapabilityElement) {
                SoftwareCapabilityElement bean = (SoftwareCapabilityElement)returnBean;
                DatabaseManagerProperties databaseManagerProperties = new DatabaseManagerProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    databaseManagerProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseManagerProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseManagerProperties.setResourceName(this.removeName(instanceProperties));
                    databaseManagerProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    databaseManagerProperties.setDeployedImplementationType(this.removeCapabilityType(instanceProperties));
                    databaseManagerProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    databaseManagerProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    databaseManagerProperties.setSource(this.removeSource(instanceProperties));
                    databaseManagerProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseManagerProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties((SoftwareCapabilityProperties)databaseManagerProperties);
                } else {
                    this.handleMissingMetadataInstance(DatabaseManagerProperties.class.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

