/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;

public class DisplayDataContainerHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private static final String qualifiedNameParameterName = "qualifiedName";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE> dataContainerHandler;
    protected final RepositoryErrorHandler errorHandler;

    public DisplayDataContainerHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> dataContainerConverter, Class<SCHEMA_ATTRIBUTE> dataContainerClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(dataContainerConverter, dataContainerClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataContainerHandler = new SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>(dataContainerConverter, dataContainerClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public String createDataContainer(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, "f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String attributeTypeName = "DisplayDataContainer";
            String attributeTypeId = "f2a4ff99-1954-48c0-8081-92d1a4dfd910";
            if (typeName != null) {
                attributeTypeName = typeName;
                attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "DisplayDataContainer", this.serviceName, methodName, this.repositoryHelper);
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, null, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, parentGUID, "parentGUID", false, false, effectiveTime, this.supportedZones, schemaAttributeBuilder, methodName);
            SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":containerType", "2f5796f5-3fac-4501-9d0d-207aa8620d16", "DisplayDataSchemaType", this.repositoryHelper, this.serviceName, this.serverName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
            String dataContainerGUID = this.dataContainerHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "schemaTypeGUID", "RelationalDBSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (dataContainerGUID != null) {
                this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            return dataContainerGUID;
        }
        return null;
    }

    public String createDataContainerFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String parentGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "parentGUID";
        String parentElementGUIDParameterName = "parentGUID";
        String templateParameterName = "templateGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, "2f5796f5-3fac-4501-9d0d-207aa8620d16", "DisplayDataSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, parentGUID, "parentGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
            String dataContainerGUID = this.dataContainerHandler.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", qualifiedName, qualifiedNameParameterName, builder, this.supportedZones, true, false, null, methodName);
            if (dataContainerGUID != null) {
                String displaySchemaTypeGUIDParameterName = "displaySchemaTypeGUID";
                String dataContainerGUIDParameterName = "dataContainerGUID";
                this.dataContainerHandler.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "displaySchemaTypeGUID", dataContainerGUID, "dataContainerGUID", "86b176a2-015c-44a6-8106-54d5d69ba661", null, methodName);
                return dataContainerGUID;
            }
        }
        return null;
    }

    public void updateDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "dataContainerGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String attributeTypeName = "DisplayDataContainer";
        String attributeTypeId = "f2a4ff99-1954-48c0-8081-92d1a4dfd910";
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, "DisplayDataContainer", this.serviceName, methodName, this.repositoryHelper);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", isDeprecated, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, methodName);
            }
            catch (InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        if (effectiveFrom != null || effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        this.dataContainerHandler.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, "dataContainerGUID", attributeTypeId, attributeTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, isMergeUpdate, effectiveTime, methodName);
        this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String dataContainerGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        this.dataContainerHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, dataContainerGUIDParameterName, "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findDataContainers(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.dataContainerHandler.findSchemaAttributes(userId, searchString, "searchString", "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getContainersForParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, "2f5796f5-3fac-4501-9d0d-207aa8620d16", "DisplayDataSchemaType", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String displaySchemaTypeGUIDParameterName = "displaySchemaTypeGUID";
            return this.dataContainerHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "displaySchemaTypeGUID", null, "CalculatedValue", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getDataContainersByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataContainerHandler.getSchemaAttributesByName(userId, "f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", name, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public SCHEMA_ATTRIBUTE getDataContainerByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.dataContainerHandler.getSchemaAttribute(userId, guid, "guid", "DisplayDataContainer", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

