/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class EndpointBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final String description;
    private final String networkAddress;
    private String protocol;
    private String encryptionMethod;

    public EndpointBuilder(String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.networkAddress = networkAddress;
        this.protocol = protocol;
        this.encryptionMethod = encryptionMethod;
    }

    EndpointBuilder(String qualifiedName, String displayName, String description, String networkAddress, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.ENDPOINT.typeGUID, OpenMetadataType.ENDPOINT.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.networkAddress = networkAddress;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NETWORK_ADDRESS.name, this.networkAddress, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROTOCOL.name, this.protocol, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ENCRYPTION_METHOD.name, this.encryptionMethod, methodName);
        return properties;
    }
}

