/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EventTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.events.EventTypeProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EventTypeConverter<B>
extends OMFConverter<B> {
    public EventTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof EventTypeElement) {
                EventTypeElement bean = (EventTypeElement)returnBean;
                if (entity != null && entity.getProperties() != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    EventTypeProperties eventType = new EventTypeProperties();
                    InstanceProperties propertiesCopy = new InstanceProperties(entity.getProperties());
                    eventType.setQualifiedName(this.removeQualifiedName(propertiesCopy));
                    eventType.setDisplayName(this.removeDisplayName(propertiesCopy));
                    eventType.setDescription(this.removeDescription(propertiesCopy));
                    eventType.setIsDeprecated(this.removeIsDeprecated(propertiesCopy));
                    eventType.setVersionNumber(this.removeVersionNumber(propertiesCopy));
                    eventType.setAuthor(this.removeAuthor(propertiesCopy));
                    eventType.setUsage(this.removeUsage(propertiesCopy));
                    eventType.setEncodingStandard(this.removeEncodingStandard(propertiesCopy));
                    eventType.setNamespace(this.removeNamespace(propertiesCopy));
                    eventType.setAdditionalProperties(this.removeAdditionalProperties(propertiesCopy));
                    eventType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
                    bean.setProperties(eventType);
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

