/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EventTypeHandler<B>
extends ReferenceableHandler<B> {
    public EventTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createEventType(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(topicGUID, topicGUIDParameterName, methodName);
        String typeName = "EventType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EventType", this.serviceName, methodName, this.repositoryHelper);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveFrom, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, topicGUID, topicGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        String eventTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (eventTypeGUID != null) {
            String eventTypeGUIDParameterName = "eventTypeGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", eventTypeGUID, "eventTypeGUID", "eb4f1f98-c649-4560-8a46-da17c02764a9", null, methodName);
        }
        return eventTypeGUID;
    }

    public String createEventTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveFrom, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String eventTypeGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        String eventTypeGUIDParameterName = "eventTypeGUID";
        this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", eventTypeGUID, "eventTypeGUID", "eb4f1f98-c649-4560-8a46-da17c02764a9", null, methodName);
        return eventTypeGUID;
    }

    public void updateEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(eventTypeGUID, eventTypeGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = "EventType";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "EventType", this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findEventTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getEventTypesForEventSet(String userId, String eventSetGUID, String eventSetGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, eventSetGUID, eventSetGUIDParameterName, "EventSet", OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, "EventType", null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesForTopic(String userId, String topicGUID, String topicGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail eventTypeListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "EventTypeList", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (eventTypeListEntity != null) {
            String eventTypeListGUIDParameterName = "eventTypeListGUID";
            return this.getAttachedElements(userId, eventTypeListEntity.getGUID(), "eventTypeListGUID", "EventTypeList", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "EventType", null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    private String getEventTypeListGUID(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String topicQualifiedName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String eventTypeListGUID;
        EntityDetail eventListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "EventTypeList", 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (eventListEntity == null) {
            SchemaTypeBuilder builder = new SchemaTypeBuilder(topicQualifiedName + "_EventList", "77ccda3d-c4c6-464c-a424-4b2cb27ac06c", "EventTypeList", this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, topicGUID, topicGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            eventTypeListGUID = this.repositoryHandler.createEntity(userId, "77ccda3d-c4c6-464c-a424-4b2cb27ac06c", "EventTypeList", externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), builder.getEntityClassifications(), builder.getInstanceStatus(), methodName);
            if (eventTypeListGUID != null) {
                String eventTypeListGUIDParameterName = "eventTypeListGUID";
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, eventTypeListGUID, "eventTypeListGUID", "EventTypeList", forLineage, forDuplicateProcessing, this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            } else {
                this.errorHandler.logNullInstance("EventTypeList", methodName);
            }
        } else {
            eventTypeListGUID = eventListEntity.getGUID();
        }
        return eventTypeListGUID;
    }

    public B getEventTypeByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "EventType", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

