/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalReferenceBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String url = null;
    private String referenceVersion = null;
    private String organization = null;

    ExternalReferenceBuilder(String qualifiedName, String displayName, String description, String url, String referenceVersion, String organization, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.url = url;
        this.referenceVersion = referenceVersion;
        this.organization = organization;
    }

    public ExternalReferenceBuilder(String qualifiedName, String displayName, String description, String url, String referenceVersion, String organization, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.url = url;
        this.referenceVersion = referenceVersion;
        this.organization = organization;
    }

    ExternalReferenceBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    ExternalReferenceBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.URL.name, this.url, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REFERENCE_VERSION.name, this.referenceVersion, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ORGANIZATION.name, this.organization, methodName);
        return properties;
    }

    InstanceProperties getLinkProperties(String referenceId, String description, String methodName) {
        InstanceProperties properties = null;
        if (referenceId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.REFERENCE_ID.name, referenceId, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }
}

