/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalReferenceHandler<B>
extends ReferenceableHandler<B> {
    public ExternalReferenceHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createExternalReference(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String url, String referenceVersion, String organization, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String anchorGUIDParameterName = "anchorGUID";
        String typeName = OpenMetadataType.EXTERNAL_REFERENCE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ExternalReferenceBuilder builder = new ExternalReferenceBuilder(qualifiedName, displayName, description, url, referenceVersion, organization, additionalProperties, typeGUID, suppliedTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, builder, effectiveTime, methodName);
    }

    public void updateExternalReference(String userId, String externalSourceGUID, String externalSourceName, String externalReferenceGUID, String externalReferenceGUIDParameterName, String qualifiedName, String displayName, String description, String url, String referenceVersion, String organization, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, externalReferenceGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.EXTERNAL_REFERENCE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ExternalReferenceBuilder builder = new ExternalReferenceBuilder(qualifiedName, displayName, description, url, referenceVersion, organization, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, externalReferenceGUID, externalReferenceGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeExternalReference(String userId, String externalSourceGUID, String externalSourceName, String externalReferenceGUID, String externalReferenceGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, externalReferenceGUID, externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getExternalReferencesById(String userId, String referenceId, String referenceIdParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return this.getBeansByValue(userId, referenceId, referenceIdParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getExternalReferencesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getExternalReferencesByURL(String userId, String url, String urlParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.URL.name);
        return this.getBeansByValue(userId, url, urlParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getExternalReferences(String userId, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findExternalReferences(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

