/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalReferenceLinkHandler<B>
extends ReferenceableHandler<B> {
    private static final Logger log = LoggerFactory.getLogger(ExternalReferenceLinkHandler.class);

    public ExternalReferenceLinkHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String setupExternalReferenceLink(String userId, String externalSourceGUID, String externalSourceName, String referenceableGUID, String referenceableGUIDParameterName, String externalReferenceGUID, String externalReferenceGUIDParameterName, String referenceId, String referenceDescription, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalReferenceBuilder builder = new ExternalReferenceBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getLinkProperties(referenceId, referenceDescription, methodName);
        return this.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void updateExternalReferenceLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String referenceId, String referenceDescription, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalReferenceBuilder builder = new ExternalReferenceBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getLinkProperties(referenceId, referenceDescription, methodName);
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, relationshipGUID, relationshipGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, this.supportedZones, false, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public Relationship clearExternalReferenceLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String referenceableGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
        String externalReferenceGUIDParameterName = "relationship.getEntityTwoProxy().getGUID()";
        Relationship relationship = this.getAttachmentLink(userId, relationshipGUID, relationshipGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, effectiveTime, methodName);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.REFERENCEABLE.typeName, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, relationship, effectiveTime, methodName);
        return relationship;
    }

    public List<B> getExternalReferences(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, null, OpenMetadataType.EXTERNAL_REFERENCE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList results = new ArrayList();
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            try {
                Object bean;
                String entityGUIDParameterName = "entity.getGUID";
                EntityDetail entity = this.getEntityFromRepository(userId, relationship.getEntityTwoProxy().getGUID(), "entity.getGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, relationship, methodName)) == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping inaccessible entity", inaccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

