/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.AssetConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.FileFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileFolderConverter<B>
extends AssetConverter<B> {
    public FileFolderConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof FileFolderElement) {
                FileFolderElement bean = (FileFolderElement)returnBean;
                FileFolderProperties folderProperties = new FileFolderProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    folderProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    folderProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    folderProperties.setName(this.removeName(instanceProperties));
                    folderProperties.setResourceName(this.removeResourceName(instanceProperties));
                    folderProperties.setDisplayName(folderProperties.getName());
                    folderProperties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    folderProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    folderProperties.setPathName(this.removePathName(instanceProperties));
                    folderProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    folderProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    folderProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    folderProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties(OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, entity);
                    folderProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    folderProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    folderProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    folderProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setFileFolderProperties(folderProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

